/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.logger;

import com.alibaba.dts.common.exception.InitException;
import com.alibaba.dts.common.logger.timer.LoggerCleanerTimer;
import com.alibaba.dts.common.util.TimeUtil;
import java.io.File;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoggerCleaner {
    private static final Log logger = LogFactory.getLog(LoggerCleaner.class);
    public static final String SPLIT_LOGGER = ".log.";
    public static final String TIME_FORMAT_DAY = "yyyy-MM-dd";
    private ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, "LoggerCleaner-Thread");
        }
    });
    private String loggerPath;
    private long initialDelay = 86400000L;
    private long period = 86400000L;
    private int day = 3;

    public LoggerCleaner(String loggerPath) {
        this.loggerPath = loggerPath;
    }

    public LoggerCleaner(String loggerPath, int day) {
        this.loggerPath = loggerPath;
        this.day = day;
    }

    public LoggerCleaner(String loggerPath, long initialDelay, long period) {
        this.loggerPath = loggerPath;
        this.initialDelay = initialDelay;
        this.period = period;
    }

    public LoggerCleaner(String loggerPath, long initialDelay, long period, int day) {
        this.loggerPath = loggerPath;
        this.initialDelay = initialDelay;
        this.period = period;
        this.day = day;
    }

    public void init() throws InitException {
        this.initLoggerCleanerTimer();
    }

    private void initLoggerCleanerTimer() throws InitException {
        try {
            this.executorService.scheduleAtFixedRate(new LoggerCleanerTimer(this), this.initialDelay, this.period, TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            throw new InitException("[LoggerCleaner]: initLoggerCleanerTimer error", e);
        }
    }

    public void start() {
        AtomicInteger counter = new AtomicInteger(0);
        this.scan(new File(this.loggerPath), counter);
        logger.info((Object)("[LoggerCleaner]: scan, counter:" + counter.get()));
    }

    public void stop() {
        this.executorService.shutdown();
        logger.info((Object)"[LoggerCleaner]: stop!");
    }

    private void scan(File path, AtomicInteger counter) {
        if (!path.exists()) {
            logger.warn((Object)("[LoggerCleaner]: scan path not exists, path:" + path.getPath()));
            return;
        }
        File[] files = path.listFiles();
        if (null == files || files.length <= 0) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.scan(file, counter);
                continue;
            }
            try {
                Date timeLine;
                Date fileDate;
                String[] names = file.getName().split(SPLIT_LOGGER);
                if (null == names || names.length < 2 || null == (fileDate = TimeUtil.string2Date(names[1], TIME_FORMAT_DAY)) || !fileDate.before(timeLine = TimeUtil.increaseDate(new Date(), 5, -this.day))) continue;
                boolean result = false;
                try {
                    result = file.delete();
                }
                catch (Throwable e) {
                    logger.error((Object)("[LoggerCleaner]: delete file error, file:" + file.getPath() + ", timeLine:" + timeLine.toLocaleString()), e);
                }
                logger.info((Object)("[LoggerCleaner]: delete, file:" + file.getPath() + ", timeLine:" + timeLine.toLocaleString() + ", result:" + result));
                counter.incrementAndGet();
            }
            catch (Throwable e) {
                logger.error((Object)("[LoggerCleaner]: scan file error, file:" + file.getPath()), e);
            }
        }
    }
}

