/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.logger.innerlog;

import com.alibaba.dts.common.logger.innerlog.DefaultLogConfigure;
import com.alibaba.dts.common.logger.innerlog.LogConfigure;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.common.logger.innerlog.LoggerClassLoader;
import com.alibaba.dts.common.util.StringUtil;
import com.alibaba.dts.shade.org.apache.commons.lang.ArrayUtils;
import com.alibaba.dts.shade.org.apache.commons.lang.ClassUtils;
import com.alibaba.dts.shade.org.apache.commons.lang.StringUtils;
import com.alibaba.dts.shade.org.apache.commons.lang.reflect.ConstructorUtils;
import com.alibaba.dts.shade.org.apache.commons.lang.reflect.MethodUtils;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class LoggerFactory {
    private static AtomicInteger CLASS_LOADER_ID = new AtomicInteger(0);
    private static final Map<String, LoggerClassLoader> LOGGER_CONTEXT_LOADERS = new HashMap<String, LoggerClassLoader>();
    private static String APP_KEY = "SCHEDULERX";
    private static LoggerClassLoader LOGGER_CONTEXT_LOADER = new LoggerClassLoader(0);
    private static final String SYSTEM_LONGBACK_CONFIG_KEY_FORMAT = "innerlogger.{0}.logback.file";

    public static void initByClassResource(String classResource) {
        LoggerFactory.doConfigure(new DefaultLogConfigure(classResource), APP_KEY);
    }

    public static void initByFileSystem(String configFilePath) {
        LoggerFactory.doConfigure(new DefaultLogConfigure(configFilePath, Boolean.TRUE), APP_KEY);
    }

    public static synchronized void doConfigure(LogConfigure logConfigure, String appKey) {
        LoggerClassLoader loggerClassLoader;
        if (null == LOGGER_CONTEXT_LOADERS.get(appKey = LoggerFactory.defaultIfBlank(appKey, ""))) {
            LoggerFactory.bindSl4j(appKey);
        }
        if ((loggerClassLoader = LOGGER_CONTEXT_LOADERS.get(appKey)).isConfigure()) {
            return;
        }
        InputStream inputStream = null;
        String systemConfKey = MessageFormat.format(SYSTEM_LONGBACK_CONFIG_KEY_FORMAT, appKey);
        String systemConfPath = System.getProperty(systemConfKey, System.getenv(systemConfKey));
        if (StringUtils.isNotBlank(systemConfPath)) {
            inputStream = LogConfigure.getResourceFromFileSystem(systemConfPath);
        }
        if (null == inputStream && null != logConfigure) {
            inputStream = logConfigure.configure();
        }
        if (null != inputStream) {
            try {
                Class JoranConfClass = ClassUtils.getClass(loggerClassLoader, "ch.qos.logback.classic.joran.JoranConfigurator");
                Object JoranConfObj = ConstructorUtils.invokeConstructor(JoranConfClass, ArrayUtils.EMPTY_OBJECT_ARRAY);
                MethodUtils.invokeMethod(JoranConfObj, "setContext", loggerClassLoader.getInnerFactory());
                MethodUtils.invokeMethod(JoranConfObj, "doConfigure", inputStream);
                loggerClassLoader.setConfigure(true);
            }
            catch (Exception e) {
                throw new RuntimeException("doConfigure logback Error! ", e);
            }
            finally {
                if (null != inputStream) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
    }

    public static Logger getLogger(String logName, String appKey) {
        return LoggerFactory.getWrapperLogger(logName, appKey);
    }

    public static Logger getLogger(Class<?> clazz, String appKey) {
        return LoggerFactory.getWrapperLogger(clazz.getName(), appKey);
    }

    private static synchronized void bindSl4j(LoggerClassLoader loggerClassLoader) {
        try {
            Class sl4jLogFactoryClass = ClassUtils.getClass(loggerClassLoader, "org.slf4j.LoggerFactory");
            Object innerFactory = MethodUtils.invokeExactStaticMethod(sl4jLogFactoryClass, "getILoggerFactory", ArrayUtils.EMPTY_OBJECT_ARRAY);
            loggerClassLoader.setSl4jLogFactoryClass(sl4jLogFactoryClass);
            loggerClassLoader.setInnerFactory(innerFactory);
        }
        catch (Exception e) {
            throw new RuntimeException("binding inner sl4j Error! ", e);
        }
    }

    private static synchronized LoggerClassLoader bindSl4j(String appKey) {
        try {
            LoggerClassLoader loggerClassLoader = new LoggerClassLoader(CLASS_LOADER_ID.getAndIncrement());
            Class sl4jLogFactoryClass = ClassUtils.getClass(loggerClassLoader, "org.slf4j.LoggerFactory");
            Object innerFactory = MethodUtils.invokeExactStaticMethod(sl4jLogFactoryClass, "getILoggerFactory", ArrayUtils.EMPTY_OBJECT_ARRAY);
            loggerClassLoader.setSl4jLogFactoryClass(sl4jLogFactoryClass);
            loggerClassLoader.setInnerFactory(innerFactory);
            LOGGER_CONTEXT_LOADERS.put(appKey, loggerClassLoader);
            return loggerClassLoader;
        }
        catch (Exception e) {
            throw new RuntimeException("binding inner sl4j Error! ", e);
        }
    }

    private static synchronized Logger getWrapperLogger(String loggerName, String appValue) {
        LoggerClassLoader loggerClassLoader = LOGGER_CONTEXT_LOADERS.get(appValue = LoggerFactory.defaultIfBlank(appValue, ""));
        if (null == loggerClassLoader) {
            loggerClassLoader = LoggerFactory.bindSl4j(appValue);
        }
        return new Logger(loggerClassLoader.getInnerLogger(loggerName), loggerClassLoader);
    }

    private static String defaultIfBlank(String str, String defaultStr) {
        return StringUtil.isEmpty(str) ? defaultStr : str;
    }
}

