/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.metrics;

import com.alibaba.dts.common.domain.DtsConfiguration;
import com.alibaba.dts.common.metrics.MetricsReporterFactory;
import com.alibaba.dts.common.metrics.MetricsSource;
import com.alibaba.dts.common.util.ReflectionUtil;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reporter;
import com.codahale.metrics.ScheduledReporter;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Metrics {
    public static void start(DtsConfiguration conf) throws Exception {
        MetricRegistry registry = new MetricRegistry();
        Reporter reporter = MetricsReporterFactory.createReporter(registry, conf);
        if (reporter != null) {
            if (reporter instanceof ScheduledReporter) {
                ((ScheduledReporter)reporter).start((long)conf.getInt("metrics.report.period.seconds", 60), TimeUnit.SECONDS);
            } else if (reporter instanceof JmxReporter) {
                ((JmxReporter)reporter).start();
            }
            List<MetricsSource> metricSources = ReflectionUtil.getInstancesByConf(conf, "metrics.source.list");
            for (MetricsSource metric : metricSources) {
                metric.getMetric(registry);
            }
        }
    }
}

