/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.remoting.netty;

import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.common.remoting.ChannelEventListener;
import com.alibaba.dts.common.remoting.netty.NettyDecoder;
import com.alibaba.dts.common.remoting.netty.NettyEncoder;
import com.alibaba.dts.common.remoting.netty.NettyRemotingServer;
import com.alibaba.dts.common.remoting.netty.NettyServerConfig;
import com.alibaba.dts.shade.io.netty.bootstrap.ServerBootstrap;
import com.alibaba.dts.shade.io.netty.buffer.PooledByteBufAllocator;
import com.alibaba.dts.shade.io.netty.channel.ChannelInitializer;
import com.alibaba.dts.shade.io.netty.channel.ChannelOption;
import com.alibaba.dts.shade.io.netty.channel.socket.SocketChannel;
import com.alibaba.dts.shade.io.netty.channel.socket.nio.NioServerSocketChannel;
import com.alibaba.dts.shade.io.netty.handler.timeout.IdleStateHandler;
import com.alibaba.dts.shade.io.netty.util.concurrent.DefaultEventExecutorGroup;
import com.alibaba.dts.shade.io.netty.util.concurrent.EventExecutorGroup;
import java.net.InetSocketAddress;
import java.util.TimerTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class NodeNettyRemotingServer
extends NettyRemotingServer {
    private static final Logger log = SchedulerXLoggerFactory.getLogger(NodeNettyRemotingServer.class);

    public NodeNettyRemotingServer(NettyServerConfig nettyServerConfig) {
        super(nettyServerConfig);
    }

    public NodeNettyRemotingServer(NettyServerConfig nettyServerConfig, ChannelEventListener channelEventListener) {
        super(nettyServerConfig, channelEventListener);
    }

    @Override
    public void start() {
        this.defaultEventExecutorGroup = new DefaultEventExecutorGroup(this.nettyServerConfig.getServerWorkerThreads(), new ThreadFactory(){
            private AtomicInteger threadIndex = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "NettyServerWorkerThread_" + this.threadIndex.incrementAndGet());
            }
        });
        ServerBootstrap childHandler = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.serverBootstrap.group(this.eventLoopGroupBoss, this.eventLoopGroupWorker).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, 1024)).option(ChannelOption.SO_REUSEADDR, true)).option(ChannelOption.SO_KEEPALIVE, false)).childOption(ChannelOption.TCP_NODELAY, true).option(ChannelOption.SO_SNDBUF, this.nettyServerConfig.getServerSocketSndBufSize())).option(ChannelOption.SO_RCVBUF, this.nettyServerConfig.getServerSocketRcvBufSize())).localAddress(new InetSocketAddress(this.nettyServerConfig.getListenPort()))).childHandler(new ChannelInitializer<SocketChannel>(){

            @Override
            public void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast((EventExecutorGroup)NodeNettyRemotingServer.this.defaultEventExecutorGroup, new NettyEncoder(), new NettyDecoder(), new IdleStateHandler(0, 0, NodeNettyRemotingServer.this.nettyServerConfig.getServerChannelMaxIdleTimeSeconds()), new NettyRemotingServer.NettyConnetManageHandler(), new NettyRemotingServer.NettyServerHandler());
            }
        });
        if (this.nettyServerConfig.isServerPooledByteBufAllocatorEnable()) {
            childHandler.childOption(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT);
        }
        this.boot(this.serverBootstrap);
        if (this.channelEventListener != null) {
            this.nettyEventExecuter.start();
        }
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    NodeNettyRemotingServer.this.scanResponseTable();
                }
                catch (Exception e) {
                    log.error("scanResponseTable exception", e);
                }
            }
        }, 3000L, 1000L);
    }

    public abstract void boot(ServerBootstrap var1);
}

