/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.remoting.protocol;

import com.alibaba.dts.common.annotation.CFNotNull;
import com.alibaba.dts.common.exception.RemotingCommandException;
import com.alibaba.dts.common.remoting.CommandCustomHeader;
import com.alibaba.dts.common.remoting.protocol.LanguageCode;
import com.alibaba.dts.common.remoting.protocol.RemotingCommandType;
import com.alibaba.dts.common.remoting.protocol.RemotingSerializable;
import com.alibaba.fastjson.annotation.JSONField;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class RemotingCommand {
    public static String RemotingVersionKey = "rocketmq.remoting.version";
    private static volatile int ConfigVersion = -1;
    private static AtomicInteger RequestId = new AtomicInteger(0);
    private static final int RPC_TYPE = 0;
    private static final int RPC_ONEWAY = 1;
    private int code;
    private LanguageCode language = LanguageCode.JAVA;
    private int version = 0;
    private int opaque = RequestId.getAndIncrement();
    private int flag = 0;
    private String remark;
    private HashMap<String, String> extFields;
    private transient CommandCustomHeader customHeader;
    private transient byte[] body;
    private static final String StringName = String.class.getCanonicalName();
    private static final String IntegerName1 = Integer.class.getCanonicalName();
    private static final String IntegerName2 = Integer.TYPE.getCanonicalName();
    private static final String LongName1 = Long.class.getCanonicalName();
    private static final String LongName2 = Long.TYPE.getCanonicalName();
    private static final String BooleanName1 = Boolean.class.getCanonicalName();
    private static final String BooleanName2 = Boolean.TYPE.getCanonicalName();
    private static final String DoubleName1 = Double.class.getCanonicalName();
    private static final String DoubleName2 = Double.TYPE.getCanonicalName();

    public static RemotingCommand createRequestCommand(int code, CommandCustomHeader customHeader) {
        RemotingCommand cmd = new RemotingCommand();
        cmd.setCode(code);
        cmd.customHeader = customHeader;
        RemotingCommand.setCmdVersion(cmd);
        return cmd;
    }

    public static RemotingCommand createResponseCommand(Class<? extends CommandCustomHeader> classHeader) {
        RemotingCommand cmd = RemotingCommand.createResponseCommand(1, "not set any response code", classHeader);
        return cmd;
    }

    public static RemotingCommand createResponseCommand(int code, String remark) {
        return RemotingCommand.createResponseCommand(code, remark, null);
    }

    public static RemotingCommand createResponseCommand(int code, String remark, Class<? extends CommandCustomHeader> classHeader) {
        RemotingCommand cmd = new RemotingCommand();
        cmd.markResponseType();
        cmd.setCode(code);
        cmd.setRemark(remark);
        RemotingCommand.setCmdVersion(cmd);
        if (classHeader != null) {
            try {
                CommandCustomHeader objectHeader;
                cmd.customHeader = objectHeader = classHeader.newInstance();
            }
            catch (InstantiationException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }
        return cmd;
    }

    private static void setCmdVersion(RemotingCommand cmd) {
        if (ConfigVersion >= 0) {
            cmd.setVersion(ConfigVersion);
        } else {
            String v = System.getProperty(RemotingVersionKey);
            if (v != null) {
                int value = Integer.parseInt(v);
                cmd.setVersion(value);
                ConfigVersion = value;
            }
        }
    }

    public void makeCustomHeaderToNet() {
        if (this.customHeader != null) {
            Field[] fields = this.customHeader.getClass().getDeclaredFields();
            if (null == this.extFields) {
                this.extFields = new HashMap();
            }
            for (Field field : fields) {
                String name;
                if (Modifier.isStatic(field.getModifiers()) || (name = field.getName()).startsWith("this")) continue;
                Object value = null;
                try {
                    field.setAccessible(true);
                    value = field.get(this.customHeader);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                if (value == null) continue;
                this.extFields.put(name, value.toString());
            }
        }
    }

    public CommandCustomHeader readCustomHeader() {
        return this.customHeader;
    }

    public void writeCustomHeader(CommandCustomHeader customHeader) {
        this.customHeader = customHeader;
    }

    public CommandCustomHeader decodeCommandCustomHeader(Class<? extends CommandCustomHeader> classHeader) throws RemotingCommandException {
        if (this.extFields != null) {
            Field[] fields;
            CommandCustomHeader objectHeader;
            try {
                objectHeader = classHeader.newInstance();
            }
            catch (InstantiationException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                return null;
            }
            for (Field field : fields = objectHeader.getClass().getDeclaredFields()) {
                String fieldName;
                if (Modifier.isStatic(field.getModifiers()) || (fieldName = field.getName()).startsWith("this")) continue;
                try {
                    String value = this.extFields.get(fieldName);
                    if (null == value) {
                        CFNotNull annotation = field.getAnnotation(CFNotNull.class);
                        if (annotation == null) continue;
                        throw new RemotingCommandException("the custom field <" + fieldName + "> is null");
                    }
                    field.setAccessible(true);
                    String type = field.getType().getCanonicalName();
                    Object valueParsed = null;
                    if (type.equals(StringName)) {
                        valueParsed = value;
                    } else if (type.equals(IntegerName1) || type.equals(IntegerName2)) {
                        valueParsed = Integer.parseInt(value);
                    } else if (type.equals(LongName1) || type.equals(LongName2)) {
                        valueParsed = Long.parseLong(value);
                    } else if (type.equals(BooleanName1) || type.equals(BooleanName2)) {
                        valueParsed = Boolean.parseBoolean(value);
                    } else if (type.equals(DoubleName1) || type.equals(DoubleName2)) {
                        valueParsed = Double.parseDouble(value);
                    } else {
                        throw new RemotingCommandException("the custom field <" + fieldName + "> type is not supported");
                    }
                    field.set(objectHeader, valueParsed);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            objectHeader.checkFields();
            return objectHeader;
        }
        return null;
    }

    private byte[] buildHeader() {
        this.makeCustomHeaderToNet();
        return RemotingSerializable.encode(this);
    }

    public ByteBuffer encode() {
        int length = 4;
        byte[] headerData = this.buildHeader();
        length += headerData.length;
        if (this.body != null) {
            length += this.body.length;
        }
        ByteBuffer result = ByteBuffer.allocate(4 + length);
        result.putInt(length);
        result.putInt(headerData.length);
        result.put(headerData);
        if (this.body != null) {
            result.put(this.body);
        }
        result.flip();
        return result;
    }

    public ByteBuffer encodeHeader() {
        return this.encodeHeader(this.body != null ? this.body.length : 0);
    }

    public ByteBuffer encodeHeader(int bodyLength) {
        int length = 4;
        byte[] headerData = this.buildHeader();
        length += headerData.length;
        ByteBuffer result = ByteBuffer.allocate(4 + (length += bodyLength) - bodyLength);
        result.putInt(length);
        result.putInt(headerData.length);
        result.put(headerData);
        result.flip();
        return result;
    }

    public static RemotingCommand decode(byte[] array) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(array);
        return RemotingCommand.decode(byteBuffer);
    }

    public static RemotingCommand decode(ByteBuffer byteBuffer) {
        int length = byteBuffer.limit();
        int headerLength = byteBuffer.getInt();
        byte[] headerData = new byte[headerLength];
        byteBuffer.get(headerData);
        int bodyLength = length - 4 - headerLength;
        byte[] bodyData = null;
        if (bodyLength > 0) {
            bodyData = new byte[bodyLength];
            byteBuffer.get(bodyData);
        }
        RemotingCommand cmd = RemotingSerializable.decode(headerData, RemotingCommand.class);
        cmd.body = bodyData;
        return cmd;
    }

    public static RemotingCommand decodeBody(ByteBuffer byteBuffer) {
        RemotingCommand cmd = new RemotingCommand();
        cmd.body = byteBuffer.array();
        return cmd;
    }

    public void markResponseType() {
        int bits = 1;
        this.flag |= bits;
    }

    @JSONField(serialize=false)
    public boolean isResponseType() {
        int bits = 1;
        return (this.flag & bits) == bits;
    }

    public void markOnewayRPC() {
        int bits = 2;
        this.flag |= bits;
    }

    @JSONField(serialize=false)
    public boolean isOnewayRPC() {
        int bits = 2;
        return (this.flag & bits) == bits;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    @JSONField(serialize=false)
    public RemotingCommandType getType() {
        if (this.isResponseType()) {
            return RemotingCommandType.RESPONSE_COMMAND;
        }
        return RemotingCommandType.REQUEST_COMMAND;
    }

    public LanguageCode getLanguage() {
        return this.language;
    }

    public void setLanguage(LanguageCode language) {
        this.language = language;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getOpaque() {
        return this.opaque;
    }

    public void setOpaque(int opaque) {
        this.opaque = opaque;
    }

    public int getFlag() {
        return this.flag;
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public HashMap<String, String> getExtFields() {
        return this.extFields;
    }

    public void setExtFields(HashMap<String, String> extFields) {
        this.extFields = extFields;
    }

    public static int createNewRequestId() {
        return RequestId.incrementAndGet();
    }

    public void addExtField(String key, String value) {
        if (null == this.extFields) {
            this.extFields = new HashMap();
        }
        this.extFields.put(key, value);
    }

    public String toString() {
        return "RemotingCommand [code=" + this.code + ", language=" + (Object)((Object)this.language) + ", version=" + this.version + ", opaque=" + this.opaque + ", flag(B)=" + Integer.toBinaryString(this.flag) + ", remark=" + this.remark + ", extFields=" + this.extFields + "]";
    }
}

