/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.util;

import com.alibaba.dts.common.context.InvocationContext;
import com.alibaba.dts.common.domain.ExecutableTask;
import com.alibaba.dts.common.domain.remoting.RemoteMachine;
import com.alibaba.dts.common.domain.remoting.RpcRequest;
import com.alibaba.dts.common.domain.store.Job;
import com.alibaba.dts.common.domain.store.JobInstanceSnapshot;
import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEye;
import java.util.HashMap;

public class EagleEyeUtil {
    public static final String RPC_NAME = "ScheduerX";
    private static final String TRACE_NAME_FIRE_JOB = "Fire_Job";
    public static final int RPC_TYPE_ENTER = 90;
    public static final int RPC_TYPE_CLIENT = 91;
    public static final int RPC_TYPE_SERVER = 92;
    public static final String EAGLEEYE_TRACE_ID = "EagleEyeTraceId";
    public static final String EAGLEEYE_RPC_ID = "EagleEyeRpcId";
    public static final String EAGLEEYE_USER_DATA = "EagleEyeUserData";

    public static void startTrace(String traceId, ExecutableTask executableTask) {
        EagleEye.startTrace(traceId, TRACE_NAME_FIRE_JOB);
        Job job = executableTask.getJob();
        JobInstanceSnapshot jobInstanceSnapshot = executableTask.getJobInstanceSnapshot();
        String jobInfo = "id=" + job.getId() + ", jobProcessor=" + job.getJobProcessor() + ", firePolicy=" + job.getMaxInstanceAmount() + ", cronExpression=" + job.getCronExpression() + ", jobInstanceId=" + jobInstanceSnapshot.getId() + ", fireTime=" + jobInstanceSnapshot.getFireTime() + ", description=" + job.getDescription();
        EagleEye.attribute("jobInfo", jobInfo);
    }

    public static void endTrace(String resultCode, int rpcType) {
        EagleEye.endTrace(resultCode, rpcType);
    }

    public static void executeTask() {
    }

    public static void prepareRpc(RpcRequest rpcRequest, String fireServer, String remoteIp, String serviceName, String methodName, int reqSize) {
        EagleEye.startRpc(serviceName, methodName);
        EagleEye.requestSize(reqSize);
        EagleEye.remoteIp(remoteIp);
        EagleEye.attribute("fireServer", fireServer);
        EagleEye.attribute("client", remoteIp);
        EagleEye.rpcClientSend();
        rpcRequest.addAttachment(EAGLEEYE_TRACE_ID, EagleEye.getTraceId());
        rpcRequest.addAttachment(EAGLEEYE_RPC_ID, EagleEye.getRpcId());
        rpcRequest.addAttachment(EAGLEEYE_USER_DATA, EagleEye.exportUserData());
    }

    public static void endRpc() {
        EagleEye.attribute("rpcName", "RPC");
        EagleEye.rpcServerSend("00", 92);
    }

    public static void buildContextFromRpcRequest(RemoteMachine remoteMachine, String serviceName, String methodName) {
        RpcRequest rpcRequest = InvocationContext.acquireRemoteMachine().getRpcRequest();
        String traceId = rpcRequest.getAttachment(EAGLEEYE_TRACE_ID);
        String rpcId = rpcRequest.getAttachment(EAGLEEYE_RPC_ID);
        String userData = rpcRequest.getAttachment(EAGLEEYE_USER_DATA);
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("traceId", traceId);
        context.put("rpcId", rpcId);
        context.put("eagleEyeUserData", userData);
        EagleEye.setRpcContext(context);
        EagleEye.rpcServerRecv(serviceName, methodName);
        EagleEye.remoteIp(remoteMachine.getRemoteAddress());
    }
}

