/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.util;

import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.domain.store.Job;
import com.alibaba.dts.common.util.CronExpression;
import com.alibaba.dts.common.util.StringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobUtil
implements Constants {
    private static final Log logger = LogFactory.getLog(JobUtil.class);

    public List<Job> acquireFiredJobList(List<Job> jobList, long time) {
        ArrayList<Job> result = new ArrayList<Job>();
        Date now = new Date();
        Date start = new Date(now.getTime() - time);
        for (Job job : jobList) {
            try {
                CronExpression expression = new CronExpression(job.getCronExpression());
                Date nextFireTime = expression.getNextValidTimeAfter(start);
                if (null == nextFireTime || nextFireTime.compareTo(now) >= 0) continue;
                result.add(job);
            }
            catch (Throwable e) {
                logger.error((Object)("[JobUtil]: acquireFiredJobList error, job:" + job), e);
            }
        }
        return result;
    }

    public static String acquireFireTime(String fireTime) {
        if (StringUtil.isBlank(fireTime)) {
            return null;
        }
        String[] fireTimeArr = fireTime.split("@AND#");
        if (fireTimeArr.length < 2) {
            return fireTime;
        }
        return fireTimeArr[0];
    }
}

