/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexUtil {
    public static Pattern[] compilePatterns(String[] inputs) {
        if (inputs == null) {
            return null;
        }
        Pattern[] patterns = new Pattern[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            Pattern p;
            inputs[i] = RegexUtil.escapeStringLiteralForWildCard(inputs[i].trim());
            inputs[i] = inputs[i].replace("*", "(.*)").replace("?", "(.{1})");
            patterns[i] = p = Pattern.compile(inputs[i], 2);
        }
        return patterns;
    }

    public static boolean isMatched(Pattern[] exclusionPatterns, String uri) {
        if (exclusionPatterns != null) {
            uri = uri.trim();
            for (Pattern exclusionPattern : exclusionPatterns) {
                if (!RegexUtil.isWildCardMatched(uri, exclusionPattern)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isWildCardMatched(String text, Pattern pattern) {
        Matcher m = pattern.matcher(text);
        return m.matches();
    }

    public static String escapeStringLiteralForWildCard(String original) {
        if (original == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < original.length(); ++i) {
            char curChar = original.charAt(i);
            boolean stillAppend = true;
            switch (curChar) {
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '[': 
                case '\\': 
                case '^': 
                case '{': 
                case '|': {
                    result.append('\\');
                    break;
                }
                case '\r': {
                    result.append('\\').append('r');
                    stillAppend = false;
                    break;
                }
                case '\n': {
                    result.append('\\').append('n');
                    stillAppend = false;
                    break;
                }
                case '\t': {
                    result.append('\\').append('t');
                    stillAppend = false;
                    break;
                }
                case '\f': {
                    result.append('\\').append('f');
                    stillAppend = false;
                    break;
                }
                case '\u0000': {
                    result.append('\\').append('0');
                    stillAppend = false;
                }
            }
            if (!stillAppend) continue;
            result.append(curChar);
        }
        return result.toString();
    }
}

