/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.util.scripts;

import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.util.StringUtil;
import com.alibaba.dts.common.util.scripts.processor.StreamProcessor;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScriptsUtil
implements Constants {
    private static Log logger = LogFactory.getLog(ScriptsUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeCommand(String[] command, String information) {
        logger.info((Object)("[ScriptsUtil]: " + information + " execute command:" + Arrays.toString(command)));
        StringBuilder consoleLine = new StringBuilder();
        int result = -1;
        Process process = null;
        try {
            CountDownLatch threadCount = new CountDownLatch(2);
            process = Runtime.getRuntime().exec(command);
            StreamProcessor normalProcessor = new StreamProcessor(command, process.getInputStream(), threadCount);
            normalProcessor.start();
            StreamProcessor errorProcessor = new StreamProcessor(command, process.getErrorStream(), threadCount);
            errorProcessor.start();
            result = process.waitFor();
            try {
                threadCount.await();
            }
            catch (Exception e) {
                logger.error((Object)("[ScriptsUtil]: " + information + " threadCount await error"), (Throwable)e);
            }
            consoleLine.append(normalProcessor.getConsoleLine().toString());
            consoleLine.append(errorProcessor.getConsoleLine().toString());
            consoleLine.append("\n result:" + result);
        }
        catch (Throwable e) {
            logger.error((Object)("[ScriptsUtil]: " + information + " execute error, command:" + Arrays.toString(command)), e);
            int n = result;
            return n;
        }
        finally {
            if (process != null) {
                try {
                    process.getOutputStream().close();
                    process.destroy();
                }
                catch (Throwable e) {
                    logger.error((Object)("[ScriptsUtil]: " + information + " execute close error, command:" + Arrays.toString(command)), e);
                }
            }
            logger.info((Object)("[ScriptsUtil]: " + information + " console:" + consoleLine.toString()));
        }
        return result;
    }

    public static String[] processCommand(String cmdStr) {
        if (StringUtil.isBlank(cmdStr)) {
            return null;
        }
        String[] command = cmdStr.split(":");
        if (null == command || command.length <= 0) {
            return null;
        }
        String[] temp = new String[command.length];
        int length = 0;
        for (int i = 0; i < command.length; ++i) {
            String arg = command[i].trim();
            if (!StringUtil.isNotBlank(arg)) continue;
            temp[i] = arg;
            ++length;
        }
        String[] cmd = new String[length];
        int c = 0;
        for (int i = 0; i < command.length; ++i) {
            String arg = temp[i];
            if (arg == null) continue;
            cmd[c] = arg;
            ++c;
        }
        return cmd;
    }
}

