/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.util.scripts.processor;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StreamProcessor
extends Thread {
    private static Log logger = LogFactory.getLog(StreamProcessor.class);
    private final StringBuilder consoleLine = new StringBuilder();
    private final String[] command;
    private final InputStream inputStream;
    final CountDownLatch threadCount;

    public StreamProcessor(String[] command, InputStream inputStream, CountDownLatch threadCount) {
        this.command = command;
        this.inputStream = inputStream;
        this.threadCount = threadCount;
    }

    @Override
    public void run() {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.inputStream));
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                this.consoleLine.append("\n" + line);
            }
        }
        catch (Throwable e) {
            logger.error((Object)("[StreamProcessor]: run error, command:" + Arrays.toString(this.command)), e);
        }
        finally {
            this.threadCount.countDown();
        }
    }

    public StringBuilder getConsoleLine() {
        return this.consoleLine;
    }
}

