/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.sdk;

import com.alibaba.dts.common.domain.ProgressDetail;
import com.alibaba.dts.common.domain.result.Result;
import com.alibaba.dts.common.domain.result.ResultCode;
import com.alibaba.dts.common.domain.store.Cluster;
import com.alibaba.dts.common.domain.store.Job;
import com.alibaba.dts.common.domain.store.WarningSetup;
import com.alibaba.dts.common.domain.store.assemble.AssembledMonitor;
import com.alibaba.dts.common.domain.store.assemble.AssembledUserGroup;
import com.alibaba.dts.common.domain.store.assemble.JobExecuteHistory;
import com.alibaba.dts.common.domain.store.assemble.JobInstanceDetailStatus;
import com.alibaba.dts.common.domain.store.assemble.JobStatus;
import com.alibaba.dts.common.domain.store.assemble.WarningNotifier;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.common.remoting.protocol.RemotingSerializable;
import com.alibaba.dts.common.util.CheckUtil;
import com.alibaba.dts.common.util.DiamondHelper;
import com.alibaba.dts.common.util.GroupIdUtil;
import com.alibaba.dts.common.util.StringUtil;
import com.alibaba.dts.sdk.DtsSDKManager;
import com.alibaba.dts.sdk.SDKMode;
import com.alibaba.dts.sdk.client.DtsHttpClient;
import com.alibaba.dts.sdk.context.SDKContext;
import com.alibaba.dts.sdk.util.exception.SDKModeUnsupportException;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;

public class DtsCommonSDKManager
implements DtsSDKManager {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(DtsCommonSDKManager.class);
    private SDKMode mode = SDKMode.ALIYUN_MODE;
    public long clusterId;
    private DtsHttpClient client = new DtsHttpClient();

    public DtsCommonSDKManager(SDKMode mode) {
        this.mode = mode;
        if (mode == SDKMode.DAILY_MODE) {
            this.client.setDomainUrl(SDKContext.DTS_DOMAIN_DAILY_URL);
        } else if (mode == SDKMode.ONLINE_MODE) {
            this.client.setDomainUrl(SDKContext.DTS_DOMAIN_ONLINE_URL);
        } else if (mode == SDKMode.ALIYUN_MODE) {
            this.client.setDomainUrl(SDKContext.DTS_DOMAIN_ALIYUN_URL);
        } else if (mode == SDKMode.USA_MODE) {
            this.client.setDomainUrl(SDKContext.DTS_DOMAIN_USA_URL);
        } else {
            throw new SDKModeUnsupportException("sdk mode not support!");
        }
    }

    public DtsCommonSDKManager(String url) {
        if (StringUtil.isBlank(url)) {
            throw new RuntimeException("url\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        this.client.setDomainUrl(url);
    }

    public DtsCommonSDKManager() {
        String domainName = null;
        try {
            domainName = DiamondHelper.getData("com.alibaba.dts.common.domainName", 10000L);
            this.client.setDomainUrl("http://" + domainName + "/dts-console");
            DiamondHelper.addListener("com.alibaba.dts.common.domainName", new DiamondHelper.DataListener(){

                @Override
                public void receiveConfigInfo(String dataId, String configInfo) {
                    DtsCommonSDKManager.this.client.setDomainUrl("http://" + configInfo + "/dts-console");
                }
            });
        }
        catch (Throwable e) {
            throw new RuntimeException("[DtsCommonSDKManager]: get domainName from diamond error", e);
        }
        if (StringUtil.isBlank(domainName)) {
            throw new RuntimeException("[DtsCommonSDKManager]: domainName is blank error");
        }
    }

    @Override
    public Result<List<Cluster>> getDtsClustersInfo() {
        Result<List<Cluster>> result = new Result<List<Cluster>>();
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_get_clusters");
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: getDtsClustersInfo json isBlank, postJson:" + postJson);
            result.setResultCode(ResultCode.FAILURE);
            return result;
        }
        ArrayList<Cluster> dtsClusters = null;
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation((String)jsonResult.get((Object)"errMsg"));
            } else {
                JSONArray clusterArray = jsonResult.getJSONArray("clusters");
                dtsClusters = new ArrayList<Cluster>(clusterArray.size());
                for (int i = 0; i < clusterArray.size(); ++i) {
                    JSONObject json = (JSONObject)clusterArray.get(i);
                    Cluster cluster = RemotingSerializable.fromJson(json.toJSONString(), Cluster.class);
                    dtsClusters.add(cluster);
                }
                result.setResultCode(ResultCode.SUCCESS);
                result.setData(dtsClusters);
            }
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: getDtsClustersInfo error, postJson:" + postJson, e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    @Override
    public Result<String> createGroup(long clusterId, String groupDescription) {
        Result<String> result = new Result<String>();
        if (StringUtil.isBlank(groupDescription)) {
            result.setResultCode(ResultCode.USER_PARAMETER_ERROR);
            result.setData("\u7ec4\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a!");
            return result;
        }
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_create_group");
        this.client.addParameter("clusterId", String.valueOf(clusterId)).addParameter("groupDesc", groupDescription);
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: createGroup json isBlank, clusterId:" + clusterId + ", groupDescription:" + groupDescription + ", postJson:" + postJson);
            result.setResultCode(ResultCode.FAILURE);
            return result;
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation((String)jsonResult.get((Object)"errMsg"));
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                result.setData((String)jsonResult.get((Object)"userGroupId"));
            }
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: createGroup error, clusterId:" + clusterId + ", groupDescription:" + groupDescription + ", postJson:" + postJson, e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    @Override
    public Result<Boolean> deleteGroup(String userGroupId) {
        Result<Boolean> result = new Result<Boolean>();
        if (StringUtil.isBlank(userGroupId) || !GroupIdUtil.checkClientGroupId(userGroupId)) {
            result.setResultCode(ResultCode.USER_PARAMETER_ERROR);
            result.setData(false);
            return result;
        }
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_delete_group");
        this.client.addParameter("userGroupId", userGroupId);
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: deleteGroup json isBlank, userGroupId:" + userGroupId + ", postJson:" + postJson);
            result.setResultCode(ResultCode.FAILURE);
            return result;
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation((String)jsonResult.get((Object)"errMsg"));
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                result.setData(true);
            }
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: deleteGroup error, userGroupId:" + userGroupId + ", postJson:" + postJson, e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    @Override
    public Result<List<AssembledUserGroup>> getUserGroups(long clusterId) {
        Result<List<AssembledUserGroup>> result = new Result<List<AssembledUserGroup>>();
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_get_user_groups");
        this.client.addParameter("clusterId", String.valueOf(clusterId));
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: getUserGroups json isBlank, clusterId:" + clusterId + ", postJson:" + postJson);
            result.setResultCode(ResultCode.FAILURE);
            return result;
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation((String)jsonResult.get((Object)"errMsg"));
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                JSONArray jsonArray = jsonResult.getJSONArray("groups");
                ArrayList<AssembledUserGroup> userGroups = new ArrayList<AssembledUserGroup>(jsonArray.size());
                for (int i = 0; i < jsonArray.size(); ++i) {
                    AssembledUserGroup userGroup = RemotingSerializable.fromJson(jsonArray.get(i).toString(), AssembledUserGroup.class);
                    userGroups.add(userGroup);
                }
                result.setData(userGroups);
            }
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: getUserGroups error, clusterId:" + clusterId + ", postJson:" + postJson, e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    @Override
    public Result<Long> createJob(String userGroupId, Job job) {
        Result<Long> result = new Result<Long>();
        if (StringUtil.isBlank(userGroupId) || !GroupIdUtil.checkClientGroupId(userGroupId)) {
            result.setResultCode(ResultCode.USER_PARAMETER_ERROR);
            result.getResultCode().setInformation("\u7ec4\u540d\u4e0d\u6b63\u786e!");
            return result;
        }
        Result<Boolean> checkResult = CheckUtil.checkUserConfigJob(job);
        if (!checkResult.getData().booleanValue()) {
            result.setResultCode(checkResult.getResultCode());
            result.getResultCode().setInformation(checkResult.getResultCode().getInformation());
            return result;
        }
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_create_job");
        this.client.addParameter("userGroupId", userGroupId);
        this.client.addParameter("jobProcessor", job.getJobProcessor()).addParameter("jobType", String.valueOf(job.getType())).addParameter("cronExpression", job.getCronExpression()).addParameter("jobDesc", StringUtil.isEmpty(job.getDescription()) ? "" : job.getDescription()).addParameter("firePolicy", String.valueOf(job.getMaxInstanceAmount())).addParameter("jobArguments", StringUtil.isEmpty(job.getJobArguments()) ? "" : job.getJobArguments()).addParameter("jobStatus", String.valueOf(job.getStatus()));
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: createJob json isBlank, userGroupId:" + userGroupId + ", job:" + job + ", postJson:" + postJson);
            result.setResultCode(ResultCode.FAILURE);
            return result;
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation((String)jsonResult.get((Object)"errMsg"));
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                result.setData(jsonResult.getLong("jobId"));
            }
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: createJob, userGroupId:" + userGroupId + ", job:" + job + ", postJson:" + postJson, e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    @Override
    public Result<Integer> deleteJob(long jobId) {
        Result<Integer> result = new Result<Integer>();
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_delete_job");
        this.client.addParameter("jobId", String.valueOf(jobId));
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: deleteJob json isBlank, jobId:" + jobId + ", postJson:" + postJson);
            result.setResultCode(ResultCode.FAILURE);
            return result;
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation((String)jsonResult.get((Object)"errMsg"));
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                result.setData(jsonResult.getInteger("deleteCount"));
            }
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: deleteJob error, jobId:" + jobId + ", postJson:" + postJson, e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    @Override
    public Result<Integer> updateJob(String groupId, Job job) {
        Result<Integer> result = new Result<Integer>();
        Result<Boolean> checkResult = CheckUtil.checkUserConfigJob(job);
        if (!checkResult.getData().booleanValue()) {
            result.setResultCode(checkResult.getResultCode());
            result.getResultCode().setInformation(checkResult.getResultCode().getInformation());
            return result;
        }
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_update_job");
        this.client.addParameter("jobId", String.valueOf(job.getId())).addParameter("jobProcessor", job.getJobProcessor()).addParameter("jobType", String.valueOf(job.getType())).addParameter("cronExpression", job.getCronExpression()).addParameter("jobDesc", StringUtil.isEmpty(job.getDescription()) ? "" : job.getDescription()).addParameter("firePolicy", String.valueOf(job.getMaxInstanceAmount())).addParameter("jobArguments", StringUtil.isEmpty(job.getJobArguments()) ? "" : job.getJobArguments()).addParameter("groupId", groupId);
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: updateJob json isBlank, groupId:" + groupId + ", job:" + job + ", postJson:" + postJson);
            result.setResultCode(ResultCode.FAILURE);
            return result;
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation((String)jsonResult.get((Object)"errMsg"));
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                result.setData(jsonResult.getInteger("updateCount"));
            }
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: updateJob error, groupId:" + groupId + ", job:" + job + ", postJson:" + postJson, e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    @Override
    public Result<Integer> updateJobWithArguments(String groupId, Job job) {
        Result<Integer> result = new Result<Integer>();
        Result<Boolean> checkResult = CheckUtil.checkUserConfigJob(job);
        if (!checkResult.getData().booleanValue()) {
            result.setResultCode(checkResult.getResultCode());
            result.getResultCode().setInformation(checkResult.getResultCode().getInformation());
            return result;
        }
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_update_job");
        this.client.addParameter("jobId", String.valueOf(job.getId())).addParameter("jobProcessor", job.getJobProcessor()).addParameter("jobType", String.valueOf(job.getType())).addParameter("cronExpression", job.getCronExpression()).addParameter("jobDesc", job.getDescription()).addParameter("firePolicy", String.valueOf(job.getMaxInstanceAmount())).addParameter("jobArguments", job.getJobArguments()).addParameter("groupId", groupId);
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: updateJobWithArguments json isBlank, groupId:" + groupId + ", job:" + job + ", postJson:" + postJson);
            result.setResultCode(ResultCode.FAILURE);
            return result;
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation((String)jsonResult.get((Object)"errMsg"));
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                result.setData(jsonResult.getInteger("updateCount"));
            }
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: updateJobWithArguments error, groupId:" + groupId + ", job:" + job + ", postJson:" + postJson, e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    @Override
    public Result<Integer> updateJobArguments(long jobId, String jobArguments) {
        Result<Integer> result = new Result<Integer>();
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_update_job_arguments");
        this.client.addParameter("jobId", String.valueOf(jobId)).addParameter("jobArguments", jobArguments);
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: updateJobArguments json isBlank, jobId:" + jobId + ", jobArguments:" + jobArguments + ", postJson:" + postJson);
            result.setResultCode(ResultCode.FAILURE);
            return result;
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation((String)jsonResult.get((Object)"errMsg"));
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                result.setData(jsonResult.getInteger("updateCount"));
            }
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: updateJobArguments error, jobId:" + jobId + ", jobArguments:" + jobArguments + ", postJson:" + postJson, e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    @Override
    public Result<List<Job>> getJobsForGroup(String userGroupId) {
        Result<List<Job>> result = new Result<List<Job>>();
        if (StringUtil.isBlank(userGroupId) || !GroupIdUtil.checkClientGroupId(userGroupId)) {
            result.setResultCode(ResultCode.USER_PARAMETER_ERROR);
            result.getResultCode().setInformation("\u7ec4\u540d\u4e0d\u6b63\u786e!");
            return result;
        }
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_get_group_jobs");
        this.client.addParameter("groupId", userGroupId);
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: getJobsForGroup json isBlank, userGroupId:" + userGroupId + ", postJson:" + postJson);
            result.setResultCode(ResultCode.FAILURE);
            return result;
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation((String)jsonResult.get((Object)"errMsg"));
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                JSONArray jsonArray = jsonResult.getJSONArray("jobs");
                ArrayList<Job> groupJobs = new ArrayList<Job>(jsonArray.size());
                for (int i = 0; i < jsonArray.size(); ++i) {
                    Job job = RemotingSerializable.fromJson(jsonArray.get(i).toString(), Job.class);
                    groupJobs.add(job);
                }
                result.setData(groupJobs);
            }
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: getJobsForGroup error, userGroupId:" + userGroupId + ", postJson:" + postJson, e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    public Result<List<Job>> getJobsForGroupByPage(String userGroupId, int pageSize, int pageNumber) {
        Result<List<Job>> result = new Result<List<Job>>();
        if (StringUtil.isBlank(userGroupId) || !GroupIdUtil.checkClientGroupId(userGroupId)) {
            result.setResultCode(ResultCode.USER_PARAMETER_ERROR);
            result.getResultCode().setInformation("\u7ec4\u540d\u4e0d\u6b63\u786e!");
            return result;
        }
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_get_group_jobs_by_page");
        this.client.addParameter("groupId", userGroupId);
        this.client.addParameter("pageSize", String.valueOf(pageSize));
        this.client.addParameter("pageNumber", String.valueOf(pageNumber));
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: getJobsForGroupByPage json isBlank, userGroupId:" + userGroupId + ", postJson:" + postJson + ", pageSize:" + pageSize + ", pageNumber:" + pageNumber);
            result.setResultCode(ResultCode.FAILURE);
            return result;
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation((String)jsonResult.get((Object)"errMsg"));
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                JSONArray jsonArray = jsonResult.getJSONArray("jobs");
                ArrayList<Job> groupJobs = new ArrayList<Job>(jsonArray.size());
                for (int i = 0; i < jsonArray.size(); ++i) {
                    Job job = RemotingSerializable.fromJson(jsonArray.get(i).toString(), Job.class);
                    groupJobs.add(job);
                }
                result.setData(groupJobs);
            }
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: getJobsForGroupByPage error, userGroupId:" + userGroupId + ", postJson:" + postJson + ", pageSize:" + pageSize + ", pageNumber:" + pageNumber, e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    @Override
    public Result<Boolean> enableJob(long jobId) {
        Result<Boolean> result = new Result<Boolean>();
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_enable_job");
        this.client.addParameter("jobId", String.valueOf(jobId));
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: enableJob json isBlank, jobId:" + jobId + ", postJson:" + postJson);
            result.setResultCode(ResultCode.FAILURE);
            return result;
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation((String)jsonResult.get((Object)"errMsg"));
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                result.setData(true);
            }
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: enableJob error, jobId:" + jobId + ", postJson:" + postJson, e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    @Override
    public Result<Boolean> disableJob(long jobId) {
        Result<Boolean> result = new Result<Boolean>();
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_disable_job");
        this.client.addParameter("jobId", String.valueOf(jobId));
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: disableJob json isBlank, jobId:" + jobId + ", postJson:" + postJson);
            result.setResultCode(ResultCode.FAILURE);
            return result;
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation((String)jsonResult.get((Object)"errMsg"));
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                result.setData(true);
            }
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: disableJob error, jobId:" + jobId + ", postJson:" + postJson, e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    @Override
    public Result<Boolean> instanceRunJob(String userGroupId, long jobId) {
        Result<Boolean> result = new Result<Boolean>();
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_instance_start_job");
        this.client.addParameter("jobId", String.valueOf(jobId)).addParameter("groupId", userGroupId);
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: instanceRunJob json isBlank, userGroupId:" + userGroupId + ", jobId:" + jobId + ", postJson:" + postJson);
            result.setResultCode(ResultCode.FAILURE);
            return result;
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation(postJson);
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                result.getResultCode().setInformation(postJson);
                result.setData(true);
            }
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: instanceRunJob error, userGroupId:" + userGroupId + ", jobId:" + jobId + ", postJson:" + postJson, e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    @Override
    public Result<Boolean> instanceRunJob(String userGroupId, long jobId, String instanceGlobal) {
        Result<Boolean> result = new Result<Boolean>();
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_instance_start_job");
        this.client.addParameter("jobId", String.valueOf(jobId)).addParameter("groupId", userGroupId);
        this.client.addParameter("instanceGlobal", instanceGlobal);
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: instanceRunJob json isBlank, userGroupId:" + userGroupId + ", jobId:" + jobId + ", postJson:" + postJson);
            result.setResultCode(ResultCode.FAILURE);
            return result;
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation(postJson);
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                result.getResultCode().setInformation(postJson);
                result.setData(true);
            }
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: instanceRunJob error, userGroupId:" + userGroupId + ", jobId:" + jobId + ", postJson:" + postJson, e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    @Override
    public Result<Boolean> instanceStopJob(long jobId) {
        Result<Boolean> result = new Result<Boolean>();
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_instance_stop_job");
        this.client.addParameter("jobId", String.valueOf(jobId));
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: instanceStopJob json isBlank, jobId:" + jobId + ", postJson:" + postJson);
            result.setResultCode(ResultCode.FAILURE);
            return result;
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation((String)jsonResult.get((Object)"errMsg"));
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                result.setData(true);
            }
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: instanceStopJob error, jobId:" + jobId + ", postJson:" + postJson, e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    public String parseWarningSetup(AssembledMonitor assembledMonitor) {
        JSONObject jsonObject = new JSONObject();
        if (assembledMonitor.getTimeoutLimit() != 0L) {
            jsonObject.put(AssembledMonitor.TIMEOUT_LIMIT, (Object)assembledMonitor.getTimeoutLimit());
        }
        if (assembledMonitor.getErrorRate() != 0.0) {
            jsonObject.put(AssembledMonitor.ERROR_RATE, (Object)assembledMonitor.getErrorRate());
        }
        jsonObject.put(WarningSetup.FORCED_TERMINATION, (Object)assembledMonitor.isForcedTermination());
        return jsonObject.toJSONString();
    }

    public String parseContact(AssembledMonitor assembledMonitor) {
        JSONArray jsonArray = new JSONArray();
        for (WarningNotifier warningNotifier : assembledMonitor.getNotifiers()) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(AssembledMonitor.MOBILEID, (Object)warningNotifier.getMobileId());
            jsonObject.put(AssembledMonitor.WWID, (Object)warningNotifier.getWwId());
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray.toJSONString();
    }

    @Override
    public Result<Boolean> setJobMonitorConfig(AssembledMonitor monitorSeting) {
        Result<Boolean> result = new Result<Boolean>();
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_set_monitor");
        this.client.addParameter("jobId", String.valueOf(monitorSeting.getJobId())).addParameter("warningSetup", this.parseWarningSetup(monitorSeting)).addParameter("contact", this.parseContact(monitorSeting));
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: setJobMonitorConfig json isBlank, monitorSeting:" + monitorSeting + ", postJson:" + postJson);
            result.setResultCode(ResultCode.FAILURE);
            return result;
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation((String)jsonResult.get((Object)"errMsg"));
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                result.setData(true);
            }
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: setJobMonitorConfig error, monitorSeting:" + monitorSeting + ", postJson:" + postJson, e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    @Override
    public Result<Boolean> updateJobMonitor(AssembledMonitor monitorSeting) {
        Result<Boolean> result = new Result<Boolean>();
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_set_monitor");
        this.client.addParameter("jobId", String.valueOf(monitorSeting.getJobId())).addParameter("warningSetup", this.parseWarningSetup(monitorSeting)).addParameter("contact", this.parseContact(monitorSeting));
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: updateJobMonitor json isBlank, monitorSeting:" + monitorSeting + ", postJson:" + postJson);
            result.setResultCode(ResultCode.FAILURE);
            return result;
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation((String)jsonResult.get((Object)"errMsg"));
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                result.setData(true);
            }
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: updateJobMonitor error, monitorSeting:" + monitorSeting + ", postJson:" + postJson, e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    @Override
    public Result<AssembledMonitor> getMonitorSetings(long jobId) {
        Result<AssembledMonitor> result = new Result<AssembledMonitor>();
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_get_monitor");
        this.client.addParameter("jobId", String.valueOf(jobId));
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: getMonitorSetings json isBlank, jobId:" + jobId + ", postJson:" + postJson);
            result.setResultCode(ResultCode.FAILURE);
            return result;
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation((String)jsonResult.get((Object)"errMsg"));
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                AssembledMonitor monitorSetings = RemotingSerializable.fromJson((String)jsonResult.get((Object)"monitor"), AssembledMonitor.class);
                result.setData(monitorSetings);
            }
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: getMonitorSetings error, jobId:" + jobId + ", postJson:" + postJson, e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    @Override
    public Result<JobStatus> getJobRunningStatus(long jobId) {
        Result<JobStatus> result = new Result<JobStatus>();
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_get_job_status");
        this.client.addParameter("jobId", String.valueOf(jobId));
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: getJobRunningStatus json isBlank, jobId:" + jobId + ", postJson:" + postJson);
            result.setResultCode(ResultCode.FAILURE);
            return result;
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation((String)jsonResult.get((Object)"errMsg"));
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                JobStatus jobStatus = RemotingSerializable.fromJson(jsonResult.get((Object)"status").toString(), JobStatus.class);
                result.setData(jobStatus);
            }
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: getJobRunningStatus error, jobId:" + jobId + ", postJson:" + postJson, e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    @Override
    public Result<String> getJobRunningInformations(long jobInstanceId) {
        Result<String> result = new Result<String>();
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_get_job_running_information");
        this.client.addParameter("jobInstanceId", String.valueOf(jobInstanceId));
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: getJobRunningInformations json isBlank, jobInstanceId:" + jobInstanceId + ", postJson:" + postJson);
            result.setResultCode(ResultCode.FAILURE);
            return result;
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation((String)jsonResult.get((Object)"errMsg"));
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                String runInformation = jsonResult.get((Object)"information").toString();
                result.setData(runInformation);
            }
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: getJobRunningInformations error, jobInstanceId:" + jobInstanceId + ", postJson:" + postJson, e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    @Override
    public Result<Long> getJobLastInstanceId(long jobId) {
        Result<Long> result = new Result<Long>();
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_get_job_last_instance_id");
        this.client.addParameter("jobId", String.valueOf(jobId));
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: getJobLastInstanceId json isBlank, jobId:" + jobId + ", postJson:" + postJson);
            result.setResultCode(ResultCode.FAILURE);
            return result;
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation((String)jsonResult.get((Object)"errMsg"));
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                long lastInstanceId = Long.valueOf(jsonResult.get((Object)"lastInstanceId").toString());
                result.setData(lastInstanceId);
            }
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: getJobLastInstanceId error, jobId:" + jobId + ", postJson:" + postJson, e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    @Override
    public Result<JobInstanceDetailStatus> getJobDetailRunningStatus(long jobId, long instanceId) {
        Result<JobInstanceDetailStatus> result = new Result<JobInstanceDetailStatus>();
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_get_job_detail_statistics");
        this.client.addParameter("jobId", String.valueOf(jobId)).addParameter("instanceId", String.valueOf(instanceId));
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: getJobDetailRunningStatus json isBlank, jobId:" + jobId + ", instanceId:" + instanceId + ", postJson:" + postJson);
            result.setResultCode(ResultCode.FAILURE);
            return result;
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation((String)jsonResult.get((Object)"errMsg"));
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                JobInstanceDetailStatus jobStatus = RemotingSerializable.fromJson(jsonResult.get((Object)"statistics").toString(), JobInstanceDetailStatus.class);
                result.setData(jobStatus);
            }
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: getJobDetailRunningStatus error, jobId:" + jobId + ", instanceId:" + instanceId + ", postJson:" + postJson, e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    @Override
    public Result<JobInstanceDetailStatus> getJobRunningHistoryStatusById(long jobId, long instanceId) {
        Result<JobInstanceDetailStatus> result = new Result<JobInstanceDetailStatus>();
        JobInstanceDetailStatus jobStatus = new JobInstanceDetailStatus();
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_get_job_history_by_instanceid");
        this.client.addParameter("jobId", String.valueOf(jobId)).addParameter("instanceId", String.valueOf(instanceId));
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: getJobDetailRunningStatus json isBlank, jobId:" + jobId + ", instanceId:" + instanceId + ", postJson:" + postJson);
            result.setResultCode(ResultCode.FAILURE);
            return result;
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            jobStatus.setJobId(jobId);
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation((String)jsonResult.get((Object)"errMsg"));
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                ProgressDetail progressDetail = RemotingSerializable.fromJson(jsonResult.get((Object)"statistics").toString(), ProgressDetail.class);
                jobStatus.setProgressDetail(progressDetail);
                result.setData(jobStatus);
            }
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: getJobDetailRunningStatus error, jobId:" + jobId + ", instanceId:" + instanceId + ", postJson:" + postJson, e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    @Override
    public Result<Boolean> grantGroupAuth(String userGroupId, String ownerUserId, String grantUserId) {
        Result<Boolean> result = new Result<Boolean>();
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_grant_auth");
        this.client.addParameter("userGroupId", userGroupId).addParameter("ownerUserId", ownerUserId).addParameter("grantUserId", grantUserId);
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: grantGroupAuth json isBlank, userGroupId:" + userGroupId + ", ownerUserId:" + ownerUserId + ", grantUserId:" + grantUserId + ", postJson:" + postJson);
            result.setResultCode(ResultCode.FAILURE);
            return result;
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation((String)jsonResult.get((Object)"errMsg"));
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                result.setData(true);
            }
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: grantGroupAuth error, userGroupId:" + userGroupId + ", ownerUserId:" + ownerUserId + ", grantUserId:" + grantUserId + ", postJson:" + postJson, e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    @Override
    public Result<JobExecuteHistory> getJobRunningHistoryStatus(long jobId) {
        Result<JobExecuteHistory> result = new Result<JobExecuteHistory>();
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_get_job_history");
        this.client.addParameter("jobId", String.valueOf(jobId));
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: getJobRunningHistoryStatus json isBlank, jobId:" + jobId + ", postJson:" + postJson);
            result.setResultCode(ResultCode.FAILURE);
            return result;
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation((String)jsonResult.get((Object)"errMsg"));
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                JobExecuteHistory jobExecuteHistory = RemotingSerializable.fromJson(jsonResult.get((Object)"history").toString(), JobExecuteHistory.class);
                result.setData(jobExecuteHistory);
            }
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: getJobRunningHistoryStatus error, jobId:" + jobId + ", postJson:" + postJson, e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    public Result<Boolean> resetJobRelation(List<Long> startJobIdList) {
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_reset_job_relation");
        String jobIds = "";
        for (Long jobId : startJobIdList) {
            jobIds = jobIds + jobId + ":";
        }
        jobIds = jobIds.substring(0, jobIds.length() - 1);
        this.client.addParameter("jobIds", jobIds);
        Result<Boolean> result = new Result<Boolean>();
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: resetJobRelation json isBlank, startJobIdList:" + startJobIdList + ", postJson:" + postJson);
            result.setResultCode(ResultCode.FAILURE);
            return result;
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation((String)jsonResult.get((Object)"errMsg"));
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                result.setData(true);
            }
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: resetJobRelation error, startJobIdList:" + startJobIdList + ", postJson:" + postJson, e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    public Result<Boolean> createRelation(long afterJobId, long beforeJobId) {
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_create_relation");
        this.client.addParameter("afterJobId", String.valueOf(afterJobId));
        this.client.addParameter("beforeJobId", String.valueOf(beforeJobId));
        Result<Boolean> result = new Result<Boolean>();
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: createRelation json isBlank, afterJobId:" + afterJobId + ", beforeJobId:" + beforeJobId + ", postJson:" + postJson);
            result.setResultCode(ResultCode.FAILURE);
            return result;
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation((String)jsonResult.get((Object)"errMsg"));
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                result.setData(true);
            }
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: createRelation error, afterJobId:" + afterJobId + ", beforeJobId:" + beforeJobId + ", postJson:" + postJson, e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    public Result<Boolean> deleteRelation(long afterJobId, long beforeJobId) {
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_delete_relation");
        this.client.addParameter("afterJobId", String.valueOf(afterJobId));
        this.client.addParameter("beforeJobId", String.valueOf(beforeJobId));
        Result<Boolean> result = new Result<Boolean>();
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: deleteRelation json isBlank, afterJobId:" + afterJobId + ", beforeJobId:" + beforeJobId + ", postJson:" + postJson);
            result.setResultCode(ResultCode.FAILURE);
            return result;
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation((String)jsonResult.get((Object)"errMsg"));
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                result.setData(true);
            }
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: deleteRelation error, afterJobId:" + afterJobId + ", beforeJobId:" + beforeJobId + ", postJson:" + postJson, e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    public List<String> queryClientGroupIpList(String groupId, long jobId) {
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_query_client_group_ip_list");
        this.client.addParameter("clientGroup", groupId);
        this.client.addParameter("jobId", String.valueOf(jobId));
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: queryClientGroupIpList json isBlank, groupId:" + groupId + ", jobId:" + jobId + ", postJson:" + postJson);
            return new ArrayList<String>();
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            String json = jsonResult.getString("ipList");
            if (success.booleanValue()) {
                return RemotingSerializable.fromJson(json, List.class);
            }
            return new ArrayList<String>();
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: queryClientGroupIpList json isBlank, groupId:" + groupId + ", jobId:" + jobId + ", postJson:" + postJson, e);
            return new ArrayList<String>();
        }
    }

    @Override
    public Result<Job> getJobConfig(long jobId) {
        Result<Job> result = new Result<Job>();
        this.client.setTarget("sdkManager.do").setSubmitAction("event_submit_do_get_job_config");
        this.client.addParameter("jobId", String.valueOf(jobId));
        String postJson = this.client.doPost();
        if (StringUtil.isBlank(postJson)) {
            logger.error("[DtsCommonSDKManager]: getJobConfig json isBlank, jobId:" + jobId + ", postJson:" + postJson);
            result.setResultCode(ResultCode.FAILURE);
            return result;
        }
        try {
            JSONObject jsonResult = JSON.parseObject((String)postJson);
            Boolean success = (Boolean)jsonResult.get((Object)"success");
            if (!success.booleanValue()) {
                result.setResultCode(ResultCode.FAILURE);
                result.getResultCode().setInformation((String)jsonResult.get((Object)"errMsg"));
            } else {
                result.setResultCode(ResultCode.SUCCESS);
                Job job = RemotingSerializable.fromJson(jsonResult.get((Object)"jobConfig").toString(), Job.class);
                result.setData(job);
            }
        }
        catch (Throwable e) {
            logger.error("[DtsCommonSDKManager]: getJobConfig error, jobId:" + jobId + ", postJson:" + postJson, e);
            result.setResultCode(ResultCode.SDK_IO_ERROR);
        }
        return result;
    }

    public long getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(long clusterId) {
        this.clusterId = clusterId;
    }

    public SDKMode getMode() {
        return this.mode;
    }

    public void setMode(SDKMode mode) {
        this.mode = mode;
    }
}

