/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.sdk;

import com.alibaba.dts.common.domain.result.Result;
import com.alibaba.dts.common.domain.result.ResultCode;
import com.alibaba.dts.common.domain.store.Cluster;
import com.alibaba.dts.common.domain.store.Job;
import com.alibaba.dts.common.domain.store.assemble.AssembledMonitor;
import com.alibaba.dts.common.domain.store.assemble.AssembledUserGroup;
import com.alibaba.dts.common.domain.store.assemble.JobExecuteHistory;
import com.alibaba.dts.common.domain.store.assemble.JobInstanceDetailStatus;
import com.alibaba.dts.common.domain.store.assemble.JobStatus;
import com.alibaba.dts.sdk.DtsCommonSDKManager;
import com.alibaba.dts.sdk.context.SDKContext;
import com.alibaba.dts.sdk.util.CookieUtil;
import com.alibaba.dts.shade.javax.servlet.http.Cookie;
import com.alibaba.dts.shade.javax.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;

public class DtsSimpleSDKManager
extends DtsCommonSDKManager {
    public Result<Boolean> initDtsService(HttpServletRequest request) {
        this.initCookie(request);
        Result<Boolean> result = new Result<Boolean>();
        Result<List<Cluster>> clusterResult = this.getDtsClustersInfo();
        if (clusterResult.getResultCode() == ResultCode.SUCCESS) {
            List<Cluster> clusters = clusterResult.getData();
            for (Cluster cluster : clusters) {
                this.createGroup(cluster.getId(), "\u9ed8\u8ba4\u5206\u7ec4");
            }
        } else {
            result.setResultCode(clusterResult.getResultCode());
        }
        return result;
    }

    public Result<List<Cluster>> getDtsClustersInfo(HttpServletRequest request) {
        this.initCookie(request);
        return super.getDtsClustersInfo();
    }

    public Result<String> createGroup(HttpServletRequest request, long clusterId, String groupDescription) {
        this.initCookie(request);
        return super.createGroup(clusterId, groupDescription);
    }

    public Result<Boolean> deleteGroup(HttpServletRequest request, String userGroupId) {
        this.initCookie(request);
        return super.deleteGroup(userGroupId);
    }

    public Result<List<AssembledUserGroup>> getUserGroups(HttpServletRequest request, long clusterId) {
        this.initCookie(request);
        return super.getUserGroups(clusterId);
    }

    public Result<Long> createJob(HttpServletRequest request, String userGroupId, Job job) {
        this.initCookie(request);
        return super.createJob(userGroupId, job);
    }

    public Result<Integer> deleteJob(HttpServletRequest request, long jobId) {
        this.initCookie(request);
        return super.deleteJob(jobId);
    }

    public Result<Integer> updateJob(HttpServletRequest request, String groupId, Job job) {
        this.initCookie(request);
        return super.updateJob(groupId, job);
    }

    public Result<Integer> updateJobWithArguments(HttpServletRequest request, String groupId, Job job) {
        this.initCookie(request);
        return super.updateJobWithArguments(groupId, job);
    }

    public Result<Integer> updateJobArguments(HttpServletRequest request, long jobId, String jobArguments) {
        this.initCookie(request);
        return super.updateJobArguments(jobId, jobArguments);
    }

    public Result<List<Job>> getJobsForGroup(HttpServletRequest request, String userGroupId) {
        this.initCookie(request);
        return super.getJobsForGroup(userGroupId);
    }

    public Result<Boolean> enableJob(HttpServletRequest request, long jobId) {
        this.initCookie(request);
        return super.enableJob(jobId);
    }

    public Result<Boolean> disableJob(HttpServletRequest request, long jobId) {
        this.initCookie(request);
        return super.disableJob(jobId);
    }

    public Result<Boolean> instanceRunJob(HttpServletRequest request, String userGroupId, long jobId) {
        this.initCookie(request);
        return super.instanceRunJob(userGroupId, jobId);
    }

    public Result<Boolean> instanceStopJob(HttpServletRequest request, long jobId) {
        this.initCookie(request);
        return super.instanceStopJob(jobId);
    }

    public Result<Boolean> setJobMonitorConfig(HttpServletRequest request, AssembledMonitor monitorSeting) {
        this.initCookie(request);
        return super.setJobMonitorConfig(monitorSeting);
    }

    public Result<Boolean> updateJobMonitor(HttpServletRequest request, AssembledMonitor monitorSeting) {
        this.initCookie(request);
        return super.updateJobMonitor(monitorSeting);
    }

    public Result<AssembledMonitor> getMonitorSetings(HttpServletRequest request, long jobId) {
        this.initCookie(request);
        return super.getMonitorSetings(jobId);
    }

    public Result<JobStatus> getJobRunningStatus(HttpServletRequest request, long jobId) {
        this.initCookie(request);
        return super.getJobRunningStatus(jobId);
    }

    public Result<JobInstanceDetailStatus> getJobDetailRunningStatus(HttpServletRequest request, long jobId, long instanceId) {
        this.initCookie(request);
        return super.getJobDetailRunningStatus(jobId, instanceId);
    }

    public Result<Boolean> grantGroupAuth(HttpServletRequest request, String userGroupId, String ownerUserId, String grantUserId) {
        this.initCookie(request);
        return super.grantGroupAuth(userGroupId, ownerUserId, grantUserId);
    }

    public Result<JobExecuteHistory> getJobRunningHistoryStatus(HttpServletRequest request, long jobId) {
        this.initCookie(request);
        return super.getJobRunningHistoryStatus(jobId);
    }

    private void initCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        SDKContext.setCookie(CookieUtil.cookieToString(Arrays.asList(cookies)));
    }
}

