/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.sdk;

import com.alibaba.dts.client.security.SdkSecurityCheck;
import com.alibaba.dts.common.domain.DtsUser;
import com.alibaba.dts.common.domain.result.Result;
import com.alibaba.dts.common.domain.store.Job;
import com.alibaba.dts.common.domain.store.assemble.JobStatus;
import com.alibaba.dts.sdk.DtsSecureCommonSDKManager;
import com.alibaba.dts.sdk.context.SDKContext;
import com.alibaba.dts.sdk.util.CookieUtil;
import com.alibaba.dts.shade.javax.servlet.http.Cookie;
import java.util.ArrayList;

public class SchedulerXSDKManager
extends DtsSecureCommonSDKManager {
    private String userId;
    private boolean userSdkSecurity = false;
    SdkSecurityCheck sdkSecurityCheck = new SdkSecurityCheck();

    public SchedulerXSDKManager(String userid, String url, boolean userSdkSecurity) {
        super(url);
        this.userId = userid;
        this.userSdkSecurity = userSdkSecurity;
        if (userSdkSecurity) {
            try {
                this.sdkSecurityCheck.init();
                this.userId = this.sdkSecurityCheck.getAccessKey();
            }
            catch (Exception e) {
                throw new RuntimeException("sdkSecurityCheck init error\uff01");
            }
        }
    }

    public SchedulerXSDKManager(String url) {
        super(url);
        this.userSdkSecurity = true;
        if (this.userSdkSecurity) {
            try {
                this.sdkSecurityCheck.init();
                this.userId = this.sdkSecurityCheck.getAccessKey();
            }
            catch (Exception e) {
                throw new RuntimeException("sdkSecurityCheck init error\uff01");
            }
        }
    }

    @Override
    public Result<Long> createJob(String userGroupId, Job job) {
        this.initRequest(userGroupId);
        return super.createJob(userGroupId, job);
    }

    @Override
    public Result<Integer> deleteJob(String userGroupId, long jobId) {
        this.initRequest(userGroupId);
        return super.deleteJob(userGroupId, jobId);
    }

    @Override
    public Result<Integer> updateJob(String userGroupId, Job job) {
        this.initRequest(userGroupId);
        return super.updateJob(userGroupId, job);
    }

    @Override
    public Result<Boolean> enableJob(String userGroupId, long jobId) {
        this.initRequest(userGroupId);
        return super.enableJob(userGroupId, jobId);
    }

    @Override
    public Result<Boolean> disableJob(String userGroupId, long jobId) {
        this.initRequest(userGroupId);
        return super.disableJob(userGroupId, jobId);
    }

    @Override
    public Result<Boolean> instanceRunJob(String userGroupId, long jobId) {
        this.initRequest(userGroupId);
        return super.instanceRunJob(userGroupId, jobId);
    }

    @Override
    public Result<Boolean> instanceStopJob(String userGroupId, long jobId) {
        this.initRequest(userGroupId);
        return super.instanceStopJob(userGroupId, jobId);
    }

    @Override
    public Result<JobStatus> getJobRunningStatus(String userGroupId, long jobId) {
        this.initRequest(userGroupId);
        return super.getJobRunningStatus(userGroupId, jobId);
    }

    @Override
    public Result<Job> getJobConfig(String userGroupId, long jobId) {
        this.initRequest(userGroupId);
        return super.getJobConfig(userGroupId, jobId);
    }

    private void initRequest(String groupid) {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>(2);
        Cookie sourceToken = new Cookie("userIdKey", this.userId);
        cookies.add(sourceToken);
        cookies.add(new Cookie("defaultUser", new DtsUser(this.userId).toString()));
        long nowTime = System.currentTimeMillis();
        Cookie timestamp = new Cookie("timestamp", String.valueOf(nowTime));
        cookies.add(timestamp);
        if (this.userSdkSecurity) {
            Cookie accessKey = new Cookie("accessKey", this.sdkSecurityCheck.getAccessKey());
            cookies.add(accessKey);
            Cookie groupidstr = new Cookie("groupid", groupid);
            cookies.add(groupidstr);
            Cookie sign = new Cookie("sign", this.sdkSecurityCheck.getSignatureStr(nowTime, groupid));
            cookies.add(sign);
        }
        SDKContext.setCookie(CookieUtil.cookieToString(cookies));
    }
}

