/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.sdk.client;

import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.sdk.util.HttpUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DtsHttpClient {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(DtsHttpClient.class);
    private String domainUrl;
    private static final String ACTION_NAME = "SDKAction";
    private ThreadLocal<String> targetThreadLocal = new ThreadLocal();
    private ThreadLocal<String> submitActionThreadLocal = new ThreadLocal();
    private ThreadLocal<ConcurrentHashMap<String, String>> parameterMapThreadLocal = new ThreadLocal();

    public DtsHttpClient() {
    }

    public DtsHttpClient(String domainUrl) {
        this.domainUrl = domainUrl;
    }

    public String doPost() {
        String requestURL = this.domainUrl;
        requestURL = requestURL + "/" + this.targetThreadLocal.get() + "?";
        requestURL = requestURL + "action=SDKAction&";
        requestURL = requestURL + this.submitActionThreadLocal.get() + "=1";
        String data = this.parseParameter(requestURL);
        String result = null;
        try {
            result = HttpUtil.sendRequest(requestURL, data);
        }
        catch (Throwable e) {
            logger.error("[DtsHttpClient]: doPost, requestURL:" + requestURL + ", data:" + data, e);
        }
        logger.info("[DtsHttpClient]: doPost, requestURL:" + requestURL + ", data:" + data + ", result:" + result);
        return result;
    }

    public String doPost(String url, HashMap<String, String> params) {
        String result = null;
        String data = this.parseParameter(params);
        try {
            result = HttpUtil.sendRequest(url, data);
        }
        catch (Throwable e) {
            logger.error("[DtsHttpClient]: doPost, requestURL:" + url + ", data:" + data, e);
        }
        logger.info("[DtsHttpClient]: doPost, requestURL:" + url + ", data:" + data + ", result:" + result);
        return result;
    }

    public String getDomainUrl() {
        return this.domainUrl;
    }

    public void setDomainUrl(String domainUrl) {
        this.domainUrl = domainUrl;
    }

    public DtsHttpClient addParameter(String name, String value) {
        ConcurrentHashMap<String, String> map = this.parameterMapThreadLocal.get();
        if (null == map) {
            map = new ConcurrentHashMap();
            this.parameterMapThreadLocal.set(map);
        }
        map.put(name, value);
        return this;
    }

    public DtsHttpClient setTarget(String target) {
        this.targetThreadLocal.set(target);
        return this;
    }

    private String parseParameter(String url) {
        StringBuilder sb = new StringBuilder();
        ConcurrentHashMap<String, String> map = this.parameterMapThreadLocal.get();
        if (null == map || map.isEmpty()) {
            return sb.toString();
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append("&").append(entry.getKey()).append("=").append(entry.getValue());
        }
        this.parameterMapThreadLocal.get().clear();
        return sb.toString();
    }

    private String parseParameter(Map<String, String> params) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            sb.append("&").append(entry.getKey()).append("=").append(entry.getValue() == null ? "" : entry.getValue());
        }
        return sb.toString();
    }

    public DtsHttpClient setSubmitAction(String submitAction) {
        this.submitActionThreadLocal.set(submitAction);
        return this;
    }
}

