/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.sdk.util;

import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.common.util.StringUtil;
import com.alibaba.dts.sdk.context.SDKContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;

public class HttpUtil {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(HttpUtil.class);
    public static final String HTTP_METHOD = "POST";
    private static int timeoutInMilliSeconds = 999999;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendRequest(String requestUrl, String data) throws IOException {
        URL url = null;
        url = new URL(requestUrl);
        HttpURLConnection conn = null;
        OutputStream outStream = null;
        InputStream inputStream = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod(HTTP_METHOD);
            conn.setConnectTimeout(timeoutInMilliSeconds);
            conn.setReadTimeout(timeoutInMilliSeconds);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            String cookie = SDKContext.acquireCookie();
            if (StringUtil.isNotEmpty(cookie)) {
                conn.setRequestProperty("Cookie", cookie);
            }
            outStream = conn.getOutputStream();
            outStream.write(data.getBytes("UTF-8"));
            outStream.flush();
            inputStream = conn.getInputStream();
            ByteArrayOutputStream byteArrayBuff = new ByteArrayOutputStream();
            byte[] buff = new byte[1024];
            int l = -1;
            while ((l = inputStream.read(buff, 0, 1024)) != -1) {
                byteArrayBuff.write(buff, 0, l);
            }
            String string = new String(byteArrayBuff.toByteArray(), Charset.forName("UTF-8"));
            return string;
        }
        catch (IOException e) {
            logger.error("request url failed," + url, e);
            throw e;
        }
        catch (Exception e) {
            logger.error("request url failed," + url, e);
            String string = null;
            return string;
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    logger.error("close outStream failed", e);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.error("close inputStream failed", e);
                }
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
    }
}

