/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.eagleeye;

import com.alibaba.dts.shade.com.taobao.eagleeye.BaseContext;
import com.alibaba.dts.shade.com.taobao.eagleeye.BaseContextEncoder;
import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEyeAppender;
import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEyeCoreUtils;
import com.alibaba.dts.shade.com.taobao.eagleeye.FastDateFormat;
import java.io.IOException;

class DefaultTraceEncoder
extends BaseContextEncoder {
    private static final int DEFAULT_BUFFER_SIZE = 256;
    static final int REQUIRED_LINE_FEED_ESCAPE = 1;
    private final char entryDelimiter;
    private StringBuilder buffer = new StringBuilder(256);
    private FastDateFormat fmt = new FastDateFormat();

    DefaultTraceEncoder(char entryDelimiter) {
        this.entryDelimiter = entryDelimiter;
    }

    @Override
    public void encode(BaseContext ctx, EagleEyeAppender eea) throws IOException {
        char entryDelimiter = this.entryDelimiter;
        StringBuilder buffer = this.buffer;
        buffer.delete(0, buffer.length());
        this.fmt.formatAndAppendTo(ctx.logTime, buffer);
        buffer.append(entryDelimiter).append(ctx.traceId).append(entryDelimiter).append(ctx.rpcId).append(entryDelimiter).append(ctx.serviceName).append(entryDelimiter).append(ctx.methodName).append(entryDelimiter).append(ctx.logType).append(entryDelimiter).append(ctx.traceName).append(entryDelimiter);
        if (ctx.rpcType == 1) {
            EagleEyeCoreUtils.appendLog(ctx.callBackMsg, buffer, '\u0000');
        } else {
            buffer.append(ctx.callBackMsg);
        }
        buffer.append("\r\n");
        eea.append(buffer.toString());
    }
}

