/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.eagleeye;

import com.alibaba.dts.shade.com.taobao.eagleeye.AsyncAppender;
import com.alibaba.dts.shade.com.taobao.eagleeye.AtpTraceClient;
import com.alibaba.dts.shade.com.taobao.eagleeye.DefaultBizEncoder;
import com.alibaba.dts.shade.com.taobao.eagleeye.DefaultRpcContextEncoder;
import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEyeAppender;
import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEyeCoreUtils;
import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEyeJVMPatchImpl;
import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEyeLogDaemon;
import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEyeRollingFileAppender;
import com.alibaba.dts.shade.com.taobao.eagleeye.LocalContext_inner;
import com.alibaba.dts.shade.com.taobao.eagleeye.LogContext;
import com.alibaba.dts.shade.com.taobao.eagleeye.RpcContext_inner;
import com.alibaba.dts.shade.com.taobao.eagleeye.StatLogController;
import com.alibaba.dts.shade.com.taobao.eagleeye.StatLogger;
import com.alibaba.dts.shade.com.taobao.eagleeye.StatLoggerBuilder;
import com.alibaba.dts.shade.com.taobao.eagleeye.SyncAppender;
import com.alibaba.dts.shade.com.taobao.eagleeye.TraceGroup;
import com.alibaba.dts.shade.com.taobao.eagleeye.TraceIdGenerator;
import com.alibaba.dts.shade.com.taobao.eagleeye.TraceLogger;
import com.alibaba.dts.shade.com.taobao.eagleeye.TraceLoggerBuilder;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public final class EagleEye {
    static final String USER_HOME = EagleEye.locateUserHome();
    static final String BASE_LOG_DIR = EagleEye.locateBaseLogPath();
    static final String EAGLEEYE_LOG_DIR = EagleEye.locateEagleEyeLogPath();
    static final String APP_LOG_DIR = EagleEye.locateAppLogPath();
    static final Charset DEFAULT_CHARSET = EagleEye.getDefaultOutputCharset();
    static final String EAGLEEYE_RPC_LOG_FILE = EAGLEEYE_LOG_DIR + "eagleeye.log";
    static final String EAGLEEYE_BIZ_LOG_FILE = EAGLEEYE_LOG_DIR + "biz_eagleeye.log";
    static final String EAGLEEYE_SELF_LOG_FILE = EAGLEEYE_LOG_DIR + "eagleeye-self.log";
    static final long MAX_SELF_LOG_FILE_SIZE = 0xC800000L;
    static final long MAX_RPC_LOG_FILE_SIZE = 314572800L;
    static final long MAX_BIZ_LOG_FILE_SIZE = 314572800L;
    public static final int MAX_BIZ_LOG_SIZE = 4096;
    public static final int MAX_INDEX_SIZE = 512;
    public static final int MAX_USER_DATA_ENTRY_SIZE = 512;
    public static final int MAX_USER_DATA_TOTAL_SIZE = 1024;
    static AsyncAppender rpcAppender;
    static AsyncAppender bizAppender;
    static TraceLogger bizEagleEyeLogger;
    static EagleEyeAppender selfAppender;
    static AtomicInteger exceptionThreshold;
    static int MAX_EXCEPTION_COUNT;
    public static final String ROOT_RPC_ID = "0";
    public static final String MAL_ROOT_RPC_ID = "9";
    @Deprecated
    public static final int TYPE_START_TRACE = 1;
    @Deprecated
    public static final int TYPE_END_TRACE = 2;
    @Deprecated
    public static final int TYPE_START_RPC = 3;
    @Deprecated
    public static final int TYPE_END_RPC = 4;
    @Deprecated
    public static final int TYPE_ANNOTATE_RPC = 5;
    @Deprecated
    public static final int TYPE_ANNOTATE_TRACE = 6;
    static final int LOG_TYPE_BIZ = 0;
    static final int LOG_TYPE_TRACE = 1;
    static final int LOG_TYPE_RPC_CLIENT = 2;
    static final int LOG_TYPE_RPC_SERVER = 3;
    static final int LOG_TYPE_RPC_LOG = 4;
    static final int LOG_TYPE_INDEX = 5;
    static final int LOG_TYPE_EVENT_ILLEGAL = -255;
    public static final int TYPE_TRACE = 0;
    public static final int TYPE_HSF_CLIENT = 1;
    public static final int TYPE_HSF_SERVER = 2;
    public static final int TYPE_NOTIFY = 3;
    public static final int TYPE_TDDL = 4;
    public static final int TYPE_TAIR = 5;
    public static final int TYPE_SEARCH = 6;
    public static final int TYPE_INDEX = 9;
    public static final int TYPE_DUBBO_CLIENT = 11;
    public static final int TYPE_DUBBO_SERVER = 12;
    public static final int TYPE_METAQ = 13;
    public static final int TYPE_TFS = 15;
    public static final int TYPE_ALIPAY = 16;
    public static final int TYPE_HTTP_CLIENT = 25;
    public static final int TYPE_LOCAL = 30;
    @Deprecated
    public static final String TAG_CLIENT_SEND = "CS";
    @Deprecated
    public static final String TAG_SERVER_RECV = "SR";
    @Deprecated
    public static final String TAG_SERVER_SEND = "SS";
    @Deprecated
    public static final String TAG_CLIENT_RECV = "CR";
    @Deprecated
    public static final String TAG_CLIENT_SEND_OLD = "ClientSend";
    @Deprecated
    public static final String TAG_SERVER_RECV_OLD = "ServerRecv";
    @Deprecated
    public static final String TAG_SERVER_SEND_OLD = "ServerSend";
    @Deprecated
    public static final String TAG_CLIENT_RECV_OLD = "ClientRecv";
    public static final String RPC_RESULT_SUCCESS = "00";
    public static final String RPC_RESULT_FAILED = "01";
    public static final String TRACE_ID_KEY = "traceId";
    public static final String RPC_ID_KEY = "rpcId";
    public static final String USER_DATA_KEY = "eagleEyeUserData";
    @Deprecated
    public static final String EAGLEEYE_TRACEID = "tb_eagleeye_traceid";
    public static final char ENTRY_SEPARATOR = '\u0012';
    public static final char KV_SEPARATOR = '\u0001';
    public static final char KV_SEPARATOR2 = '\u0014';
    public static final char ULC_SEPARATOR = '\u0012';
    public static final String ULC_EAGLEEYE_APPID = "ulc";
    private static AtomicBoolean rpcRecord;
    private static AtomicBoolean bizRecord;
    public static final char CLUSTER_TEST_KEY = 't';
    private static AtomicBoolean clusterTestEnabled;
    private static AtomicBoolean userDataEnabled;
    private static AtomicBoolean logDumpEnabled;
    @Deprecated
    public static final String EAGLEEYE_TAIR_SERVICENAME = "EETair";
    private static final long MAX_INDEX_TABLE_SIZE = 1000L;
    static final ConcurrentHashMap<String, String> indexes;
    private static final String INDEX_OUTPUT_TRACE_ID = "54007";
    private static final String INDEX_NOT_INDEXED = "ffffffff";
    private static volatile int samplingInterval;

    static final String getEagleEyeLocation() {
        try {
            URL resource = EagleEye.class.getProtectionDomain().getCodeSource().getLocation();
            if (resource != null) {
                return resource.toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "unknown location";
    }

    static final Charset getDefaultOutputCharset() {
        Charset cs;
        String charsetName = EagleEye.getSystemProperty("EAGLEEYE.CHARSET");
        if (EagleEyeCoreUtils.isNotBlank(charsetName)) {
            charsetName = charsetName.trim();
            try {
                cs = Charset.forName(charsetName);
                if (cs != null) {
                    return cs;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            cs = Charset.forName("GB18030");
        }
        catch (Exception e) {
            try {
                cs = Charset.forName("GBK");
            }
            catch (Exception e2) {
                cs = Charset.forName("UTF-8");
            }
        }
        return cs;
    }

    private static final String locateUserHome() {
        String userHome = EagleEye.getSystemProperty("user.home");
        if (EagleEyeCoreUtils.isNotBlank(userHome)) {
            if (!userHome.endsWith(File.separator)) {
                userHome = userHome + File.separator;
            }
        } else {
            userHome = "/tmp/";
        }
        return userHome;
    }

    private static final String locateBaseLogPath() {
        String tmpPath = EagleEye.getSystemProperty("JM.LOG.PATH");
        if (EagleEyeCoreUtils.isNotBlank(tmpPath)) {
            if (!tmpPath.endsWith(File.separator)) {
                tmpPath = tmpPath + File.separator;
            }
        } else {
            tmpPath = USER_HOME + "logs" + File.separator;
        }
        return tmpPath;
    }

    private static final String locateEagleEyeLogPath() {
        String tmpPath = EagleEye.getSystemProperty("EAGLEEYE.LOG.PATH");
        if (EagleEyeCoreUtils.isNotBlank(tmpPath)) {
            if (!tmpPath.endsWith(File.separator)) {
                tmpPath = tmpPath + File.separator;
            }
        } else {
            tmpPath = BASE_LOG_DIR + "eagleeye" + File.separator;
        }
        return tmpPath;
    }

    private static final String locateAppLogPath() {
        String appName = EagleEye.getSystemProperty("project.name");
        if (EagleEyeCoreUtils.isNotBlank(appName)) {
            return USER_HOME + appName + File.separator + "logs" + File.separator;
        }
        return EAGLEEYE_LOG_DIR;
    }

    private static final String getSystemProperty(String key) {
        try {
            return System.getProperty(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static final long getSystemPropertyForLong(String key, long defaultValue) {
        try {
            return Long.parseLong(System.getProperty(key));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private static final EagleEyeAppender createSelfLogger() {
        EagleEyeRollingFileAppender selfAppender = new EagleEyeRollingFileAppender(EAGLEEYE_SELF_LOG_FILE, EagleEye.getSystemPropertyForLong("EAGLEEYE.LOG.SELF.FILESIZE", 0xC800000L), false);
        selfAppender.setMaxBackupIndex((int)EagleEye.getSystemPropertyForLong("EAGLEEYE.LOG.SELF.BACKUPSIZE", 1L));
        return EagleEyeLogDaemon.watch(new SyncAppender(selfAppender));
    }

    private static final void createEagleEyeLoggers() {
        rpcAppender = new AsyncAppender((int)EagleEye.getSystemPropertyForLong("EAGLEEYE.LOG.RPC.QUEUESIZE", 2048L), 0);
        bizAppender = new AsyncAppender((int)EagleEye.getSystemPropertyForLong("EAGLEEYE.LOG.BIZ.QUEUESIZE", 4096L), 0);
        EagleEyeRollingFileAppender rpcLogger = new EagleEyeRollingFileAppender(EAGLEEYE_RPC_LOG_FILE, EagleEye.getSystemPropertyForLong("EAGLEEYE.LOG.RPC.FILESIZE", 314572800L), true);
        rpcLogger.setMaxBackupIndex((int)EagleEye.getSystemPropertyForLong("EAGLEEYE.LOG.RPC.BACKUPSIZE", 2L));
        rpcAppender.start(rpcLogger, new DefaultRpcContextEncoder(), "RpcLog");
        EagleEyeLogDaemon.watch(rpcAppender);
        EagleEyeRollingFileAppender bizLogger = new EagleEyeRollingFileAppender(EAGLEEYE_BIZ_LOG_FILE, EagleEye.getSystemPropertyForLong("EAGLEEYE.LOG.BIZ.FILESIZE", 314572800L), true);
        bizLogger.setMaxBackupIndex((int)EagleEye.getSystemPropertyForLong("EAGLEEYE.LOG.BIZ.BACKUPSIZE", 2L));
        bizAppender.start(bizLogger, new DefaultBizEncoder(), "BizLog");
        EagleEyeLogDaemon.watch(bizAppender);
        bizEagleEyeLogger = EagleEye.traceLoggerBuilder("biz-eagleeye").appender(bizAppender).buildSingleton();
    }

    private EagleEye() {
    }

    public static void turnRpcOn() {
        EagleEye.selfLog("[INFO] turnRpcOn");
        rpcRecord.set(true);
    }

    public static void turnRpcOff() {
        EagleEye.selfLog("[INFO] turnRpcOff");
        rpcRecord.set(false);
    }

    public static final boolean isRpcOff() {
        return !rpcRecord.get();
    }

    public static void turnBizOn() {
        EagleEye.selfLog("[INFO] turnBizOn");
        bizRecord.set(true);
    }

    public static void turnBizOff() {
        EagleEye.selfLog("[INFO] turnBizOff");
        bizRecord.set(false);
    }

    public static final boolean isBizOff() {
        return !bizRecord.get();
    }

    public static int getSamplingInterval() {
        return samplingInterval;
    }

    public static void setSamplingInterval(int interval) {
        if (interval < 1 || interval > 9999) {
            interval = 1;
        }
        EagleEye.selfLog("[INFO] setSamplingInterval=" + interval);
        samplingInterval = interval;
    }

    public static void setUserDataEnabled(boolean enable) {
        EagleEye.selfLog("[INFO] setUserDataEnable: " + enable);
        userDataEnabled.set(enable);
    }

    public static final boolean isUserDataEnabled() {
        return userDataEnabled.get();
    }

    public static void setClusterTestEnabled(boolean enable) {
        EagleEye.selfLog("[INFO] setClusterTestEnable: " + enable);
        clusterTestEnabled.set(enable);
    }

    public static final boolean isClusterTestEnabled() {
        return clusterTestEnabled.get();
    }

    public static void setLogDumpEnabled(boolean enable) {
        EagleEye.selfLog("[INFO] setLogDumpEnabled: " + enable);
        logDumpEnabled.set(enable);
    }

    public static final boolean isLogDumpEnabled() {
        return logDumpEnabled.get();
    }

    public static void startTrace(String traceId, String traceName) {
        EagleEye.startTrace(traceId, null, traceName);
    }

    public static void startTrace(String traceId, String rpcId, String traceName) {
        if (traceName == null) {
            return;
        }
        RpcContext_inner ctx = RpcContext_inner.get();
        if (ctx != null && ctx.traceId != null) {
            if (!ctx.traceId.equals(traceId) || !traceName.equals(ctx.traceName)) {
                EagleEye.selfLog("[WARN] duplicated startTrace detected, overrided " + ctx.traceId + " (" + ctx.traceName + ") to " + traceId + " (" + traceName + ")");
                EagleEye.endTrace();
            } else {
                return;
            }
        }
        if (traceId == null || traceId.isEmpty()) {
            traceId = TraceIdGenerator.generate();
            rpcId = ROOT_RPC_ID;
        } else if (rpcId == null || rpcId.length() > 64) {
            rpcId = ROOT_RPC_ID;
        }
        try {
            ctx = new RpcContext_inner(traceId, rpcId);
            RpcContext_inner.set(ctx);
            ctx.startTrace(traceName);
        }
        catch (Throwable re) {
            EagleEye.selfLog("[ERROR] startTrace", re);
        }
    }

    public static String startTrace4Top(String traceId) {
        RpcContext_inner ctx = RpcContext_inner.get();
        if (ctx != null && ctx.traceId != null) {
            return ctx.traceId;
        }
        try {
            if (traceId == null || traceId.isEmpty()) {
                traceId = TraceIdGenerator.generate();
            }
            ctx = new RpcContext_inner(traceId, ROOT_RPC_ID);
            ctx.isTopRpc = true;
            RpcContext_inner.set(ctx);
            return traceId;
        }
        catch (Throwable re) {
            EagleEye.selfLog("[ERROR] startTrace4Top", re);
            return null;
        }
    }

    public static void endTrace() {
        EagleEye.endTrace(null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endTrace(String resultCode, int type) {
        try {
            RpcContext_inner root = RpcContext_inner.get();
            if (null == root) {
                return;
            }
            while (null != root.parentRpc) {
                root = root.parentRpc;
            }
            if (root.isTopRpc) {
                return;
            }
            root.endTrace(resultCode, type);
            EagleEye.commitRpcContext(root);
        }
        catch (Throwable re) {
            EagleEye.selfLog("[ERROR] endTrace", re);
        }
        finally {
            EagleEye.clearRpcContext();
        }
    }

    static final RpcContext_inner createContextIfNotExists(boolean setToThreadLocal) {
        RpcContext_inner ctx = RpcContext_inner.get();
        if (null == ctx) {
            RpcContext_inner newCtx = new RpcContext_inner(TraceIdGenerator.generate(), MAL_ROOT_RPC_ID);
            if (setToThreadLocal) {
                RpcContext_inner.set(newCtx);
            }
            return newCtx;
        }
        return ctx;
    }

    @Deprecated
    public static void businessTag(String appId, String queryKey, String logContent) {
        bizEagleEyeLogger.logLine(appId, queryKey, logContent);
    }

    public static Object currentRpcContext() {
        try {
            RpcContext_inner ctx = RpcContext_inner.get();
            if (null != ctx) {
                return ctx.toMap();
            }
        }
        catch (Throwable re) {
            EagleEye.selfLog("[ERROR] currentRpcContext", re);
        }
        return null;
    }

    public static RpcContext_inner getRpcContext() {
        return RpcContext_inner.get();
    }

    public static RpcContext_inner createRootRpcContext(String traceId, String rpcId) {
        if (traceId == null) {
            traceId = TraceIdGenerator.generate();
        }
        if (rpcId == null) {
            rpcId = MAL_ROOT_RPC_ID;
        }
        return new RpcContext_inner(traceId, rpcId);
    }

    public static RpcContext_inner createRpcContextFromMap(Map<String, String> map) {
        return RpcContext_inner.fromMap(map);
    }

    public static void setRpcContext(Object rpcCtx) {
        try {
            RpcContext_inner ctx = null;
            if (rpcCtx instanceof Map) {
                ctx = RpcContext_inner.fromMap((Map)rpcCtx);
            } else if (rpcCtx instanceof RpcContext_inner) {
                ctx = (RpcContext_inner)rpcCtx;
            }
            RpcContext_inner.set(ctx);
        }
        catch (Throwable re) {
            EagleEye.selfLog("[ERROR] setRpcContext", re);
        }
    }

    public static void setRpcContext(RpcContext_inner context) {
        RpcContext_inner.set(context);
    }

    public static void clearRpcContext() {
        RpcContext_inner.set(null);
    }

    public static RpcContext_inner popRpcContext() {
        RpcContext_inner ctx = RpcContext_inner.get();
        if (null == ctx) {
            return null;
        }
        RpcContext_inner.set(ctx.parentRpc);
        return ctx;
    }

    public static TraceGroup traceGroup(String appName) {
        return EagleEye.createContextIfNotExists(true).traceGroup(appName);
    }

    public static StatLogger statLogger(String loggerName) {
        return EagleEye.statLoggerBuilder(loggerName).buildSingleton();
    }

    public static StatLoggerBuilder statLoggerBuilder(String loggerName) {
        return new StatLoggerBuilder(loggerName);
    }

    public static TraceLogger traceLogger(String loggerName) {
        return EagleEye.traceLoggerBuilder(loggerName).buildSingleton();
    }

    public static TraceLoggerBuilder traceLoggerBuilder(String loggerName) {
        return new TraceLoggerBuilder(loggerName);
    }

    public static void dump(String appId, String operationKey, Object obj, Object ... params) {
        AtpTraceClient.trace(appId, operationKey, obj, params);
    }

    public static void dumpImportant(String appId, String operationKey, Object obj, Object ... params) {
        AtpTraceClient.trace(true, appId, operationKey, obj, params);
    }

    public static void startRpc(String serviceName, String methodName) {
        try {
            RpcContext_inner ctx = RpcContext_inner.get();
            RpcContext_inner childCtx = null == ctx ? new RpcContext_inner(TraceIdGenerator.generate(), MAL_ROOT_RPC_ID) : ctx.createChildRpc();
            RpcContext_inner.set(childCtx);
            if (!childCtx.isTopRpc) {
                childCtx.startRpc(serviceName, methodName);
            }
        }
        catch (Throwable re) {
            EagleEye.selfLog("[ERROR] startRpc", re);
        }
    }

    public static void startLocal(String serviceName, String methodName) {
        try {
            RpcContext_inner ctx = RpcContext_inner.get();
            if (null == ctx) {
                EagleEye.selfLog("[ERROR] startLocal, no eagleeye trace in context");
                return;
            }
            RpcContext_inner cloneCtx = ctx.cloneInstance();
            RpcContext_inner.set(cloneCtx);
            cloneCtx.startLocal(serviceName, methodName);
        }
        catch (Throwable re) {
            EagleEye.selfLog("[ERROR] startLocal", re);
        }
    }

    public static void endLocal(String resultCode, String appendMsg) {
        try {
            RpcContext_inner ctx = RpcContext_inner.get();
            if (null == ctx) {
                EagleEye.selfLog("[ERROR] endLocal, no eagleeye trace in context");
                return;
            }
            ctx.endLocal(resultCode, appendMsg);
        }
        catch (Throwable re) {
            EagleEye.selfLog("[ERROR] endLocal", re);
        }
    }

    @Deprecated
    public static void annotateRpc(String tag) {
        try {
            RpcContext_inner ctx = RpcContext_inner.get();
            if (null == ctx) {
                return;
            }
            if (tag.equals(TAG_CLIENT_SEND)) {
                EagleEye.rpcClientSend();
            } else if (tag.equals(TAG_SERVER_RECV)) {
                EagleEye.rpcServerRecv(null, null);
            } else if (tag.equals(TAG_SERVER_SEND)) {
                EagleEye.rpcServerSend(2);
            } else if (tag.equals(TAG_CLIENT_RECV)) {
                EagleEye.rpcClientRecv(RPC_RESULT_SUCCESS, 1);
            } else if (tag.equals(TAG_CLIENT_SEND_OLD)) {
                EagleEye.rpcClientSend();
            } else if (tag.equals(TAG_SERVER_RECV_OLD)) {
                EagleEye.rpcServerRecv(null, null);
            } else if (tag.equals(TAG_SERVER_SEND_OLD)) {
                EagleEye.rpcServerSend(2);
            } else if (tag.equals(TAG_CLIENT_RECV_OLD)) {
                EagleEye.rpcClientRecv(RPC_RESULT_SUCCESS, 1);
            } else {
                EagleEye.selfLog("[ERROR] Unknown rpc tag:" + tag);
            }
        }
        catch (Throwable re) {
            EagleEye.selfLog("[ERROR] annotateRpc ERROR", re);
        }
    }

    @Deprecated
    public static void rpcClientSend(String serverIp, String service, String method) {
        EagleEye.rpcClientSend();
        EagleEye.remoteIp(serverIp);
    }

    @Deprecated
    public static void rpcClientSend(String msg) {
        EagleEye.rpcClientSend();
    }

    public static void rpcClientSend() {
        try {
            RpcContext_inner ctx = RpcContext_inner.get();
            if (null == ctx) {
                return;
            }
            if (!ctx.isTopRpc) {
                ctx.rpcClientSend();
            }
        }
        catch (Throwable re) {
            EagleEye.selfLog("[ERROR] rpcClientSend", re);
        }
    }

    @Deprecated
    public static void rpcClientRecv() {
        EagleEye.rpcClientRecv(RPC_RESULT_SUCCESS);
    }

    public static void rpcClientRecv(String resultCode) {
        EagleEye.rpcClientRecv(resultCode, 1);
    }

    public static void rpcClientRecv(String resultCode, int type) {
        EagleEye.rpcClientRecv(resultCode, type, null);
    }

    public static void rpcClientRecv(String resultCode, int type, String appendMsg) {
        try {
            RpcContext_inner ctx = RpcContext_inner.get();
            if (null == ctx) {
                return;
            }
            if (!ctx.isTopRpc) {
                ctx.endRpc(resultCode, type, appendMsg);
                EagleEye.commitRpcContext(ctx);
            }
            RpcContext_inner.set(ctx.parentRpc);
        }
        catch (Throwable re) {
            EagleEye.selfLog("[ERROR] rpcClientRecv", re);
        }
    }

    @Deprecated
    public static void rpcFail(String resultCode) {
        EagleEye.rpcClientRecv(resultCode, 1);
    }

    @Deprecated
    public static void rpcFail(String resultCode, int type) {
        EagleEye.rpcClientRecv(resultCode, type);
    }

    @Deprecated
    public static void rpcServerRecv(String clientIp, String service, String method) {
        EagleEye.rpcServerRecv(service, method);
        EagleEye.remoteIp(clientIp);
    }

    public static void rpcServerRecv(String service, String method) {
        try {
            EagleEye.createContextIfNotExists(true).rpcServerRecv(service, method);
        }
        catch (Throwable re) {
            EagleEye.selfLog("[ERROR] rpcServerRecv", re);
        }
    }

    public static void rpcServerSend() {
        EagleEye.rpcServerSend(2);
    }

    public static void rpcServerSend(int type) {
        EagleEye.rpcServerSend(null, type);
    }

    public static void rpcServerSend(String resultCode, int type) {
        EagleEye.rpcServerSend(resultCode, type, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rpcServerSend(String resultCode, int type, String appendMsg) {
        try {
            RpcContext_inner ctx = RpcContext_inner.get();
            if (ctx != null) {
                ctx.rpcServerSend(type, resultCode, appendMsg);
                EagleEye.commitRpcContext(ctx);
            }
        }
        catch (Throwable re) {
            EagleEye.selfLog("[ERROR] rpcServerRecv", re);
        }
        finally {
            EagleEye.clearRpcContext();
        }
    }

    public static String getTraceId() {
        RpcContext_inner ctx = RpcContext_inner.get();
        return null == ctx ? null : ctx.traceId;
    }

    public static String getRpcId() {
        RpcContext_inner ctx = RpcContext_inner.get();
        return null == ctx ? null : ctx.rpcId;
    }

    public static String getLocalId() {
        RpcContext_inner ctx = RpcContext_inner.get();
        return null == ctx ? "" : ctx.getLocalId();
    }

    public static void attribute(String key, String value) {
        EagleEye.createContextIfNotExists(true).putLocalAttribute(key, value);
    }

    public static String getUserData(String key) {
        RpcContext_inner ctx = RpcContext_inner.get();
        return null != ctx ? ctx.getUserData(key) : null;
    }

    public static String putUserData(String key, String value) {
        return EagleEye.createContextIfNotExists(true).putUserData(key, value);
    }

    public static String removeUserData(String key) {
        RpcContext_inner ctx = RpcContext_inner.get();
        return null != ctx ? ctx.removeUserData(key) : null;
    }

    public static Map<String, String> getUserDataMap() {
        RpcContext_inner ctx = RpcContext_inner.get();
        return null != ctx ? ctx.getUserDataMap() : null;
    }

    public static String exportUserData() {
        RpcContext_inner ctx = RpcContext_inner.get();
        return null != ctx ? ctx.exportUserData() : null;
    }

    public static void callBack(String msg) {
        if (msg != null && msg.length() < 4096) {
            RpcContext_inner ctx = RpcContext_inner.get();
            if (null == ctx) {
                return;
            }
            ctx.callBackMsg = msg;
        }
    }

    public static void requestSize(long size) {
        RpcContext_inner ctx = RpcContext_inner.get();
        if (null == ctx) {
            return;
        }
        ctx.requestSize = size;
    }

    public static void remoteIp(String remoteIp) {
        RpcContext_inner ctx = RpcContext_inner.get();
        if (null == ctx) {
            return;
        }
        ctx.remoteIp = remoteIp;
    }

    public static void responseSize(long size) {
        RpcContext_inner ctx = RpcContext_inner.get();
        if (null == ctx) {
            return;
        }
        ctx.responseSize = size;
    }

    public static void rpcLog(int type, String msg) {
        EagleEye.rpcLog(type, msg, true);
    }

    public static void rpcLog(int type, String msg, boolean appendRpcId) {
        try {
            RpcContext_inner ctx = RpcContext_inner.get();
            if (null == ctx || ctx.isTopRpc) {
                return;
            }
            if (msg != null && msg.length() < 4096) {
                RpcContext_inner sub = new RpcContext_inner(ctx.traceId, appendRpcId ? ctx.rpcId : null);
                sub.rpcLog(type, msg, appendRpcId);
                EagleEye.commitRpcContext(sub);
            }
        }
        catch (Throwable e) {
            EagleEye.selfLog("[ERROR] rpcLog", e);
        }
    }

    public static String generateTraceId(String ip) {
        return TraceIdGenerator.generate(ip);
    }

    public static String generateMulticastRpcId(String rpcId, String identifier) {
        if (rpcId == null || rpcId.length() == 0) {
            rpcId = ROOT_RPC_ID;
        }
        return rpcId + "." + TraceIdGenerator.generateIpv4Id();
    }

    public static String index(String msg) {
        try {
            if (msg != null && msg.length() > 8) {
                String index = indexes.get(msg);
                if (index != null) {
                    return index;
                }
                if ((long)indexes.size() >= 1000L) {
                    return INDEX_NOT_INDEXED;
                }
                index = EagleEyeCoreUtils.digest(msg);
                String rs = indexes.putIfAbsent(msg, index);
                if (rs == null) {
                    EagleEye.index(9, index, msg);
                    EagleEye.selfLog("[INFO] generate index: " + index + " => " + msg);
                }
                return index;
            }
            return msg;
        }
        catch (Throwable e) {
            EagleEye.selfLog("[ERROR] index: " + msg, e);
            return msg;
        }
    }

    static void index(int type, String index, String msg) {
        RpcContext_inner sub = new RpcContext_inner(INDEX_OUTPUT_TRACE_ID, MAL_ROOT_RPC_ID);
        sub.index(type, index, EagleEyeCoreUtils.filterInvalidCharacters(msg));
        EagleEye.commitRpcContext(sub);
    }

    static String exportIndexes() {
        StringBuilder builder = new StringBuilder(128 * indexes.size());
        for (Map.Entry<String, String> entry : indexes.entrySet()) {
            builder.append(entry.getValue()).append(" -> ").append(entry.getKey()).append('\n');
        }
        return builder.toString();
    }

    public static void commitRpcContext(RpcContext_inner ctx) {
        if (ctx.logType >= 0 && !EagleEye.isRpcOff() && ctx.isTraceSampled()) {
            rpcAppender.append(ctx);
        }
    }

    static void commitLocalContext(LocalContext_inner ctx) {
        if (ctx.logType >= 0 && !EagleEye.isRpcOff() && ctx.isTraceSampled()) {
            rpcAppender.append(ctx);
        }
    }

    @Deprecated
    public static void commitBusinessTag(RpcContext_inner ctx, String appId, String queryKey, String logContent) {
        bizEagleEyeLogger.logLineWithContext(ctx, appId, queryKey, logContent);
    }

    public static void setEagelEyeRpcAppender(EagleEyeAppender appender) {
        rpcAppender.setEagleEyeAppender(appender);
    }

    public static void setEagelEyeBizAppender(EagleEyeAppender appender) {
        bizAppender.setEagleEyeAppender(appender);
    }

    static void setEagelEyeSelfAppender(EagleEyeAppender appender) {
        selfAppender = appender;
    }

    public static void selfLog(String log) {
        try {
            String timestamp = EagleEyeCoreUtils.formatTime(System.currentTimeMillis());
            String line = "[" + timestamp + "] " + log + "\r\n";
            selfAppender.append(line);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void selfLog(String log, Throwable e) {
        if (exceptionThreshold.incrementAndGet() <= MAX_EXCEPTION_COUNT) {
            try {
                String timestamp = EagleEyeCoreUtils.formatTime(System.currentTimeMillis());
                StringWriter sw = new StringWriter(4096);
                PrintWriter pw = new PrintWriter((Writer)sw, false);
                pw.append('[').append(timestamp).append("] ").append(log).append("\r\n");
                e.printStackTrace(pw);
                pw.println();
                pw.flush();
                selfAppender.append(sw.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void flush() {
        EagleEyeLogDaemon.flushAndWait();
    }

    @Deprecated
    public static void log(String logKey, Long userId, String bizId, int operateType, String operateContent) {
        if (EagleEyeCoreUtils.isBlank(logKey)) {
            return;
        }
        EagleEye.log(logKey, userId, bizId, null, operateType, operateContent, new LinkedHashMap<String, String>());
    }

    @Deprecated
    public static void log(String logKey, Long userId, String bizId, Long operatorId, int operateType, String operateContent) {
        if (EagleEyeCoreUtils.isBlank(logKey)) {
            return;
        }
        EagleEye.log(logKey, userId, bizId, operatorId, operateType, operateContent, new LinkedHashMap<String, String>());
    }

    @Deprecated
    public static void log(String logKey, Long userId, String bizId, int operateType, String operateContent, String ... extendInfos) {
        if (EagleEyeCoreUtils.isBlank(logKey)) {
            return;
        }
        if (null == extendInfos || extendInfos.length == 0) {
            extendInfos = EagleEyeCoreUtils.EMPTY_STRING_ARRAY;
        }
        EagleEye.log(logKey, userId, bizId, null, operateType, operateContent, extendInfos);
    }

    @Deprecated
    public static void log(String logKey, Long userId, String bizId, int operateType, String operateContent, Map<String, String> extendInfos) {
        if (EagleEyeCoreUtils.isBlank(logKey)) {
            return;
        }
        if (null == extendInfos || extendInfos.size() == 0) {
            extendInfos = new LinkedHashMap<String, String>();
        }
        EagleEye.log(logKey, userId, bizId, null, operateType, operateContent, extendInfos);
    }

    @Deprecated
    public static void log(String logKey, Long userId, String bizId, Long operatorId, int operateType, String operateContent, String ... extendInfos) {
        if (EagleEyeCoreUtils.isBlank(logKey)) {
            return;
        }
        String msg = EagleEye.getMsg(logKey, userId, bizId, operatorId, operateType, operateContent, extendInfos);
        EagleEye.businessTag(ULC_EAGLEEYE_APPID, logKey, msg.toString());
    }

    @Deprecated
    public static void log(String logKey, Long userId, String bizId, Long operatorId, int operateType, String operateContent, Map<String, String> extendInfos) {
        if (EagleEyeCoreUtils.isBlank(logKey)) {
            return;
        }
        String msg = EagleEye.getMsg(logKey, userId, bizId, operatorId, operateType, operateContent, extendInfos);
        EagleEye.businessTag(ULC_EAGLEEYE_APPID, logKey, msg.toString());
    }

    @Deprecated
    public static void log(LogContext logContext) {
        EagleEye.log(ULC_EAGLEEYE_APPID, logContext);
    }

    @Deprecated
    public static void log(String appId, LogContext logContext) {
        if (EagleEyeCoreUtils.isBlank(logContext.getLogKey())) {
            return;
        }
        String msg = EagleEye.getMsg(logContext);
        EagleEye.businessTag(appId, logContext.getLogKey(), msg.toString());
    }

    @Deprecated
    private static String getMsg(String logKey, Long userId, String bizId, Long operatorId, int operateType, String operateContent, String ... extendInfos) {
        LogContext logContext = new LogContext();
        logContext.logKey(logKey).userId(userId).bizId(bizId).operatorId(operatorId).operateType(operateType).operateContent(operateContent).extendArray(extendInfos);
        return EagleEye.getMsg(logContext);
    }

    @Deprecated
    private static String getMsg(String logKey, Long userId, String bizId, Long operatorId, int operateType, String operateContent, Map<String, String> extendInfos) {
        LogContext logContext = new LogContext();
        logContext.logKey(logKey).userId(userId).bizId(bizId).operatorId(operatorId).operateType(operateType).operateContent(operateContent).extendInfos(extendInfos);
        return EagleEye.getMsg(logContext);
    }

    @Deprecated
    private static String getMsg(LogContext logContext) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append(logContext.getLogKey()).append('\u0012');
        if (null != logContext.getUserId()) {
            sBuilder.append(logContext.getUserId());
        } else {
            sBuilder.append(0L);
        }
        sBuilder.append('\u0012');
        if (EagleEyeCoreUtils.isNotBlank(logContext.getBizId())) {
            sBuilder.append(logContext.getBizId());
        } else {
            sBuilder.append("");
        }
        sBuilder.append('\u0012');
        if (null != logContext.getOperatorId()) {
            sBuilder.append(logContext.getOperatorId());
        } else {
            sBuilder.append(0L);
        }
        sBuilder.append('\u0012');
        sBuilder.append(logContext.getOperateType()).append('\u0012');
        if (EagleEyeCoreUtils.isNotBlank(logContext.getOperateContent())) {
            sBuilder.append(logContext.getOperateContent());
        } else {
            sBuilder.append("");
        }
        sBuilder.append('\u0012');
        if (EagleEyeCoreUtils.isNotBlank(logContext.getUserNick())) {
            sBuilder.append(logContext.getUserNick());
        } else {
            sBuilder.append("");
        }
        sBuilder.append('\u0012');
        if (EagleEyeCoreUtils.isNotBlank(logContext.getOpLevel())) {
            sBuilder.append(logContext.getOpLevel());
        } else {
            sBuilder.append("");
        }
        sBuilder.append('\u0012');
        if (EagleEyeCoreUtils.isNotBlank(logContext.getOpItem())) {
            sBuilder.append(logContext.getOpItem());
        } else {
            sBuilder.append("");
        }
        if (null != logContext.getExtendArray() && logContext.getExtendArray().length > 0) {
            for (String info : logContext.getExtendArray()) {
                if (EagleEyeCoreUtils.isBlank(info)) {
                    info = "";
                }
                sBuilder.append('\u0012').append(info);
            }
        }
        if (null != logContext.getExtendInfos() && logContext.getExtendInfos().size() > 0) {
            for (Map.Entry<String, String> entry : logContext.getExtendInfos().entrySet()) {
                String key = entry.getKey();
                if (!EagleEyeCoreUtils.isNotBlank(key)) continue;
                String value = entry.getValue();
                sBuilder.append('\u0012').append(key).append('\u0001');
                if (value == null) continue;
                EagleEyeCoreUtils.appendWithBlankCheck(value.toString(), "", sBuilder);
            }
        }
        return sBuilder.toString();
    }

    static {
        selfAppender = EagleEye.createSelfLogger();
        exceptionThreshold = new AtomicInteger(0);
        MAX_EXCEPTION_COUNT = 5;
        rpcRecord = new AtomicBoolean(true);
        bizRecord = new AtomicBoolean(true);
        clusterTestEnabled = new AtomicBoolean(true);
        userDataEnabled = new AtomicBoolean(true);
        logDumpEnabled = new AtomicBoolean(true);
        indexes = new ConcurrentHashMap();
        samplingInterval = 1;
        EagleEye.selfLog("[INFO] EagleEye started (" + EagleEye.getEagleEyeLocation() + ")");
        try {
            EagleEye.createEagleEyeLoggers();
        }
        catch (Throwable e) {
            EagleEye.selfLog("[ERROR] fail to create EagleEye logger", e);
        }
        try {
            EagleEyeLogDaemon.start();
        }
        catch (Throwable e) {
            EagleEye.selfLog("[ERROR] fail to start EagleEyeLogDaemon", e);
        }
        try {
            StatLogController.start();
        }
        catch (Throwable e) {
            EagleEye.selfLog("[ERROR] fail to start StatLogController", e);
        }
        try {
            EagleEyeJVMPatchImpl.setupInstance();
        }
        catch (Throwable e) {
            EagleEye.selfLog("[ERROR] fail to setup EagleEyeJVMPatchImpl", e);
        }
    }
}

