/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.eagleeye;

import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEye;
import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEyeAppender;
import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEyeCoreUtils;
import com.alibaba.dts.shade.com.taobao.eagleeye.FastDateFormat;
import com.alibaba.dts.shade.com.taobao.eagleeye.NamedThreadFactory;
import com.alibaba.dts.shade.com.taobao.eagleeye.StatEntry;
import com.alibaba.dts.shade.com.taobao.eagleeye.StatEntryFunc;
import com.alibaba.dts.shade.com.taobao.eagleeye.StatLogger;
import com.alibaba.dts.shade.com.taobao.eagleeye.StatLoggerBuilder;
import com.alibaba.dts.shade.com.taobao.eagleeye.StatRollingData;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

class StatLogController {
    private static final Map<String, StatLogger> statLoggers = new HashMap<String, StatLogger>();
    private static final ScheduledExecutorService rollerThreadPool = Executors.newScheduledThreadPool(1, new NamedThreadFactory("EagleEye-stat-roller", true));
    private static final BlockingQueue<StatRollingData> statQueue = new ArrayBlockingQueue<StatRollingData>(128);
    private static AtomicBoolean running = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static StatLogger createLoggerIfNotExists(StatLoggerBuilder builder) {
        String loggerName = builder.getLoggerName();
        Class<StatLogController> clazz = StatLogController.class;
        synchronized (StatLogController.class) {
            StatLogger statLogger = statLoggers.get(loggerName);
            if (statLogger == null) {
                statLogger = builder.create();
                statLoggers.put(loggerName, statLogger);
                StatLogController.scheduleRollingTask(statLogger);
                EagleEye.selfLog("[INFO] created statLogger[" + statLogger.getLoggerName() + "]: " + statLogger.getAppender());
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return statLogger;
        }
    }

    private static void scheduleRollingTask(StatLogger statLogger) {
        long rollingTimeMillis = statLogger.getRollingData().getRollingTimeMillis();
        long delayMillis = rollingTimeMillis - System.currentTimeMillis();
        if (delayMillis > 5L) {
            rollerThreadPool.schedule(new StatLogRollingTask(statLogger), delayMillis, TimeUnit.MILLISECONDS);
        } else {
            rollerThreadPool.submit(new StatLogRollingTask(statLogger));
        }
    }

    static void start() {
        if (running.compareAndSet(false, true)) {
            Thread statLogWriter = new Thread((Runnable)new StatLogWriteTask(), "EagleEye-StatLogger-Thread");
            statLogWriter.setDaemon(true);
            statLogWriter.start();
        }
    }

    private StatLogController() {
    }

    private static class StatLogWriteTask
    implements Runnable {
        private int DEFAULT_BUFFER_SIZE = 256;
        private StringBuilder buffer = new StringBuilder(this.DEFAULT_BUFFER_SIZE);
        private FastDateFormat fmt = new FastDateFormat();

        private StatLogWriteTask() {
        }

        @Override
        public void run() {
            while (true) {
                StatLogger logger = null;
                try {
                    StatRollingData data = this.coolDown((StatRollingData)statQueue.take());
                    logger = data.getStatLogger();
                    String timeStr = this.fmt.formatWithoutMs(data.getTimeSlot());
                    EagleEyeAppender appender = logger.getAppender();
                    Set<Map.Entry<StatEntry, StatEntryFunc>> entrySet = data.getStatEntrySet();
                    char entryDelimiter = logger.getEntryDelimiter();
                    char keyDelimiter = logger.getKeyDelimiter();
                    char valueDelimiter = logger.getValueDelimiter();
                    StringBuilder buffer = this.buffer;
                    for (Map.Entry<StatEntry, StatEntryFunc> entry : entrySet) {
                        buffer.delete(0, buffer.length());
                        StatEntryFunc func = entry.getValue();
                        buffer.append(timeStr).append(entryDelimiter);
                        buffer.append(func.getStatType()).append(entryDelimiter);
                        entry.getKey().appendTo(buffer, keyDelimiter);
                        buffer.append(entryDelimiter);
                        func.appendTo(buffer, valueDelimiter);
                        buffer.append("\r\n");
                        appender.append(buffer.toString());
                    }
                    appender.flush();
                    continue;
                }
                catch (InterruptedException e) {
                    continue;
                }
                catch (Exception e) {
                    if (logger == null) {
                        EagleEye.selfLog("[WARN] fail to take StatRollingData from queue", e);
                        continue;
                    }
                    EagleEye.selfLog("[WARN] fail to write stat log of group " + logger.getLoggerName(), e);
                    continue;
                }
                break;
            }
        }

        private StatRollingData coolDown(StatRollingData data) {
            long now = System.currentTimeMillis();
            long coolDownTime = data.getRollingTimeMillis() + 200L - now;
            if (coolDownTime > 0L) {
                try {
                    Thread.sleep(coolDownTime);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            return data;
        }
    }

    private static class StatLogRollingTask
    implements Runnable {
        final StatLogger statLogger;

        StatLogRollingTask(StatLogger statLogger) {
            this.statLogger = statLogger;
        }

        @Override
        public void run() {
            boolean offered;
            StatRollingData statRollingData = this.statLogger.rolling();
            if (statRollingData != null && !(offered = statQueue.offer(statRollingData))) {
                long timeSlot = statRollingData.getTimeSlot();
                EagleEye.selfLog("[WARN] fail to offer StatRollingData to queue: " + this.statLogger.getLoggerName() + ", " + EagleEyeCoreUtils.formatTime(timeSlot));
            }
            StatLogController.scheduleRollingTask(this.statLogger);
        }
    }
}

