/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.eagleeye;

import com.alibaba.dts.shade.com.taobao.eagleeye.AsyncAppender;
import com.alibaba.dts.shade.com.taobao.eagleeye.BaseLoggerBuilder;
import com.alibaba.dts.shade.com.taobao.eagleeye.DefaultTraceEncoder;
import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEye;
import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEyeAppender;
import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEyeLogDaemon;
import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEyeRollingFileAppender;
import com.alibaba.dts.shade.com.taobao.eagleeye.TraceLogger;
import java.util.HashMap;
import java.util.Map;

public final class TraceLoggerBuilder
extends BaseLoggerBuilder<TraceLoggerBuilder> {
    private static final Map<String, TraceLogger> traceLoggers = new HashMap<String, TraceLogger>();
    private EagleEyeAppender appender = null;
    private int asyncQueueSize = 4096;
    private int maxWaitMillis = 0;

    TraceLoggerBuilder(String loggerName) {
        super(loggerName);
    }

    TraceLoggerBuilder appender(EagleEyeAppender appender) {
        this.appender = appender;
        return this;
    }

    TraceLogger create() {
        AsyncAppender asyncAppender;
        String filePath = this.filePath == null ? EagleEye.EAGLEEYE_LOG_DIR + "trace-" + this.loggerName + ".log" : (this.filePath.endsWith("/") || this.filePath.endsWith("\\") ? this.filePath + "trace-" + this.loggerName + ".log" : this.filePath);
        EagleEyeAppender appender = this.appender;
        if (appender == null) {
            EagleEyeRollingFileAppender rfappender = new EagleEyeRollingFileAppender(filePath, this.maxFileSize);
            rfappender.setMaxBackupIndex(this.maxBackupIndex);
            appender = rfappender;
        }
        if (appender instanceof AsyncAppender) {
            asyncAppender = (AsyncAppender)appender;
        } else {
            asyncAppender = new AsyncAppender(this.asyncQueueSize, this.maxWaitMillis);
            asyncAppender.start(appender, new DefaultTraceEncoder(this.entryDelimiter), "TraceLog-" + this.loggerName);
        }
        EagleEyeLogDaemon.watch(asyncAppender);
        return new TraceLogger(this.loggerName, asyncAppender);
    }

    public TraceLoggerBuilder asyncQueueSize(int asyncQueueSize) {
        if (asyncQueueSize < 128) {
            throw new IllegalArgumentException("\u8bbe\u7f6e\u65e5\u5fd7\u5f02\u6b65\u961f\u5217\u7684\u5927\u5c0f\u4e0d\u80fd\u5c0f\u4e8e 128: " + asyncQueueSize);
        }
        this.asyncQueueSize = asyncQueueSize;
        return this;
    }

    public TraceLoggerBuilder maxWaitMillis(int maxWaitMillis) {
        this.maxWaitMillis = maxWaitMillis;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TraceLogger buildSingleton() {
        Class<TraceLoggerBuilder> clazz = TraceLoggerBuilder.class;
        synchronized (TraceLoggerBuilder.class) {
            TraceLogger traceLogger = traceLoggers.get(this.loggerName);
            if (traceLogger == null) {
                traceLogger = this.create();
                traceLoggers.put(this.loggerName, traceLogger);
                EagleEye.selfLog("[INFO] created traceLogger[" + traceLogger.getLoggerName() + "]: " + traceLogger.getAppender());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return traceLogger;
        }
    }
}

