/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.eagleeye.json;

import com.alibaba.dts.shade.com.taobao.eagleeye.json.DefaultJSONParser;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.JSONArray;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.JSONSerializer;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.ObjectDeserializer;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.ObjectSerializer;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.SerializeWriter;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicLongArray;

class AtomicLongArrayCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static final AtomicLongArrayCodec instance = new AtomicLongArrayCodec();

    AtomicLongArrayCodec() {
    }

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
        SerializeWriter out = serializer.getWriter();
        if (object == null) {
            if (out.isEnabled(SerializerFeature.WriteNullListAsEmpty)) {
                out.write("[]");
            } else {
                out.writeNull();
            }
            return;
        }
        AtomicLongArray array = (AtomicLongArray)object;
        int len = array.length();
        out.append('[');
        for (int i = 0; i < len; ++i) {
            long val = array.get(i);
            if (i != 0) {
                out.write(',');
            }
            out.writeLong(val);
        }
        out.append(']');
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        if (parser.getLexer().token() == 8) {
            parser.getLexer().nextToken(16);
            return null;
        }
        JSONArray array = new JSONArray();
        parser.parseArray(array);
        AtomicLongArray atomicArray = new AtomicLongArray(array.size());
        for (int i = 0; i < array.size(); ++i) {
            atomicArray.set(i, array.getLong(i));
        }
        return (T)atomicArray;
    }

    @Override
    public int getFastMatchToken() {
        return 14;
    }
}

