/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.eagleeye.json;

import com.alibaba.dts.shade.com.taobao.eagleeye.json.DefaultJSONParser;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.FieldDeserializer;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.FieldInfo;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.JSONLexer;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.ParserConfig;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.TypeUtils;
import java.lang.reflect.Type;
import java.util.Map;

class BooleanFieldDeserializer
extends FieldDeserializer {
    public BooleanFieldDeserializer(ParserConfig mapping, Class<?> clazz, FieldInfo fieldInfo) {
        super(clazz, fieldInfo);
    }

    @Override
    public void parseField(DefaultJSONParser parser, Object object, Type objectType, Map<String, Object> fieldValues) {
        JSONLexer lexer = parser.getLexer();
        if (lexer.token() == 6) {
            lexer.nextToken(16);
            if (object == null) {
                fieldValues.put(this.fieldInfo.getName(), Boolean.TRUE);
            } else {
                this.setValue(object, true);
            }
            return;
        }
        if (lexer.token() == 2) {
            boolean booleanValue;
            int val = lexer.intValue();
            lexer.nextToken(16);
            boolean bl = booleanValue = val == 1;
            if (object == null) {
                fieldValues.put(this.fieldInfo.getName(), booleanValue);
            } else {
                this.setValue(object, booleanValue);
            }
            return;
        }
        if (lexer.token() == 8) {
            Object value = null;
            lexer.nextToken(16);
            if (this.getFieldClass() == Boolean.TYPE) {
                return;
            }
            if (object != null) {
                this.setValue(object, null);
            }
            return;
        }
        if (lexer.token() == 7) {
            lexer.nextToken(16);
            if (object == null) {
                fieldValues.put(this.fieldInfo.getName(), Boolean.FALSE);
            } else {
                this.setValue(object, false);
            }
            return;
        }
        Object obj = parser.parse();
        Boolean value = TypeUtils.castToBoolean(obj);
        if (value == null && this.getFieldClass() == Boolean.TYPE) {
            return;
        }
        if (object == null) {
            fieldValues.put(this.fieldInfo.getName(), value);
        } else {
            this.setValue(object, value);
        }
    }

    @Override
    public int getFastMatchToken() {
        return 6;
    }
}

