/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.eagleeye.json;

import com.alibaba.dts.shade.com.taobao.eagleeye.json.DefaultJSONParser;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.Feature;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.JSON;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.JSONException;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.JSONLexer;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.JSONToken;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.ObjectDeserializer;
import java.lang.reflect.Type;

class StackTraceElementDeserializer
implements ObjectDeserializer {
    public static final StackTraceElementDeserializer instance = new StackTraceElementDeserializer();

    StackTraceElementDeserializer() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        JSONLexer lexer = parser.getLexer();
        if (lexer.token() == 8) {
            lexer.nextToken();
            return null;
        }
        if (lexer.token() != 12 && lexer.token() != 16) {
            throw new JSONException("syntax error: " + JSONToken.name(lexer.token()));
        }
        String declaringClass = null;
        String methodName = null;
        String fileName = null;
        int lineNumber = 0;
        while (true) {
            String key;
            if ((key = lexer.scanSymbol(parser.getSymbolTable())) == null) {
                if (lexer.token() == 13) {
                    lexer.nextToken(16);
                    return (T)new StackTraceElement(declaringClass, methodName, fileName, lineNumber);
                }
                if (lexer.token() == 16 && lexer.isEnabled(Feature.AllowArbitraryCommas)) continue;
            }
            lexer.nextTokenWithColon(4);
            if (key == "className") {
                if (lexer.token() == 8) {
                    declaringClass = null;
                } else {
                    if (lexer.token() != 4) throw new JSONException("syntax error");
                    declaringClass = lexer.stringVal();
                }
            } else if (key == "methodName") {
                if (lexer.token() == 8) {
                    methodName = null;
                } else {
                    if (lexer.token() != 4) throw new JSONException("syntax error");
                    methodName = lexer.stringVal();
                }
            } else if (key == "fileName") {
                if (lexer.token() == 8) {
                    fileName = null;
                } else {
                    if (lexer.token() != 4) throw new JSONException("syntax error");
                    fileName = lexer.stringVal();
                }
            } else if (key == "lineNumber") {
                if (lexer.token() == 8) {
                    lineNumber = 0;
                } else {
                    if (lexer.token() != 2) throw new JSONException("syntax error");
                    lineNumber = lexer.intValue();
                }
            } else if (key == "nativeMethod") {
                if (lexer.token() == 8) {
                    lexer.nextToken(16);
                } else if (lexer.token() == 6) {
                    lexer.nextToken(16);
                } else {
                    if (lexer.token() != 7) throw new JSONException("syntax error");
                    lexer.nextToken(16);
                }
            } else {
                if (key != JSON.DEFAULT_TYPE_KEY) throw new JSONException("syntax error : " + key);
                if (lexer.token() == 4) {
                    String elementType = lexer.stringVal();
                    if (!elementType.equals("java.lang.StackTraceElement")) {
                        throw new JSONException("syntax error : " + elementType);
                    }
                } else if (lexer.token() != 8) {
                    throw new JSONException("syntax error");
                }
            }
            if (lexer.token() == 13) break;
        }
        lexer.nextToken(16);
        return (T)new StackTraceElement(declaringClass, methodName, fileName, lineNumber);
    }

    @Override
    public int getFastMatchToken() {
        return 12;
    }
}

