/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.spas.sdk.client.identity;

import com.alibaba.dts.shade.com.taobao.spas.sdk.client.identity.CredentialService;
import com.alibaba.dts.shade.com.taobao.spas.sdk.client.identity.Credentials;
import com.alibaba.dts.shade.com.taobao.spas.sdk.common.config.SpasConfigLoader;
import com.alibaba.dts.shade.com.taobao.spas.sdk.common.log.SpasLogCode;
import com.alibaba.dts.shade.com.taobao.spas.sdk.common.log.SpasLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;

public class CredentialWatcher {
    private static final long REFRESH_INTERVAL = 10000L;
    private CredentialService serviceInstance;
    private String appName;
    private String propertyPath;
    private TimerTask watcher;
    private boolean stopped;

    public CredentialWatcher(String appName, CredentialService serviceInstance) {
        this.appName = appName;
        this.serviceInstance = serviceInstance;
        this.loadCredential(true);
        this.watcher = new TimerTask(){
            private Timer timer = new Timer(true);
            private long modified = 0L;
            {
                this.timer.schedule((TimerTask)this, 10000L, 10000L);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (CredentialWatcher.this.stopped) {
                        return;
                    }
                    boolean reload = false;
                    if (CredentialWatcher.this.propertyPath == null) {
                        reload = true;
                    } else {
                        File file = new File(CredentialWatcher.this.propertyPath);
                        long lastModified = file.lastModified();
                        if (this.modified != lastModified) {
                            reload = true;
                            this.modified = lastModified;
                        }
                    }
                    if (reload) {
                        CredentialWatcher.this.loadCredential(false);
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.stopped) {
            return;
        }
        if (this.watcher != null) {
            TimerTask timerTask = this.watcher;
            synchronized (timerTask) {
                this.watcher.cancel();
                this.stopped = true;
            }
        }
        SpasLogger.info(this.appName, this.getClass().getSimpleName() + " is stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCredential(boolean init) {
        Credentials credential;
        boolean logWarn;
        boolean bl = logWarn = init || !this.serviceInstance.getCredential().valid();
        if (this.propertyPath == null) {
            URL url = ClassLoader.getSystemResource("spas.properties");
            if (url != null) {
                this.propertyPath = url.getPath();
            }
            if (this.propertyPath == null || this.propertyPath.isEmpty()) {
                this.propertyPath = SpasConfigLoader.getProperty("spas.identity");
                if (this.propertyPath == null || this.propertyPath.isEmpty()) {
                    this.propertyPath = "/home/admin/.spas_key/" + (this.appName == null ? "default" : this.appName);
                } else if (logWarn) {
                    SpasLogger.info(this.appName, "Defined credential file: -Dspas.identity=" + this.propertyPath);
                }
            } else if (logWarn) {
                SpasLogger.info(this.appName, "Load credential file from classpath: spas.properties");
            }
        }
        FileInputStream propertiesIS = null;
        while (true) {
            try {
                propertiesIS = new FileInputStream(this.propertyPath);
            }
            catch (FileNotFoundException e) {
                if (this.appName != null && !this.appName.equals("default") && this.propertyPath.equals("/home/admin/.spas_key/" + this.appName)) {
                    this.propertyPath = "/home/admin/.spas_key/default";
                    continue;
                }
                if ("/etc/instanceInfo".equals(this.propertyPath)) break;
                this.propertyPath = "/etc/instanceInfo";
                continue;
            }
            break;
        }
        String accessKey = null;
        String secretKey = null;
        if (propertiesIS == null) {
            this.propertyPath = null;
            accessKey = System.getenv("spas_accessKey");
            secretKey = System.getenv("spas_secretKey");
            if (accessKey == null && secretKey == null) {
                if (logWarn) {
                    SpasLogger.info(this.appName, "No credential found");
                }
                return;
            }
            if (logWarn) {
                SpasLogger.info(this.appName, "Load credential from env");
            }
        } else {
            Properties properties = new Properties();
            try {
                properties.load(propertiesIS);
            }
            catch (IOException e) {
                SpasLogger.error(SpasLogCode.SPAS0026, this.appName, "Unable to load credential file " + this.propertyPath, e);
                this.propertyPath = null;
                return;
            }
            finally {
                try {
                    ((InputStream)propertiesIS).close();
                }
                catch (IOException e) {
                    SpasLogger.error(SpasLogCode.SPAS0027, this.appName, "Unable to close credential file " + this.propertyPath, e);
                }
            }
            if (logWarn) {
                SpasLogger.info(this.appName, "Load credential file " + this.propertyPath);
            }
            if (!"/etc/instanceInfo".equals(this.propertyPath)) {
                if (properties.containsKey("accessKey")) {
                    accessKey = properties.getProperty("accessKey");
                }
                if (properties.containsKey("secretKey")) {
                    secretKey = properties.getProperty("secretKey");
                }
            } else {
                if (properties.containsKey("env_spas_accessKey")) {
                    accessKey = properties.getProperty("env_spas_accessKey");
                }
                if (properties.containsKey("env_spas_secretKey")) {
                    secretKey = properties.getProperty("env_spas_secretKey");
                }
            }
        }
        if (accessKey != null) {
            accessKey = accessKey.trim();
        }
        if (secretKey != null) {
            secretKey = secretKey.trim();
        }
        if (!(credential = new Credentials(accessKey, secretKey)).valid()) {
            SpasLogger.warn(SpasLogCode.SPAS0001, this.appName, "Credential file missing accessKey or secretKey");
            this.propertyPath = null;
        }
        this.serviceInstance.setCredential(credential);
    }
}

