/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.codehaus.jackson.map.deser.std;

import com.alibaba.dts.shade.org.codehaus.jackson.JsonParser;
import com.alibaba.dts.shade.org.codehaus.jackson.JsonProcessingException;
import com.alibaba.dts.shade.org.codehaus.jackson.JsonToken;
import com.alibaba.dts.shade.org.codehaus.jackson.map.DeserializationContext;
import com.alibaba.dts.shade.org.codehaus.jackson.map.JsonDeserializer;
import com.alibaba.dts.shade.org.codehaus.jackson.map.JsonMappingException;
import com.alibaba.dts.shade.org.codehaus.jackson.map.deser.BeanDeserializer;
import com.alibaba.dts.shade.org.codehaus.jackson.map.deser.SettableBeanProperty;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThrowableDeserializer
extends BeanDeserializer {
    protected static final String PROP_NAME_MESSAGE = "message";

    public ThrowableDeserializer(BeanDeserializer baseDeserializer) {
        super(baseDeserializer);
    }

    protected ThrowableDeserializer(BeanDeserializer src, boolean ignoreAllUnknown) {
        super(src, ignoreAllUnknown);
    }

    @Override
    public JsonDeserializer<Object> unwrappingDeserializer() {
        if (this.getClass() != ThrowableDeserializer.class) {
            return this;
        }
        return new ThrowableDeserializer(this, true);
    }

    @Override
    public Object deserializeFromObject(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (this._propertyBasedCreator != null) {
            return this._deserializeUsingPropertyBased(jp, ctxt);
        }
        if (this._delegateDeserializer != null) {
            return this._valueInstantiator.createUsingDelegate(this._delegateDeserializer.deserialize(jp, ctxt));
        }
        if (this._beanType.isAbstract()) {
            throw JsonMappingException.from(jp, "Can not instantiate abstract type " + this._beanType + " (need to add/enable type information?)");
        }
        boolean hasStringCreator = this._valueInstantiator.canCreateFromString();
        boolean hasDefaultCtor = this._valueInstantiator.canCreateUsingDefault();
        if (!hasStringCreator && !hasDefaultCtor) {
            throw new JsonMappingException("Can not deserialize Throwable of type " + this._beanType + " without having a default contructor, a single-String-arg constructor; or explicit @JsonCreator");
        }
        Object throwable = null;
        Object[] pending = null;
        int pendingIx = 0;
        while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
            String propName = jp.getCurrentName();
            SettableBeanProperty prop = this._beanProperties.find(propName);
            jp.nextToken();
            if (prop != null) {
                if (throwable != null) {
                    prop.deserializeAndSet(jp, ctxt, throwable);
                } else {
                    if (pending == null) {
                        int len = this._beanProperties.size();
                        pending = new Object[len + len];
                    }
                    pending[pendingIx++] = prop;
                    pending[pendingIx++] = prop.deserialize(jp, ctxt);
                }
            } else if (PROP_NAME_MESSAGE.equals(propName) && hasStringCreator) {
                throwable = this._valueInstantiator.createFromString(jp.getText());
                if (pending != null) {
                    int len = pendingIx;
                    for (int i = 0; i < len; i += 2) {
                        prop = (SettableBeanProperty)pending[i];
                        prop.set(throwable, pending[i + 1]);
                    }
                    pending = null;
                }
            } else if (this._ignorableProps != null && this._ignorableProps.contains(propName)) {
                jp.skipChildren();
            } else if (this._anySetter != null) {
                this._anySetter.deserializeAndSet(jp, ctxt, throwable, propName);
            } else {
                this.handleUnknownProperty(jp, ctxt, throwable, propName);
            }
            jp.nextToken();
        }
        if (throwable == null) {
            throwable = hasStringCreator ? this._valueInstantiator.createFromString(null) : this._valueInstantiator.createUsingDefault();
            if (pending != null) {
                int len = pendingIx;
                for (int i = 0; i < len; i += 2) {
                    SettableBeanProperty prop = (SettableBeanProperty)pending[i];
                    prop.set(throwable, pending[i + 1]);
                }
            }
        }
        return throwable;
    }
}

