/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.command;

import com.alibaba.dts.shade.org.h2.command.Command;
import com.alibaba.dts.shade.org.h2.command.Parser;
import com.alibaba.dts.shade.org.h2.command.Prepared;
import com.alibaba.dts.shade.org.h2.command.dml.Delete;
import com.alibaba.dts.shade.org.h2.command.dml.Insert;
import com.alibaba.dts.shade.org.h2.command.dml.Update;
import com.alibaba.dts.shade.org.h2.engine.Session;
import com.alibaba.dts.shade.org.h2.expression.Parameter;
import com.alibaba.dts.shade.org.h2.expression.ParameterInterface;
import com.alibaba.dts.shade.org.h2.result.ResultInterface;
import com.alibaba.dts.shade.org.h2.util.ThreadBuffer;
import com.alibaba.dts.shade.org.h2.value.Value;
import com.alibaba.dts.shade.org.h2.value.ValueNull;
import java.util.ArrayList;

public class CommandContainer
extends Command {
    private Prepared prepared;
    private boolean readOnlyKnown;
    private boolean readOnly;

    public CommandContainer(Session session, String sql, Prepared prepared) {
        super(session, sql);
        prepared.setCommand(this);
        this.prepared = prepared;
    }

    @Override
    public ArrayList<? extends ParameterInterface> getParameters() {
        return this.prepared.getParameters();
    }

    @Override
    public boolean isTransactional() {
        return this.prepared.isTransactional();
    }

    @Override
    public boolean isQuery() {
        return this.prepared.isQuery();
    }

    private void recompileIfRequired() {
        if (this.prepared.needRecompile()) {
            this.prepared.setModificationMetaId(0L);
            String sql = this.prepared.getSQL();
            ArrayList<Parameter> oldParams = this.prepared.getParameters();
            Parser parser = new Parser(this.session);
            this.prepared = parser.parse(sql);
            long mod = this.prepared.getModificationMetaId();
            this.prepared.setModificationMetaId(0L);
            ArrayList<Parameter> newParams = this.prepared.getParameters();
            int size = newParams.size();
            for (int i = 0; i < size; ++i) {
                Parameter old = oldParams.get(i);
                if (!old.isValueSet()) continue;
                Value v = old.getValue(this.session);
                Parameter p = newParams.get(i);
                p.setValue(v);
            }
            this.prepared.prepare();
            this.prepared.setModificationMetaId(mod);
        }
    }

    @Override
    public int update() {
        if (!(this.prepared instanceof Insert || this.prepared instanceof Update || this.prepared instanceof Delete)) {
            ThreadBuffer.remove("affectRows");
        }
        this.recompileIfRequired();
        this.setProgress(5);
        this.start();
        this.session.setLastScopeIdentity(ValueNull.INSTANCE);
        this.prepared.checkParameters();
        int updateCount = this.prepared.update();
        this.prepared.trace(this.startTime, updateCount);
        this.setProgress(6);
        return updateCount;
    }

    @Override
    public ResultInterface query(int maxrows) {
        this.recompileIfRequired();
        this.setProgress(5);
        this.start();
        this.prepared.checkParameters();
        ResultInterface result = this.prepared.query(maxrows);
        this.prepared.trace(this.startTime, result.getRowCount());
        this.setProgress(6);
        return result;
    }

    @Override
    public boolean isReadOnly() {
        if (!this.readOnlyKnown) {
            this.readOnly = this.prepared.isReadOnly();
            this.readOnlyKnown = true;
        }
        return this.readOnly;
    }

    @Override
    public ResultInterface queryMeta() {
        return this.prepared.queryMeta();
    }

    @Override
    public boolean isCacheable() {
        return this.prepared.isCacheable();
    }

    @Override
    public int getCommandType() {
        return this.prepared.getType();
    }
}

