/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.command.ddl;

import com.alibaba.dts.shade.org.h2.command.ddl.DefineCommand;
import com.alibaba.dts.shade.org.h2.engine.Database;
import com.alibaba.dts.shade.org.h2.engine.Session;
import com.alibaba.dts.shade.org.h2.index.Index;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.schema.Schema;

public class AlterIndexRename
extends DefineCommand {
    private Index oldIndex;
    private String newIndexName;
    private String tableName;

    public AlterIndexRename(Session session) {
        super(session);
    }

    public void setOldIndex(Index index) {
        this.oldIndex = index;
    }

    public void setNewName(String name) {
        this.newIndexName = name;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public int update() {
        this.session.commit(true);
        Database db = this.session.getDatabase();
        Schema schema = this.oldIndex.getSchema();
        if (schema.findIndex(this.session, this.tableName, this.newIndexName) != null || this.newIndexName.equals(this.oldIndex.getName())) {
            throw DbException.get(42111, this.newIndexName);
        }
        this.session.getUser().checkRight(this.oldIndex.getTable(), 15);
        db.renameSchemaObject(this.session, this.oldIndex, this.newIndexName);
        return 0;
    }

    @Override
    public int getType() {
        return 1;
    }
}

