/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.command.dml;

import com.alibaba.dts.shade.org.h2.command.Prepared;
import com.alibaba.dts.shade.org.h2.engine.Database;
import com.alibaba.dts.shade.org.h2.engine.Session;
import com.alibaba.dts.shade.org.h2.expression.Expression;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.mvstore.MVStore;
import com.alibaba.dts.shade.org.h2.mvstore.db.MVTableEngine;
import com.alibaba.dts.shade.org.h2.result.ResultInterface;
import com.alibaba.dts.shade.org.h2.store.FileLister;
import com.alibaba.dts.shade.org.h2.store.PageStore;
import com.alibaba.dts.shade.org.h2.store.fs.FileUtils;
import com.alibaba.dts.shade.org.h2.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class BackupCommand
extends Prepared {
    private Expression fileNameExpr;

    public BackupCommand(Session session) {
        super(session);
    }

    public void setFileName(Expression fileName) {
        this.fileNameExpr = fileName;
    }

    @Override
    public int update() {
        String name = this.fileNameExpr.getValue(this.session).getString();
        this.session.getUser().checkAdmin();
        this.backupTo(name);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupTo(String fileName) {
        Database db = this.session.getDatabase();
        if (!db.isPersistent()) {
            throw DbException.get(90126);
        }
        try {
            MVTableEngine.Store mvStore = db.getMvStore();
            if (mvStore != null) {
                mvStore.flush();
            }
            String name = db.getName();
            name = FileUtils.getName(name);
            OutputStream zip = FileUtils.newOutputStream(fileName, false);
            ZipOutputStream out = new ZipOutputStream(zip);
            db.flush();
            if (db.getPageStore() != null) {
                String fn = db.getName() + ".h2.db";
                this.backupPageStore(out, fn, db.getPageStore());
            }
            String base = FileUtils.getParent(db.getName());
            Object object = db.getLobSyncObject();
            synchronized (object) {
                String prefix = db.getDatabasePath();
                String dir = FileUtils.getParent(prefix);
                dir = FileLister.getDir(dir);
                ArrayList<String> fileList = FileLister.getDatabaseFiles(dir, name, true);
                for (String n : fileList) {
                    if (n.endsWith(".lob.db")) {
                        BackupCommand.backupFile(out, base, n);
                    }
                    if (!n.endsWith(".mv.db") || mvStore == null) continue;
                    MVStore s = mvStore.getStore();
                    boolean before = s.getReuseSpace();
                    s.setReuseSpace(false);
                    try {
                        InputStream in = mvStore.getInputStream();
                        BackupCommand.backupFile(out, base, n, in);
                    }
                    finally {
                        s.setReuseSpace(before);
                    }
                }
            }
            out.close();
            zip.close();
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupPageStore(ZipOutputStream out, String fileName, PageStore store) throws IOException {
        Database db = this.session.getDatabase();
        fileName = FileUtils.getName(fileName);
        out.putNextEntry(new ZipEntry(fileName));
        int pos = 0;
        try {
            store.setBackup(true);
            while ((pos = store.copyDirect(pos, out)) >= 0) {
                int max = store.getPageCount();
                db.setProgress(3, fileName, pos, max);
            }
        }
        finally {
            store.setBackup(false);
        }
        out.closeEntry();
    }

    private static void backupFile(ZipOutputStream out, String base, String fn) throws IOException {
        InputStream in = FileUtils.newInputStream(fn);
        BackupCommand.backupFile(out, base, fn, in);
    }

    private static void backupFile(ZipOutputStream out, String base, String fn, InputStream in) throws IOException {
        String f = FileUtils.toRealPath(fn);
        if (!f.startsWith(base = FileUtils.toRealPath(base))) {
            DbException.throwInternalError(f + " does not start with " + base);
        }
        f = f.substring(base.length());
        f = BackupCommand.correctFileName(f);
        out.putNextEntry(new ZipEntry(f));
        IOUtils.copyAndCloseInput(in, out);
        out.closeEntry();
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    public static String correctFileName(String f) {
        if ((f = f.replace('\\', '/')).startsWith("/")) {
            f = f.substring(1);
        }
        return f;
    }

    @Override
    public boolean needRecompile() {
        return false;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    @Override
    public int getType() {
        return 56;
    }
}

