/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.expression;

import com.alibaba.dts.shade.org.h2.command.dml.Query;
import com.alibaba.dts.shade.org.h2.engine.Session;
import com.alibaba.dts.shade.org.h2.expression.Condition;
import com.alibaba.dts.shade.org.h2.expression.Expression;
import com.alibaba.dts.shade.org.h2.expression.ExpressionVisitor;
import com.alibaba.dts.shade.org.h2.result.LocalResult;
import com.alibaba.dts.shade.org.h2.table.ColumnResolver;
import com.alibaba.dts.shade.org.h2.table.TableFilter;
import com.alibaba.dts.shade.org.h2.util.StringUtils;
import com.alibaba.dts.shade.org.h2.value.Value;
import com.alibaba.dts.shade.org.h2.value.ValueBoolean;

public class ConditionExists
extends Condition {
    private final Query query;

    public ConditionExists(Query query) {
        this.query = query;
    }

    @Override
    public Value getValue(Session session) {
        this.query.setSession(session);
        LocalResult result = this.query.query(1);
        session.addTemporaryResult(result);
        boolean r = result.getRowCount() > 0;
        return ValueBoolean.get(r);
    }

    @Override
    public Expression optimize(Session session) {
        this.query.prepare();
        return this;
    }

    @Override
    public String getSQL() {
        return "EXISTS(\n" + StringUtils.indent(this.query.getPlanSQL(), 4, false) + ")";
    }

    @Override
    public void updateAggregate(Session session) {
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level) {
        this.query.mapColumns(resolver, level + 1);
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.query.setEvaluatable(tableFilter, b);
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        return this.query.isEverything(visitor);
    }

    @Override
    public int getCost() {
        return this.query.getCostAsExpression();
    }
}

