/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.index;

import com.alibaba.dts.shade.org.h2.engine.Session;
import com.alibaba.dts.shade.org.h2.index.BaseIndex;
import com.alibaba.dts.shade.org.h2.index.Cursor;
import com.alibaba.dts.shade.org.h2.index.IndexType;
import com.alibaba.dts.shade.org.h2.index.ScanCursor;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.result.Row;
import com.alibaba.dts.shade.org.h2.result.SearchRow;
import com.alibaba.dts.shade.org.h2.result.SortOrder;
import com.alibaba.dts.shade.org.h2.table.Column;
import com.alibaba.dts.shade.org.h2.table.IndexColumn;
import com.alibaba.dts.shade.org.h2.table.RegularTable;
import com.alibaba.dts.shade.org.h2.table.TableFilter;
import com.alibaba.dts.shade.org.h2.util.New;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ScanIndex
extends BaseIndex {
    private long firstFree = -1L;
    private ArrayList<Row> rows = New.arrayList();
    private final RegularTable tableData;
    private int rowCountDiff;
    private final HashMap<Integer, Integer> sessionRowCount;
    private HashSet<Row> delta;
    private long rowCount;

    public ScanIndex(RegularTable table, int id, IndexColumn[] columns, IndexType indexType) {
        this.initBaseIndex(table, id, table.getName() + "_DATA", columns, indexType);
        this.sessionRowCount = this.database.isMultiVersion() ? New.hashMap() : null;
        this.tableData = table;
    }

    @Override
    public void remove(Session session) {
        this.truncate(session);
    }

    @Override
    public void truncate(Session session) {
        this.rows = New.arrayList();
        this.firstFree = -1L;
        if (this.tableData.getContainsLargeObject() && this.tableData.isPersistData()) {
            this.database.getLobStorage().removeAllForTable(this.table.getId());
        }
        this.tableData.setRowCount(0L);
        this.rowCount = 0L;
        this.rowCountDiff = 0;
        if (this.database.isMultiVersion()) {
            this.sessionRowCount.clear();
        }
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public Row getRow(Session session, long key) {
        return this.rows.get((int)key);
    }

    @Override
    public void add(Session session, Row row) {
        if (this.firstFree == -1L) {
            int key = this.rows.size();
            row.setKey(key);
            this.rows.add(row);
        } else {
            long key = this.firstFree;
            Row free = this.rows.get((int)key);
            this.firstFree = free.getKey();
            row.setKey(key);
            this.rows.set((int)key, row);
        }
        row.setDeleted(false);
        if (this.database.isMultiVersion()) {
            boolean wasDeleted;
            if (this.delta == null) {
                this.delta = New.hashSet();
            }
            if (!(wasDeleted = this.delta.remove(row))) {
                this.delta.add(row);
            }
            this.incrementRowCount(session.getId(), 1);
        }
        ++this.rowCount;
    }

    @Override
    public void commit(int operation, Row row) {
        if (this.database.isMultiVersion()) {
            if (this.delta != null) {
                this.delta.remove(row);
            }
            this.incrementRowCount(row.getSessionId(), operation == 1 ? 1 : -1);
        }
    }

    private void incrementRowCount(int sessionId, int count) {
        if (this.database.isMultiVersion()) {
            Integer id = sessionId;
            Integer c = this.sessionRowCount.get(id);
            int current = c == null ? 0 : c;
            this.sessionRowCount.put(id, current + count);
            this.rowCountDiff += count;
        }
    }

    @Override
    public void remove(Session session, Row row) {
        if (!this.database.isMultiVersion() && this.rowCount == 1L) {
            this.rows = New.arrayList();
            this.firstFree = -1L;
        } else {
            Row free = new Row(null, 1);
            free.setKey(this.firstFree);
            long key = row.getKey();
            if ((long)this.rows.size() <= key) {
                throw DbException.get(90112, this.rows.size() + ": " + key);
            }
            this.rows.set((int)key, free);
            this.firstFree = key;
        }
        if (this.database.isMultiVersion()) {
            boolean wasAdded;
            row.setDeleted(true);
            if (this.delta == null) {
                this.delta = New.hashSet();
            }
            if (!(wasAdded = this.delta.remove(row))) {
                this.delta.add(row);
            }
            this.incrementRowCount(session.getId(), -1);
        }
        --this.rowCount;
    }

    @Override
    public Cursor find(Session session, SearchRow first, SearchRow last) {
        return new ScanCursor(session, this, this.database.isMultiVersion());
    }

    @Override
    public double getCost(Session session, int[] masks, TableFilter filter, SortOrder sortOrder) {
        return this.tableData.getRowCountApproximation() + 1000L;
    }

    @Override
    public long getRowCount(Session session) {
        if (this.database.isMultiVersion()) {
            Integer i = this.sessionRowCount.get(session.getId());
            long count = i == null ? 0L : (long)i.intValue();
            count += this.rowCount;
            return count -= (long)this.rowCountDiff;
        }
        return this.rowCount;
    }

    Row getNextRow(Row row) {
        long key = row == null ? -1L : row.getKey();
        do {
            if (++key < (long)this.rows.size()) continue;
            return null;
        } while ((row = this.rows.get((int)key)).isEmpty());
        return row;
    }

    @Override
    public int getColumnIndex(Column col) {
        return -1;
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("SCAN");
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return false;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean first) {
        throw DbException.getUnsupportedException("SCAN");
    }

    Iterator<Row> getDelta() {
        if (this.delta == null) {
            List e = Collections.emptyList();
            return e.iterator();
        }
        return this.delta.iterator();
    }

    @Override
    public long getRowCountApproximation() {
        return this.rowCount;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public String getPlanSQL() {
        return this.table.getSQL() + ".tableScan";
    }
}

