/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.index;

import com.alibaba.dts.shade.org.h2.engine.Session;
import com.alibaba.dts.shade.org.h2.index.BaseIndex;
import com.alibaba.dts.shade.org.h2.index.Cursor;
import com.alibaba.dts.shade.org.h2.index.IndexType;
import com.alibaba.dts.shade.org.h2.index.SpatialIndex;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.mvstore.MVStore;
import com.alibaba.dts.shade.org.h2.mvstore.db.MVTableEngine;
import com.alibaba.dts.shade.org.h2.mvstore.rtree.MVRTreeMap;
import com.alibaba.dts.shade.org.h2.mvstore.rtree.SpatialKey;
import com.alibaba.dts.shade.org.h2.result.Row;
import com.alibaba.dts.shade.org.h2.result.SearchRow;
import com.alibaba.dts.shade.org.h2.result.SortOrder;
import com.alibaba.dts.shade.org.h2.table.Column;
import com.alibaba.dts.shade.org.h2.table.IndexColumn;
import com.alibaba.dts.shade.org.h2.table.Table;
import com.alibaba.dts.shade.org.h2.table.TableFilter;
import com.alibaba.dts.shade.org.h2.value.Value;
import com.alibaba.dts.shade.org.h2.value.ValueGeometry;
import com.alibaba.dts.shade.org.h2.value.ValueNull;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.Iterator;

public class SpatialTreeIndex
extends BaseIndex
implements SpatialIndex {
    private static final String MAP_PREFIX = "RTREE_";
    private final MVRTreeMap<Long> treeMap;
    private final MVStore store;
    private boolean closed;
    private boolean needRebuild;

    public SpatialTreeIndex(Table table, int id, String indexName, IndexColumn[] columns, IndexType indexType, boolean persistent, boolean create, Session session) {
        if (indexType.isUnique()) {
            throw DbException.getUnsupportedException("not unique");
        }
        if (!persistent && !create) {
            throw DbException.getUnsupportedException("Non persistent index called with create==false");
        }
        if (columns.length > 1) {
            throw DbException.getUnsupportedException("can only do one column");
        }
        if ((columns[0].sortType & 1) != 0) {
            throw DbException.getUnsupportedException("cannot do descending");
        }
        if ((columns[0].sortType & 2) != 0) {
            throw DbException.getUnsupportedException("cannot do nulls first");
        }
        if ((columns[0].sortType & 4) != 0) {
            throw DbException.getUnsupportedException("cannot do nulls last");
        }
        this.initBaseIndex(table, id, indexName, columns, indexType);
        this.needRebuild = create;
        this.table = table;
        if (!this.database.isStarting() && columns[0].column.getType() != 22) {
            throw DbException.getUnsupportedException("spatial index on non-geometry column, " + columns[0].column.getCreateSQL());
        }
        if (!persistent) {
            this.store = MVStore.open(null);
            this.treeMap = (MVRTreeMap)this.store.openMap("spatialIndex", new MVRTreeMap.Builder());
        } else {
            if (id < 0) {
                throw DbException.getUnsupportedException("Persistent index with id<0");
            }
            MVTableEngine.init(session.getDatabase());
            this.store = session.getDatabase().getMvStore().getStore();
            this.treeMap = (MVRTreeMap)this.store.openMap(MAP_PREFIX + this.getId(), new MVRTreeMap.Builder());
            if (this.treeMap.isEmpty()) {
                this.needRebuild = true;
            }
        }
    }

    @Override
    public void close(Session session) {
        this.store.close();
        this.closed = true;
    }

    @Override
    public void add(Session session, Row row) {
        if (this.closed) {
            throw DbException.throwInternalError();
        }
        this.treeMap.add(this.getKey(row), row.getKey());
    }

    private SpatialKey getKey(SearchRow row) {
        if (row == null) {
            return null;
        }
        Value v = row.getValue(this.columnIds[0]);
        if (v == ValueNull.INSTANCE) {
            return null;
        }
        Geometry g = ((ValueGeometry)v.convertTo(22)).getGeometryNoCopy();
        Envelope env = g.getEnvelopeInternal();
        return new SpatialKey(row.getKey(), (float)env.getMinX(), (float)env.getMaxX(), (float)env.getMinY(), (float)env.getMaxY());
    }

    @Override
    public void remove(Session session, Row row) {
        if (this.closed) {
            throw DbException.throwInternalError();
        }
        if (!this.treeMap.remove(this.getKey(row), row.getKey())) {
            throw DbException.throwInternalError("row not found");
        }
    }

    @Override
    public Cursor find(TableFilter filter, SearchRow first, SearchRow last) {
        return this.find(filter.getSession());
    }

    @Override
    public Cursor find(Session session, SearchRow first, SearchRow last) {
        return this.find(session);
    }

    private Cursor find(Session session) {
        return new SpatialCursor(this.treeMap.keySet().iterator(), this.table, session);
    }

    @Override
    public Cursor findByGeometry(TableFilter filter, SearchRow intersection) {
        if (intersection == null) {
            return this.find(filter.getSession());
        }
        return new SpatialCursor(this.treeMap.findIntersectingKeys(this.getKey(intersection)), this.table, filter.getSession());
    }

    @Override
    protected long getCostRangeIndex(int[] masks, long rowCount, TableFilter filter, SortOrder sortOrder) {
        return SpatialTreeIndex.getCostRangeIndex(masks, rowCount, this.columns);
    }

    public static long getCostRangeIndex(int[] masks, long rowCount, Column[] columns) {
        long cost = rowCount += 1000L;
        if (masks == null) {
            return cost;
        }
        for (Column column : columns) {
            int index = column.getColumnId();
            int mask = masks[index];
            if ((mask & 0x10) == 0) continue;
            cost = 3L + rowCount / 4L;
        }
        return 10L * cost;
    }

    @Override
    public double getCost(Session session, int[] masks, TableFilter filter, SortOrder sortOrder) {
        return this.getCostRangeIndex(masks, this.table.getRowCountApproximation(), filter, sortOrder);
    }

    @Override
    public void remove(Session session) {
        if (!this.treeMap.isClosed()) {
            this.store.removeMap(this.treeMap);
        }
    }

    @Override
    public void truncate(Session session) {
        this.treeMap.clear();
    }

    @Override
    public void checkRename() {
    }

    @Override
    public boolean needRebuild() {
        return this.needRebuild;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean first) {
        if (this.closed) {
            throw DbException.throwInternalError();
        }
        if (!first) {
            throw DbException.throwInternalError("Spatial Index can only be fetch by ascending order");
        }
        return this.find(session);
    }

    @Override
    public long getRowCount(Session session) {
        return this.treeMap.sizeAsLong();
    }

    @Override
    public long getRowCountApproximation() {
        return this.treeMap.sizeAsLong();
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    private static final class SpatialCursor
    implements Cursor {
        private final Iterator<SpatialKey> it;
        private SpatialKey current;
        private final Table table;
        private Session session;

        public SpatialCursor(Iterator<SpatialKey> it, Table table, Session session) {
            this.it = it;
            this.table = table;
            this.session = session;
        }

        @Override
        public Row get() {
            return this.table.getRow(this.session, this.current.getId());
        }

        @Override
        public SearchRow getSearchRow() {
            return this.get();
        }

        @Override
        public boolean next() {
            if (!this.it.hasNext()) {
                return false;
            }
            this.current = this.it.next();
            return true;
        }

        @Override
        public boolean previous() {
            return false;
        }
    }
}

