/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.index;

import com.alibaba.dts.shade.org.h2.index.Cursor;
import com.alibaba.dts.shade.org.h2.index.ViewIndex;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.result.LocalResult;
import com.alibaba.dts.shade.org.h2.result.Row;
import com.alibaba.dts.shade.org.h2.result.SearchRow;
import com.alibaba.dts.shade.org.h2.table.Table;
import com.alibaba.dts.shade.org.h2.value.Value;
import com.alibaba.dts.shade.org.h2.value.ValueNull;

public class ViewCursor
implements Cursor {
    private final Table table;
    private final ViewIndex index;
    private final LocalResult result;
    private final SearchRow first;
    private final SearchRow last;
    private Row current;

    ViewCursor(ViewIndex index, LocalResult result, SearchRow first, SearchRow last) {
        this.table = index.getTable();
        this.index = index;
        this.result = result;
        this.first = first;
        this.last = last;
    }

    @Override
    public Row get() {
        return this.current;
    }

    @Override
    public SearchRow getSearchRow() {
        return this.current;
    }

    @Override
    public boolean next() {
        int comp;
        do {
            boolean res;
            if (!(res = this.result.next())) {
                if (this.index.isRecursive()) {
                    this.result.reset();
                } else {
                    this.result.close();
                }
                this.current = null;
                return false;
            }
            this.current = this.table.getTemplateRow();
            Value[] values = this.result.currentRow();
            int len = this.current.getColumnCount();
            for (int i = 0; i < len; ++i) {
                ValueNull v = i < values.length ? values[i] : ValueNull.INSTANCE;
                this.current.setValue(i, v);
            }
        } while (this.first != null && (comp = this.index.compareRows(this.current, this.first)) < 0 || this.last != null && (comp = this.index.compareRows(this.current, this.last)) > 0);
        return true;
    }

    @Override
    public boolean previous() {
        throw DbException.throwInternalError();
    }
}

