/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.jdbc;

import com.alibaba.dts.shade.org.h2.jdbc.JdbcConnection;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.message.Trace;
import com.alibaba.dts.shade.org.h2.message.TraceObject;
import com.alibaba.dts.shade.org.h2.util.StringUtils;
import java.sql.SQLException;
import java.sql.Savepoint;

public class JdbcSavepoint
extends TraceObject
implements Savepoint {
    private static final String SYSTEM_SAVEPOINT_PREFIX = "SYSTEM_SAVEPOINT_";
    private final int savepointId;
    private final String name;
    private JdbcConnection conn;

    JdbcSavepoint(JdbcConnection conn, int savepointId, String name, Trace trace, int id) {
        this.setTrace(trace, 6, id);
        this.conn = conn;
        this.savepointId = savepointId;
        this.name = name;
    }

    void release() {
        this.conn = null;
    }

    static String getName(String name, int id) {
        if (name != null) {
            return StringUtils.quoteJavaString(name);
        }
        return SYSTEM_SAVEPOINT_PREFIX + id;
    }

    void rollback() {
        this.checkValid();
        this.conn.prepareCommand("ROLLBACK TO SAVEPOINT " + JdbcSavepoint.getName(this.name, this.savepointId), Integer.MAX_VALUE).executeUpdate();
    }

    private void checkValid() {
        if (this.conn == null) {
            throw DbException.get(90063, JdbcSavepoint.getName(this.name, this.savepointId));
        }
    }

    @Override
    public int getSavepointId() throws SQLException {
        try {
            this.debugCodeCall("getSavepointId");
            this.checkValid();
            if (this.name != null) {
                throw DbException.get(90065);
            }
            return this.savepointId;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public String getSavepointName() throws SQLException {
        try {
            this.debugCodeCall("getSavepointName");
            this.checkValid();
            if (this.name == null) {
                throw DbException.get(90064);
            }
            return this.name;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    public String toString() {
        return this.getTraceObjectName() + ": id=" + this.savepointId + " name=" + this.name;
    }
}

