/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.jdbcx;

import com.alibaba.dts.shade.org.h2.jdbcx.JdbcDataSourceFactory;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.message.TraceObject;
import com.alibaba.dts.shade.org.h2.util.StringUtils;
import java.util.StringTokenizer;
import javax.transaction.xa.Xid;

public class JdbcXid
extends TraceObject
implements Xid {
    private static final String PREFIX = "XID";
    private final int formatId;
    private final byte[] branchQualifier;
    private final byte[] globalTransactionId;

    JdbcXid(JdbcDataSourceFactory factory, int id, String tid) {
        this.setTrace(factory.getTrace(), 15, id);
        try {
            StringTokenizer tokenizer = new StringTokenizer(tid, "_");
            String prefix = tokenizer.nextToken();
            if (!PREFIX.equals(prefix)) {
                throw DbException.get(90101, tid);
            }
            this.formatId = Integer.parseInt(tokenizer.nextToken());
            this.branchQualifier = StringUtils.convertHexToBytes(tokenizer.nextToken());
            this.globalTransactionId = StringUtils.convertHexToBytes(tokenizer.nextToken());
        }
        catch (RuntimeException e) {
            throw DbException.get(90101, tid);
        }
    }

    public static String toString(Xid xid) {
        StringBuilder buff = new StringBuilder(PREFIX);
        buff.append('_').append(xid.getFormatId()).append('_').append(StringUtils.convertBytesToHex(xid.getBranchQualifier())).append('_').append(StringUtils.convertBytesToHex(xid.getGlobalTransactionId()));
        return buff.toString();
    }

    @Override
    public int getFormatId() {
        this.debugCodeCall("getFormatId");
        return this.formatId;
    }

    @Override
    public byte[] getBranchQualifier() {
        this.debugCodeCall("getBranchQualifier");
        return this.branchQualifier;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        this.debugCodeCall("getGlobalTransactionId");
        return this.globalTransactionId;
    }
}

