/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.mvstore;

import com.alibaba.dts.shade.org.h2.mvstore.DataUtils;
import java.util.Arrays;
import java.util.Iterator;

public class ConcurrentArrayList<K> {
    K[] array = new Object[0];

    public K[] toArray() {
        return this.array;
    }

    public K peekFirst() {
        K[] a = this.array;
        return a.length == 0 ? null : (K)a[0];
    }

    public K peekLast() {
        K[] a = this.array;
        int len = a.length;
        return len == 0 ? null : (K)a[len - 1];
    }

    public synchronized void add(K obj) {
        int len = this.array.length;
        this.array = Arrays.copyOf(this.array, len + 1);
        this.array[len] = obj;
    }

    public synchronized boolean removeFirst(K obj) {
        if (this.peekFirst() != obj) {
            return false;
        }
        int len = this.array.length;
        Object[] a = new Object[len - 1];
        System.arraycopy(this.array, 1, a, 0, len - 1);
        this.array = a;
        return true;
    }

    public synchronized boolean removeLast(K obj) {
        if (this.peekLast() != obj) {
            return false;
        }
        this.array = Arrays.copyOf(this.array, this.array.length - 1);
        return true;
    }

    public Iterator<K> iterator() {
        return new Iterator<K>(){
            K[] a;
            int index;
            {
                this.a = ConcurrentArrayList.this.array;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.a.length;
            }

            @Override
            public K next() {
                return this.a[this.index++];
            }

            @Override
            public void remove() {
                throw DataUtils.newUnsupportedOperationException("remove");
            }
        };
    }

    public Iterator<K> reverseIterator() {
        return new Iterator<K>(){
            K[] a;
            int index;
            {
                this.a = ConcurrentArrayList.this.array;
                this.index = this.a.length - 1;
            }

            @Override
            public boolean hasNext() {
                return this.index >= 0;
            }

            @Override
            public K next() {
                return this.a[this.index--];
            }

            @Override
            public void remove() {
                throw DataUtils.newUnsupportedOperationException("remove");
            }
        };
    }
}

