/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.mvstore;

import com.alibaba.dts.shade.org.h2.jdbc.H2IllegalArgumentException;
import com.alibaba.dts.shade.org.h2.mvstore.ConcurrentArrayList;
import com.alibaba.dts.shade.org.h2.mvstore.Cursor;
import com.alibaba.dts.shade.org.h2.mvstore.CursorPos;
import com.alibaba.dts.shade.org.h2.mvstore.DataUtils;
import com.alibaba.dts.shade.org.h2.mvstore.MVStore;
import com.alibaba.dts.shade.org.h2.mvstore.Page;
import com.alibaba.dts.shade.org.h2.mvstore.type.DataType;
import com.alibaba.dts.shade.org.h2.mvstore.type.ObjectDataType;
import com.alibaba.dts.shade.org.h2.util.New;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public class MVMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    protected MVStore store;
    protected volatile Page root;
    protected volatile long writeVersion;
    private int id;
    private long createVersion;
    private final DataType keyType;
    private final DataType valueType;
    private ConcurrentArrayList<Page> oldRoots = new ConcurrentArrayList();
    private boolean closed;
    private boolean readOnly;
    private boolean isVolatile;
    private boolean isOld;

    protected MVMap(DataType keyType, DataType valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.root = Page.createEmpty(this, -1L);
    }

    static String getMapRootKey(int mapId) {
        return "root." + Integer.toHexString(mapId);
    }

    static String getMapKey(int mapId) {
        return "map." + Integer.toHexString(mapId);
    }

    protected void init(MVStore store, HashMap<String, Object> config) {
        this.store = store;
        this.id = DataUtils.readHexInt(config, "id", 0);
        this.createVersion = DataUtils.readHexLong(config, "createVersion", 0L);
        this.writeVersion = store.getCurrentVersion();
    }

    @Override
    public synchronized V put(K key, V value) {
        DataUtils.checkArgument(value != null, "The value may not be null", new Object[0]);
        this.beforeWrite();
        long v = this.writeVersion;
        Page p = this.root.copy(v);
        p = this.splitRootIfNeeded(p, v);
        Object result = this.put(p, v, key, value);
        this.newRoot(p);
        return (V)result;
    }

    synchronized Page putBranch(Page root, K key, V value) {
        DataUtils.checkArgument(value != null, "The value may not be null", new Object[0]);
        long v = this.writeVersion;
        Page p = root.copy(v);
        p = this.splitRootIfNeeded(p, v);
        this.put(p, v, key, value);
        return p;
    }

    protected Page splitRootIfNeeded(Page p, long writeVersion) {
        if (p.getMemory() <= this.store.getPageSplitSize() || p.getKeyCount() <= 1) {
            return p;
        }
        int at = p.getKeyCount() / 2;
        long totalCount = p.getTotalCount();
        Object k = p.getKey(at);
        Page split = p.split(at);
        Object[] keys = new Object[]{k};
        Page.PageReference[] children = new Page.PageReference[]{new Page.PageReference(p, p.getPos(), p.getTotalCount()), new Page.PageReference(split, split.getPos(), split.getTotalCount())};
        p = Page.create(this, writeVersion, keys, null, children, totalCount, 0);
        return p;
    }

    protected Object put(Page p, long writeVersion, Object key, Object value) {
        int index = p.binarySearch(key);
        if (p.isLeaf()) {
            if (index < 0) {
                index = -index - 1;
                p.insertLeaf(index, key, value);
                return null;
            }
            return p.setValue(index, value);
        }
        index = index < 0 ? -index - 1 : ++index;
        Page c = p.getChildPage(index).copy(writeVersion);
        if (c.getMemory() > this.store.getPageSplitSize() && c.getKeyCount() > 1) {
            int at = c.getKeyCount() / 2;
            Object k = c.getKey(at);
            Page split = c.split(at);
            p.setChild(index, split);
            p.insertNode(index, k, c);
            return this.put(p, writeVersion, key, value);
        }
        Object result = this.put(c, writeVersion, key, value);
        p.setChild(index, c);
        return result;
    }

    public K firstKey() {
        return this.getFirstLast(true);
    }

    public K lastKey() {
        return this.getFirstLast(false);
    }

    public K getKey(long index) {
        if (index < 0L || index >= (long)this.size()) {
            return null;
        }
        Page p = this.root;
        long offset = 0L;
        while (true) {
            long c;
            int i;
            if (p.isLeaf()) {
                if (index >= offset + (long)p.getKeyCount()) {
                    return null;
                }
                return (K)p.getKey((int)(index - offset));
            }
            int size = this.getChildPageCount(p);
            for (i = 0; i < size && index >= (c = p.getCounts(i)) + offset; ++i) {
                offset += c;
            }
            if (i == size) {
                return null;
            }
            p = p.getChildPage(i);
        }
    }

    public List<K> keyList() {
        return new AbstractList<K>(){

            @Override
            public K get(int index) {
                return MVMap.this.getKey(index);
            }

            @Override
            public int size() {
                return MVMap.this.size();
            }

            @Override
            public int indexOf(Object key) {
                return (int)MVMap.this.getKeyIndex(key);
            }
        };
    }

    public long getKeyIndex(K key) {
        if (this.size() == 0) {
            return -1L;
        }
        Page p = this.root;
        long offset = 0L;
        while (true) {
            int x = p.binarySearch(key);
            if (p.isLeaf()) {
                if (x < 0) {
                    return -offset + (long)x;
                }
                return offset + (long)x;
            }
            x = x < 0 ? -x - 1 : ++x;
            for (int i = 0; i < x; ++i) {
                offset += p.getCounts(i);
            }
            p = p.getChildPage(x);
        }
    }

    protected K getFirstLast(boolean first) {
        if (this.size() == 0) {
            return null;
        }
        Page p = this.root;
        while (!p.isLeaf()) {
            p = p.getChildPage(first ? 0 : this.getChildPageCount(p) - 1);
        }
        return (K)p.getKey(first ? 0 : p.getKeyCount() - 1);
    }

    public K higherKey(K key) {
        return this.getMinMax(key, false, true);
    }

    public K ceilingKey(K key) {
        return this.getMinMax(key, false, false);
    }

    public K floorKey(K key) {
        return this.getMinMax(key, true, false);
    }

    public K lowerKey(K key) {
        return this.getMinMax(key, true, true);
    }

    protected K getMinMax(K key, boolean min, boolean excluding) {
        return this.getMinMax(this.root, key, min, excluding);
    }

    private K getMinMax(Page p, K key, boolean min, boolean excluding) {
        if (p.isLeaf()) {
            int x = p.binarySearch(key);
            if (x < 0) {
                x = -x - (min ? 2 : 1);
            } else if (excluding) {
                x += min ? -1 : 1;
            }
            if (x < 0 || x >= p.getKeyCount()) {
                return null;
            }
            return (K)p.getKey(x);
        }
        int x = p.binarySearch(key);
        x = x < 0 ? -x - 1 : ++x;
        while (x >= 0 && x < this.getChildPageCount(p)) {
            K k = this.getMinMax(p.getChildPage(x), key, min, excluding);
            if (k != null) {
                return k;
            }
            x += min ? -1 : 1;
        }
        return null;
    }

    @Override
    public V get(Object key) {
        return (V)this.binarySearch(this.root, key);
    }

    protected Object binarySearch(Page p, Object key) {
        int x = p.binarySearch(key);
        if (!p.isLeaf()) {
            x = x < 0 ? -x - 1 : ++x;
            p = p.getChildPage(x);
            return this.binarySearch(p, key);
        }
        if (x >= 0) {
            return p.getValue(x);
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    protected Page binarySearchPage(Page p, Object key) {
        int x = p.binarySearch(key);
        if (!p.isLeaf()) {
            x = x < 0 ? -x - 1 : ++x;
            p = p.getChildPage(x);
            return this.binarySearchPage(p, key);
        }
        if (x >= 0) {
            return p;
        }
        return null;
    }

    @Override
    public synchronized void clear() {
        this.beforeWrite();
        this.root.removeAllRecursive();
        this.newRoot(Page.createEmpty(this, this.writeVersion));
    }

    void close() {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        this.beforeWrite();
        Object result = this.get(key);
        if (result == null) {
            return null;
        }
        long v = this.writeVersion;
        MVMap mVMap = this;
        synchronized (mVMap) {
            Page p = this.root.copy(v);
            result = this.remove(p, v, key);
            if (!p.isLeaf() && p.getTotalCount() == 0L) {
                p.removePage();
                p = Page.createEmpty(this, p.getVersion());
            }
            this.newRoot(p);
        }
        return result;
    }

    @Override
    public synchronized V putIfAbsent(K key, V value) {
        V old = this.get(key);
        if (old == null) {
            this.put(key, value);
        }
        return old;
    }

    @Override
    public synchronized boolean remove(Object key, Object value) {
        V old = this.get(key);
        if (this.areValuesEqual(old, value)) {
            this.remove(key);
            return true;
        }
        return false;
    }

    public boolean areValuesEqual(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return this.valueType.compare(a, b) == 0;
    }

    @Override
    public synchronized boolean replace(K key, V oldValue, V newValue) {
        V old = this.get(key);
        if (this.areValuesEqual(old, oldValue)) {
            this.put(key, newValue);
            return true;
        }
        return false;
    }

    @Override
    public synchronized V replace(K key, V value) {
        V old = this.get(key);
        if (old != null) {
            this.put(key, value);
            return old;
        }
        return null;
    }

    protected Object remove(Page p, long writeVersion, Object key) {
        int index = p.binarySearch(key);
        Object result = null;
        if (p.isLeaf()) {
            if (index >= 0) {
                result = p.getValue(index);
                p.remove(index);
            }
            return result;
        }
        index = index < 0 ? -index - 1 : ++index;
        Page cOld = p.getChildPage(index);
        Page c = cOld.copy(writeVersion);
        result = this.remove(c, writeVersion, key);
        if (result == null || c.getTotalCount() != 0L) {
            p.setChild(index, c);
        } else if (p.getKeyCount() == 0) {
            p.setChild(index, c);
            c.removePage();
        } else {
            p.remove(index);
        }
        return result;
    }

    protected void newRoot(Page newRoot) {
        if (this.root != newRoot) {
            Page last;
            this.removeUnusedOldVersions();
            if (this.root.getVersion() != newRoot.getVersion() && ((last = this.oldRoots.peekLast()) == null || last.getVersion() != this.root.getVersion())) {
                this.oldRoots.add(this.root);
            }
            this.root = newRoot;
        }
    }

    public int compare(Object a, Object b) {
        return this.keyType.compare(a, b);
    }

    public DataType getKeyType() {
        return this.keyType;
    }

    public DataType getValueType() {
        return this.valueType;
    }

    Page readPage(long pos) {
        return this.store.readPage(this, pos);
    }

    void setRootPos(long rootPos, long version) {
        this.root = rootPos == 0L ? Page.createEmpty(this, -1L) : this.readPage(rootPos);
        this.root.setVersion(version);
    }

    public Iterator<K> keyIterator(K from) {
        return new Cursor(this, this.root, from);
    }

    boolean rewrite(Set<Integer> set) {
        MVMap<K, V> readMap;
        long previousVersion = this.store.getCurrentVersion() - 1L;
        if (previousVersion < this.createVersion) {
            return true;
        }
        try {
            readMap = this.openVersion(previousVersion);
        }
        catch (IllegalArgumentException e) {
            return true;
        }
        try {
            this.rewrite(readMap.root, set);
            return true;
        }
        catch (IllegalStateException e) {
            if (DataUtils.getErrorCode(e.getMessage()) == 9) {
                return false;
            }
            throw e;
        }
    }

    private int rewrite(Page p, Set<Integer> set) {
        long pos;
        int chunkId;
        if (p.isLeaf()) {
            Object key;
            V value;
            long pos2 = p.getPos();
            int chunkId2 = DataUtils.getPageChunkId(pos2);
            if (!set.contains(chunkId2)) {
                return 0;
            }
            if (p.getKeyCount() > 0 && (value = this.get(key = p.getKey(0))) != null) {
                this.replace(key, value, value);
            }
            return 1;
        }
        int writtenPageCount = 0;
        for (int i = 0; i < this.getChildPageCount(p); ++i) {
            int chunkId3;
            long childPos = p.getChildPagePos(i);
            if (childPos != 0L && DataUtils.getPageType(childPos) == 0 && !set.contains(chunkId3 = DataUtils.getPageChunkId(childPos))) continue;
            writtenPageCount += this.rewrite(p.getChildPage(i), set);
        }
        if (writtenPageCount == 0 && set.contains(chunkId = DataUtils.getPageChunkId(pos = p.getPos()))) {
            Page p2 = p;
            while (!p2.isLeaf()) {
                p2 = p2.getChildPage(0);
            }
            Object key = p2.getKey(0);
            V value = this.get(key);
            if (value != null) {
                this.replace(key, value, value);
            }
            ++writtenPageCount;
        }
        return writtenPageCount;
    }

    public Cursor<K, V> cursor(K from) {
        return new Cursor(this, this.root, from);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        final MVMap map = this;
        final Page root = this.root;
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                final Cursor cursor = new Cursor(map, root, null);
                return new Iterator<Map.Entry<K, V>>(){

                    @Override
                    public boolean hasNext() {
                        return cursor.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        Object k = cursor.next();
                        return new DataUtils.MapEntry(k, cursor.getValue());
                    }

                    @Override
                    public void remove() {
                        throw DataUtils.newUnsupportedOperationException("Removing is not supported");
                    }
                };
            }

            @Override
            public int size() {
                return MVMap.this.size();
            }

            @Override
            public boolean contains(Object o) {
                return MVMap.this.containsKey(o);
            }
        };
    }

    @Override
    public Set<K> keySet() {
        final MVMap map = this;
        final Page root = this.root;
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return new Cursor(map, root, null);
            }

            @Override
            public int size() {
                return MVMap.this.size();
            }

            @Override
            public boolean contains(Object o) {
                return MVMap.this.containsKey(o);
            }
        };
    }

    public Page getRoot() {
        return this.root;
    }

    public String getName() {
        return this.store.getMapName(this.id);
    }

    public MVStore getStore() {
        return this.store;
    }

    public int getId() {
        return this.id;
    }

    synchronized void rollbackTo(long version) {
        this.beforeWrite();
        if (version > this.createVersion && this.root.getVersion() >= version) {
            Page last;
            while ((last = this.oldRoots.peekLast()) != null) {
                this.oldRoots.removeLast(last);
                this.root = last;
                if (this.root.getVersion() >= version) continue;
                break;
            }
        }
    }

    void removeUnusedOldVersions() {
        long oldest = this.store.getOldestVersionToKeep();
        if (oldest == -1L) {
            return;
        }
        Page last = this.oldRoots.peekLast();
        while (true) {
            Page next;
            Page[] pages;
            Page first = (pages = this.oldRoots.toArray()).length == 0 ? null : pages[0];
            Page page = next = pages.length <= 1 ? null : pages[1];
            if (first == null || first.getVersion() >= oldest || first == last || next == null || next.getVersion() > oldest) break;
            this.oldRoots.removeFirst(first);
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setVolatile(boolean isVolatile) {
        this.isVolatile = isVolatile;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public void setOld(boolean isOld) {
        this.isOld = isOld;
    }

    public boolean isOld() {
        return this.isOld;
    }

    protected void beforeWrite() {
        if (this.closed) {
            throw DataUtils.newIllegalStateException(4, "This map is closed", new Object[0]);
        }
        if (this.readOnly) {
            throw DataUtils.newUnsupportedOperationException("This map is read-only");
        }
        this.store.beforeWrite(this);
    }

    @Override
    public int hashCode() {
        return this.id;
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int size() {
        long size = this.sizeAsLong();
        return size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)size;
    }

    public long sizeAsLong() {
        return this.root.getTotalCount();
    }

    @Override
    public boolean isEmpty() {
        return this.root.isLeaf() && this.root.getKeyCount() == 0;
    }

    public long getCreateVersion() {
        return this.createVersion;
    }

    protected void removePage(long pos, int memory) {
        this.store.removePage(this, pos, memory);
    }

    public MVMap<K, V> openVersion(long version) {
        if (this.readOnly) {
            throw DataUtils.newUnsupportedOperationException("This map is read-only; need to call the method on the writable map");
        }
        try {
            DataUtils.checkArgument(version >= this.createVersion, "Unknown version {0}; this map was created in version {1}", version, this.createVersion);
        }
        catch (IllegalArgumentException e) {
            throw new H2IllegalArgumentException(1, e.getMessage());
        }
        if (this.store.isKeepOldVersion()) {
            DataUtils.checkArgument(version + 1L >= this.store.getOldestVersion(), "Old version {0} might be already freed", version);
        }
        Page newest = null;
        Page r = this.root;
        if (version >= r.getVersion() && (version == this.writeVersion || r.getVersion() >= 0L || version <= this.createVersion || this.store.getFileStore() == null)) {
            newest = r;
        } else {
            Page last = this.oldRoots.peekFirst();
            if (last == null || version < last.getVersion()) {
                this.store.getTrace().debug("open version " + version + " not in memory." + " last root version " + (last == null ? "null" : Long.valueOf(last.getVersion())) + ". store oldest version " + this.store.getOldestVersion());
                return this.store.openMapVersion(version, this.id, this);
            }
            Iterator<Page> it = this.oldRoots.reverseIterator();
            while (it.hasNext()) {
                Page p = it.next();
                if (p == null || p.getVersion() > version) continue;
                last = p;
                break;
            }
            newest = last;
        }
        MVMap<K, V> m = this.openReadOnly();
        m.root = newest;
        return m;
    }

    MVMap<K, V> openReadOnly() {
        MVMap<K, V> m = new MVMap<K, V>(this.keyType, this.valueType);
        m.readOnly = true;
        HashMap<String, Object> config = New.hashMap();
        config.put("id", this.id);
        config.put("createVersion", this.createVersion);
        m.init(this.store, config);
        m.root = this.root;
        return m;
    }

    public long getVersion() {
        return this.root.getVersion();
    }

    protected int getChildPageCount(Page p) {
        return p.getRawChildPageCount();
    }

    public String getType() {
        return null;
    }

    String asString(String name) {
        String type;
        StringBuilder buff = new StringBuilder();
        if (name != null) {
            DataUtils.appendMap(buff, "name", name);
        }
        if (this.createVersion != 0L) {
            DataUtils.appendMap(buff, "createVersion", this.createVersion);
        }
        if ((type = this.getType()) != null) {
            DataUtils.appendMap(buff, "type", type);
        }
        return buff.toString();
    }

    void setWriteVersion(long writeVersion) {
        this.writeVersion = writeVersion;
    }

    void copyFrom(MVMap<K, V> sourceMap) {
        this.beforeWrite();
        this.newRoot(this.copy(sourceMap.root, null));
    }

    private Page copy(Page source, CursorPos parent) {
        Page target = Page.create(this, this.writeVersion, source);
        if (source.isLeaf()) {
            Page child = target;
            CursorPos p = parent;
            while (p != null) {
                p.page.setChild(p.index, child);
                child = p.page = p.page.copy(this.writeVersion);
                if (p.parent == null) {
                    this.newRoot(p.page);
                    this.beforeWrite();
                }
                p = p.parent;
            }
        } else {
            for (int i = 0; i < this.getChildPageCount(target); ++i) {
                target.setChild(i, null);
            }
            CursorPos pos = new CursorPos(target, 0, parent);
            for (int i = 0; i < this.getChildPageCount(target); ++i) {
                pos.index = i;
                long p = source.getChildPagePos(i);
                if (p == 0L) continue;
                this.copy(source.getChildPage(i), pos);
            }
            target = pos.page;
        }
        return target;
    }

    @Override
    public String toString() {
        return this.asString(null);
    }

    public long getMemory() {
        return this.root.getTotalMemory();
    }

    public static class Builder<K, V>
    implements MapBuilder<MVMap<K, V>, K, V> {
        protected DataType keyType;
        protected DataType valueType;

        public Builder<K, V> keyType(DataType keyType) {
            this.keyType = keyType;
            return this;
        }

        public DataType getKeyType() {
            return this.keyType;
        }

        public DataType getValueType() {
            return this.valueType;
        }

        public Builder<K, V> valueType(DataType valueType) {
            this.valueType = valueType;
            return this;
        }

        @Override
        public MVMap<K, V> create() {
            if (this.keyType == null) {
                this.keyType = new ObjectDataType();
            }
            if (this.valueType == null) {
                this.valueType = new ObjectDataType();
            }
            return new MVMap(this.keyType, this.valueType);
        }
    }

    public static interface MapBuilder<M extends MVMap<K, V>, K, V> {
        public M create();
    }
}

