/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.mvstore.cache;

import com.alibaba.dts.shade.org.h2.mvstore.DataUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CacheLongKeyLIRS<V> {
    private long maxMemory;
    private final Segment<V>[] segments;
    private final int segmentCount;
    private final int segmentShift;
    private final int segmentMask;
    private final int stackMoveDistance;
    private final int nonResidentQueueSize;

    public CacheLongKeyLIRS(Config config) {
        this.setMaxMemory(config.maxMemory);
        this.nonResidentQueueSize = config.nonResidentQueueSize;
        DataUtils.checkArgument(Integer.bitCount(config.segmentCount) == 1, "The segment count must be a power of 2, is {0}", config.segmentCount);
        this.segmentCount = config.segmentCount;
        this.segmentMask = this.segmentCount - 1;
        this.stackMoveDistance = config.stackMoveDistance;
        this.segments = new Segment[this.segmentCount];
        this.clear();
        this.segmentShift = 32 - Integer.bitCount(this.segmentMask);
    }

    public void clear() {
        long max = Math.max(1L, this.maxMemory / (long)this.segmentCount);
        for (int i = 0; i < this.segmentCount; ++i) {
            this.segments[i] = new Segment(max, this.stackMoveDistance, 8, this.nonResidentQueueSize);
        }
    }

    private Entry<V> find(long key) {
        int hash = CacheLongKeyLIRS.getHash(key);
        return this.getSegment(hash).find(key, hash);
    }

    public boolean containsKey(long key) {
        int hash = CacheLongKeyLIRS.getHash(key);
        return this.getSegment(hash).containsKey(key, hash);
    }

    public V peek(long key) {
        Entry<V> e = this.find(key);
        return e == null ? null : (V)e.value;
    }

    public V put(long key, V value) {
        return this.put(key, value, this.sizeOf(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(long key, V value, int memory) {
        Segment<V> s;
        int hash = CacheLongKeyLIRS.getHash(key);
        int segmentIndex = this.getSegmentIndex(hash);
        Segment<V> segment = s = this.segments[segmentIndex];
        synchronized (segment) {
            s = this.resizeIfNeeded(s, segmentIndex);
            return s.put(key, hash, value, memory);
        }
    }

    private Segment<V> resizeIfNeeded(Segment<V> s, int segmentIndex) {
        int newLen = s.getNewMapLen();
        if (newLen == 0) {
            return s;
        }
        Segment<V> s2 = this.segments[segmentIndex];
        if (s == s2) {
            s = new Segment<V>(s, newLen);
            this.segments[segmentIndex] = s;
        }
        return s;
    }

    protected int sizeOf(V value) {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(long key) {
        Segment<V> s;
        int hash = CacheLongKeyLIRS.getHash(key);
        int segmentIndex = this.getSegmentIndex(hash);
        Segment<V> segment = s = this.segments[segmentIndex];
        synchronized (segment) {
            s = this.resizeIfNeeded(s, segmentIndex);
            return s.remove(key, hash);
        }
    }

    public int getMemory(long key) {
        int hash = CacheLongKeyLIRS.getHash(key);
        return this.getSegment(hash).getMemory(key, hash);
    }

    public V get(long key) {
        int hash = CacheLongKeyLIRS.getHash(key);
        return this.getSegment(hash).get(key, hash);
    }

    private Segment<V> getSegment(int hash) {
        return this.segments[this.getSegmentIndex(hash)];
    }

    private int getSegmentIndex(int hash) {
        return hash >>> this.segmentShift & this.segmentMask;
    }

    static int getHash(long key) {
        int hash = (int)(key >>> 32 ^ key);
        hash = (hash >>> 16 ^ hash) * 73244475;
        hash = (hash >>> 16 ^ hash) * 73244475;
        hash = hash >>> 16 ^ hash;
        return hash;
    }

    public long getUsedMemory() {
        long x = 0L;
        for (Segment<V> s : this.segments) {
            x += s.usedMemory;
        }
        return x;
    }

    public void setMaxMemory(long maxMemory) {
        DataUtils.checkArgument(maxMemory > 0L, "Max memory must be larger than 0, is {0}", maxMemory);
        this.maxMemory = maxMemory;
        if (this.segments != null) {
            long max = 1L + maxMemory / (long)this.segments.length;
            for (Segment<V> s : this.segments) {
                s.setMaxMemory(max);
            }
        }
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public synchronized Set<Map.Entry<Long, V>> entrySet() {
        HashMap map = new HashMap();
        for (long k : this.keySet()) {
            map.put(k, this.find((long)k).value);
        }
        return map.entrySet();
    }

    public Set<Long> keySet() {
        HashSet<Long> set = new HashSet<Long>();
        for (Segment<V> s : this.segments) {
            set.addAll(s.keySet());
        }
        return set;
    }

    public int sizeNonResident() {
        int x = 0;
        for (Segment<V> s : this.segments) {
            x += s.queue2Size;
        }
        return x;
    }

    public int sizeMapArray() {
        int x = 0;
        for (Segment<V> s : this.segments) {
            x += s.entries.length;
        }
        return x;
    }

    public int sizeHot() {
        int x = 0;
        for (Segment<V> s : this.segments) {
            x += s.mapSize - s.queueSize - s.queue2Size;
        }
        return x;
    }

    public long getHits() {
        long x = 0L;
        for (Segment<V> s : this.segments) {
            x += s.hits;
        }
        return x;
    }

    public long getMisses() {
        int x = 0;
        for (Segment<V> s : this.segments) {
            x = (int)((long)x + s.misses);
        }
        return x;
    }

    public int size() {
        int x = 0;
        for (Segment<V> s : this.segments) {
            x += s.mapSize - s.queue2Size;
        }
        return x;
    }

    public List<Long> keys(boolean cold, boolean nonResident) {
        ArrayList<Long> keys = new ArrayList<Long>();
        for (Segment<V> s : this.segments) {
            keys.addAll(s.keys(cold, nonResident));
        }
        return keys;
    }

    public List<V> values() {
        ArrayList list = new ArrayList();
        for (long k : this.keySet()) {
            Object value = this.find((long)k).value;
            if (value == null) continue;
            list.add(value);
        }
        return list;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsValue(Object value) {
        return this.getMap().containsValue(value);
    }

    public Map<Long, V> getMap() {
        HashMap map = new HashMap();
        for (long k : this.keySet()) {
            Object x = this.find((long)k).value;
            if (x == null) continue;
            map.put(k, x);
        }
        return map;
    }

    public void putAll(Map<Long, ? extends V> m) {
        for (Map.Entry<Long, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    public static class Config {
        public long maxMemory = 1L;
        public int segmentCount = 16;
        public int stackMoveDistance = 32;
        public int nonResidentQueueSize = 3;
    }

    static class Entry<V> {
        long key;
        V value;
        int memory;
        int topMove;
        Entry<V> stackNext;
        Entry<V> stackPrev;
        Entry<V> queueNext;
        Entry<V> queuePrev;
        Entry<V> mapNext;

        Entry() {
        }

        boolean isHot() {
            return this.queueNext == null;
        }
    }

    private static class Segment<V> {
        int mapSize;
        int queueSize;
        int queue2Size;
        long hits;
        long misses;
        final Entry<V>[] entries;
        long usedMemory;
        private final int stackMoveDistance;
        private long maxMemory;
        private final int mask;
        private final int nonResidentQueueSize;
        private final Entry<V> stack;
        private int stackSize;
        private final Entry<V> queue;
        private final Entry<V> queue2;
        private int stackMoveCounter;

        Segment(long maxMemory, int stackMoveDistance, int len, int nonResidentQueueSize) {
            this.setMaxMemory(maxMemory);
            this.stackMoveDistance = stackMoveDistance;
            this.nonResidentQueueSize = nonResidentQueueSize;
            this.mask = len - 1;
            this.stack = new Entry();
            this.stack.stackNext = this.stack;
            this.stack.stackPrev = this.stack.stackNext;
            this.queue = new Entry();
            this.queue.queueNext = this.queue;
            this.queue.queuePrev = this.queue.queueNext;
            this.queue2 = new Entry();
            this.queue2.queueNext = this.queue2;
            this.queue2.queuePrev = this.queue2.queueNext;
            Entry[] e = new Entry[len];
            this.entries = e;
        }

        Segment(Segment<V> old, int len) {
            this(old.maxMemory, old.stackMoveDistance, len, old.nonResidentQueueSize);
            Entry e;
            this.hits = old.hits;
            this.misses = old.misses;
            Entry s = old.stack.stackPrev;
            while (s != old.stack) {
                e = Segment.copy(s);
                super.addToMap(e);
                super.addToStack(e);
                s = s.stackPrev;
            }
            s = old.queue.queuePrev;
            while (s != old.queue) {
                e = this.find(s.key, CacheLongKeyLIRS.getHash(s.key));
                if (e == null) {
                    e = Segment.copy(s);
                    super.addToMap(e);
                }
                super.addToQueue(this.queue, e);
                s = s.queuePrev;
            }
            s = old.queue2.queuePrev;
            while (s != old.queue2) {
                e = this.find(s.key, CacheLongKeyLIRS.getHash(s.key));
                if (e == null) {
                    e = Segment.copy(s);
                    super.addToMap(e);
                }
                super.addToQueue(this.queue2, e);
                s = s.queuePrev;
            }
        }

        int getNewMapLen() {
            int len = this.mask + 1;
            if (len * 3 < this.mapSize * 4 && len < 0x10000000) {
                return len * 2;
            }
            if (len > 32 && len / 8 > this.mapSize) {
                return len / 2;
            }
            return 0;
        }

        private void addToMap(Entry<V> e) {
            int index = CacheLongKeyLIRS.getHash(e.key) & this.mask;
            e.mapNext = this.entries[index];
            this.entries[index] = e;
            this.usedMemory += (long)e.memory;
            ++this.mapSize;
        }

        private static <V> Entry<V> copy(Entry<V> old) {
            Entry e = new Entry();
            e.key = old.key;
            e.value = old.value;
            e.memory = old.memory;
            e.topMove = old.topMove;
            return e;
        }

        int getMemory(long key, int hash) {
            Entry<V> e = this.find(key, hash);
            return e == null ? 0 : e.memory;
        }

        V get(long key, int hash) {
            Entry<V> e = this.find(key, hash);
            if (e == null) {
                ++this.misses;
                return null;
            }
            Object value = e.value;
            if (value == null) {
                ++this.misses;
                return null;
            }
            if (e.isHot()) {
                if (e != this.stack.stackNext && (this.stackMoveDistance == 0 || this.stackMoveCounter - e.topMove > this.stackMoveDistance)) {
                    this.access(key, hash);
                }
            } else {
                this.access(key, hash);
            }
            ++this.hits;
            return value;
        }

        private synchronized void access(long key, int hash) {
            Entry<V> e = this.find(key, hash);
            if (e == null || e.value == null) {
                return;
            }
            if (e.isHot()) {
                if (e != this.stack.stackNext && (this.stackMoveDistance == 0 || this.stackMoveCounter - e.topMove > this.stackMoveDistance)) {
                    boolean wasEnd = e == this.stack.stackPrev;
                    this.removeFromStack(e);
                    if (wasEnd) {
                        this.pruneStack();
                    }
                    this.addToStack(e);
                }
            } else {
                this.removeFromQueue(e);
                if (e.stackNext != null) {
                    this.removeFromStack(e);
                    this.convertOldestHotToCold();
                } else {
                    this.addToQueue(this.queue, e);
                }
                this.addToStack(e);
            }
        }

        synchronized V put(long key, int hash, V value, int memory) {
            V old;
            if (value == null) {
                throw DataUtils.newIllegalArgumentException("The value may not be null", new Object[0]);
            }
            Entry<V> e = this.find(key, hash);
            if (e == null) {
                old = null;
            } else {
                old = e.value;
                this.remove(key, hash);
            }
            if ((long)memory > this.maxMemory) {
                return old;
            }
            e = new Entry();
            e.key = key;
            e.value = value;
            e.memory = memory;
            int index = hash & this.mask;
            e.mapNext = this.entries[index];
            this.entries[index] = e;
            this.usedMemory += (long)memory;
            if (this.usedMemory > this.maxMemory) {
                this.evict();
                if (this.stackSize > 0) {
                    this.addToQueue(this.queue, e);
                }
            }
            ++this.mapSize;
            this.addToStack(e);
            return old;
        }

        synchronized V remove(long key, int hash) {
            Object old;
            int index = hash & this.mask;
            Entry<V> e = this.entries[index];
            if (e == null) {
                return null;
            }
            if (e.key == key) {
                old = e.value;
                this.entries[index] = e.mapNext;
            } else {
                do {
                    Entry<V> last = e;
                    e = e.mapNext;
                    if (e != null) continue;
                    return null;
                } while (e.key != key);
                old = e.value;
                last.mapNext = e.mapNext;
            }
            --this.mapSize;
            this.usedMemory -= (long)e.memory;
            if (e.stackNext != null) {
                this.removeFromStack(e);
            }
            if (e.isHot()) {
                e = this.queue.queueNext;
                if (e != this.queue) {
                    this.removeFromQueue(e);
                    if (e.stackNext == null) {
                        this.addToStackBottom(e);
                    }
                }
            } else {
                this.removeFromQueue(e);
            }
            this.pruneStack();
            return old;
        }

        private void evict() {
            do {
                this.evictBlock();
            } while (this.usedMemory > this.maxMemory);
        }

        private void evictBlock() {
            while (this.queueSize <= this.mapSize >>> 5 && this.stackSize > 0) {
                this.convertOldestHotToCold();
            }
            while (this.usedMemory > this.maxMemory && this.queueSize > 0) {
                Entry e = this.queue.queuePrev;
                this.usedMemory -= (long)e.memory;
                this.removeFromQueue(e);
                e.value = null;
                e.memory = 0;
                this.addToQueue(this.queue2, e);
                int maxQueue2Size = this.nonResidentQueueSize * (this.mapSize - this.queue2Size);
                if (maxQueue2Size < 0) continue;
                while (this.queue2Size > maxQueue2Size) {
                    e = this.queue2.queuePrev;
                    int hash = CacheLongKeyLIRS.getHash(e.key);
                    this.remove(e.key, hash);
                }
            }
        }

        private void convertOldestHotToCold() {
            Entry last = this.stack.stackPrev;
            if (last == this.stack) {
                throw new IllegalStateException();
            }
            this.removeFromStack(last);
            this.addToQueue(this.queue, last);
            this.pruneStack();
        }

        private void pruneStack() {
            Entry last;
            while (!(last = this.stack.stackPrev).isHot()) {
                this.removeFromStack(last);
            }
        }

        Entry<V> find(long key, int hash) {
            int index = hash & this.mask;
            Entry<V> e = this.entries[index];
            while (e != null && e.key != key) {
                e = e.mapNext;
            }
            return e;
        }

        private void addToStack(Entry<V> e) {
            e.stackPrev = this.stack;
            e.stackNext = this.stack.stackNext;
            e.stackNext.stackPrev = e;
            this.stack.stackNext = e;
            ++this.stackSize;
            e.topMove = this.stackMoveCounter++;
        }

        private void addToStackBottom(Entry<V> e) {
            e.stackNext = this.stack;
            e.stackPrev = this.stack.stackPrev;
            e.stackPrev.stackNext = e;
            this.stack.stackPrev = e;
            ++this.stackSize;
        }

        private void removeFromStack(Entry<V> e) {
            e.stackPrev.stackNext = e.stackNext;
            e.stackNext.stackPrev = e.stackPrev;
            e.stackNext = null;
            e.stackPrev = null;
            --this.stackSize;
        }

        private void addToQueue(Entry<V> q, Entry<V> e) {
            e.queuePrev = q;
            e.queueNext = q.queueNext;
            e.queueNext.queuePrev = e;
            q.queueNext = e;
            if (e.value != null) {
                ++this.queueSize;
            } else {
                ++this.queue2Size;
            }
        }

        private void removeFromQueue(Entry<V> e) {
            e.queuePrev.queueNext = e.queueNext;
            e.queueNext.queuePrev = e.queuePrev;
            e.queueNext = null;
            e.queuePrev = null;
            if (e.value != null) {
                --this.queueSize;
            } else {
                --this.queue2Size;
            }
        }

        synchronized List<Long> keys(boolean cold, boolean nonResident) {
            ArrayList<Long> keys = new ArrayList<Long>();
            if (cold) {
                Entry<V> start = nonResident ? this.queue2 : this.queue;
                Entry e = start.queueNext;
                while (e != start) {
                    keys.add(e.key);
                    e = e.queueNext;
                }
            } else {
                Entry e = this.stack.stackNext;
                while (e != this.stack) {
                    keys.add(e.key);
                    e = e.stackNext;
                }
            }
            return keys;
        }

        boolean containsKey(long key, int hash) {
            Entry<V> e = this.find(key, hash);
            return e != null && e.value != null;
        }

        synchronized Set<Long> keySet() {
            HashSet<Long> set = new HashSet<Long>();
            Entry e = this.stack.stackNext;
            while (e != this.stack) {
                set.add(e.key);
                e = e.stackNext;
            }
            e = this.queue.queueNext;
            while (e != this.queue) {
                set.add(e.key);
                e = e.queueNext;
            }
            return set;
        }

        void setMaxMemory(long maxMemory) {
            this.maxMemory = maxMemory;
        }
    }
}

