/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.mvstore.rtree;

import com.alibaba.dts.shade.org.h2.mvstore.CursorPos;
import com.alibaba.dts.shade.org.h2.mvstore.DataUtils;
import com.alibaba.dts.shade.org.h2.mvstore.MVMap;
import com.alibaba.dts.shade.org.h2.mvstore.Page;
import com.alibaba.dts.shade.org.h2.mvstore.rtree.SpatialDataType;
import com.alibaba.dts.shade.org.h2.mvstore.rtree.SpatialKey;
import com.alibaba.dts.shade.org.h2.mvstore.type.DataType;
import com.alibaba.dts.shade.org.h2.mvstore.type.ObjectDataType;
import com.alibaba.dts.shade.org.h2.util.New;
import java.util.ArrayList;
import java.util.Iterator;

public class MVRTreeMap<V>
extends MVMap<SpatialKey, V> {
    final SpatialDataType keyType = (SpatialDataType)this.getKeyType();
    private boolean quadraticSplit;

    public MVRTreeMap(int dimensions, DataType valueType) {
        super(new SpatialDataType(dimensions), valueType);
    }

    public static <V> MVRTreeMap<V> create(int dimensions, DataType valueType) {
        return new MVRTreeMap<V>(dimensions, valueType);
    }

    @Override
    public V get(Object key) {
        return (V)this.get(this.root, key);
    }

    public RTreeCursor findIntersectingKeys(SpatialKey x) {
        return new RTreeCursor(this.root, x){

            @Override
            protected boolean check(boolean leaf, SpatialKey key, SpatialKey test) {
                return MVRTreeMap.this.keyType.isOverlap(key, test);
            }
        };
    }

    public RTreeCursor findContainedKeys(SpatialKey x) {
        return new RTreeCursor(this.root, x){

            @Override
            protected boolean check(boolean leaf, SpatialKey key, SpatialKey test) {
                if (leaf) {
                    return MVRTreeMap.this.keyType.isInside(key, test);
                }
                return MVRTreeMap.this.keyType.isOverlap(key, test);
            }
        };
    }

    private boolean contains(Page p, int index, Object key) {
        return this.keyType.contains(p.getKey(index), key);
    }

    protected Object get(Page p, Object key) {
        if (!p.isLeaf()) {
            for (int i = 0; i < p.getKeyCount(); ++i) {
                Object o;
                if (!this.contains(p, i, key) || (o = this.get(p.getChildPage(i), key)) == null) continue;
                return o;
            }
        } else {
            for (int i = 0; i < p.getKeyCount(); ++i) {
                if (!this.keyType.equals(p.getKey(i), key)) continue;
                return p.getValue(i);
            }
        }
        return null;
    }

    @Override
    protected synchronized Object remove(Page p, long writeVersion, Object key) {
        Object result = null;
        if (p.isLeaf()) {
            for (int i = 0; i < p.getKeyCount(); ++i) {
                if (!this.keyType.equals(p.getKey(i), key)) continue;
                result = p.getValue(i);
                p.remove(i);
                break;
            }
            return result;
        }
        for (int i = 0; i < p.getKeyCount(); ++i) {
            if (!this.contains(p, i, key)) continue;
            Page cOld = p.getChildPage(i);
            Page c = cOld.copy(writeVersion);
            long oldSize = c.getTotalCount();
            result = this.remove(c, writeVersion, key);
            p.setChild(i, c);
            if (oldSize == c.getTotalCount()) continue;
            if (c.getTotalCount() == 0L) {
                p.remove(i);
                if (p.getKeyCount() != 0) break;
                c.removePage();
                break;
            }
            Object oldBounds = p.getKey(i);
            if (this.keyType.isInside(key, oldBounds)) break;
            p.setKey(i, this.getBounds(c));
            break;
        }
        return result;
    }

    private Object getBounds(Page x) {
        Object bounds = this.keyType.createBoundingBox(x.getKey(0));
        for (int i = 1; i < x.getKeyCount(); ++i) {
            this.keyType.increaseBounds(bounds, x.getKey(i));
        }
        return bounds;
    }

    @Override
    public V put(SpatialKey key, V value) {
        return (V)this.putOrAdd(key, value, false);
    }

    public void add(SpatialKey key, V value) {
        this.putOrAdd(key, value, true);
    }

    private synchronized Object putOrAdd(SpatialKey key, V value, boolean alwaysAdd) {
        Object result;
        this.beforeWrite();
        long v = this.writeVersion;
        Page p = this.root.copy(v);
        if (alwaysAdd || this.get(key) == null) {
            if (p.getMemory() > this.store.getPageSplitSize() && p.getKeyCount() > 3) {
                long totalCount = p.getTotalCount();
                Page split = this.split(p, v);
                Object k1 = this.getBounds(p);
                Object k2 = this.getBounds(split);
                Object[] keys = new Object[]{k1, k2};
                Page.PageReference[] children = new Page.PageReference[]{new Page.PageReference(p, p.getPos(), p.getTotalCount()), new Page.PageReference(split, split.getPos(), split.getTotalCount()), new Page.PageReference(null, 0L, 0L)};
                p = Page.create(this, v, keys, null, children, totalCount, 0);
            }
            this.add(p, v, key, value);
            result = null;
        } else {
            result = this.set(p, v, key, value);
        }
        this.newRoot(p);
        return result;
    }

    private Object set(Page p, long writeVersion, Object key, Object value) {
        if (p.isLeaf()) {
            for (int i = 0; i < p.getKeyCount(); ++i) {
                if (!this.keyType.equals(p.getKey(i), key)) continue;
                return p.setValue(i, value);
            }
        } else {
            for (int i = 0; i < p.getKeyCount(); ++i) {
                Page c;
                if (!this.contains(p, i, key) || this.get(c = p.getChildPage(i), key) == null) continue;
                c = c.copy(writeVersion);
                Object result = this.set(c, writeVersion, key, value);
                p.setChild(i, c);
                return result;
            }
        }
        throw DataUtils.newIllegalStateException(3, "Not found: {0}", key);
    }

    private void add(Page p, long writeVersion, Object key, Object value) {
        Page c;
        if (p.isLeaf()) {
            p.insertLeaf(p.getKeyCount(), key, value);
            return;
        }
        int index = -1;
        for (int i = 0; i < p.getKeyCount(); ++i) {
            if (!this.contains(p, i, key)) continue;
            index = i;
            break;
        }
        if (index < 0) {
            float min = Float.MAX_VALUE;
            for (int i = 0; i < p.getKeyCount(); ++i) {
                Object k = p.getKey(i);
                float areaIncrease = this.keyType.getAreaIncrease(k, key);
                if (!(areaIncrease < min)) continue;
                index = i;
                min = areaIncrease;
            }
        }
        if ((c = p.getChildPage(index).copy(writeVersion)).getMemory() > this.store.getPageSplitSize() && c.getKeyCount() > 4) {
            Page split = this.split(c, writeVersion);
            p.setKey(index, this.getBounds(c));
            p.setChild(index, c);
            p.insertNode(index, this.getBounds(split), split);
            this.add(p, writeVersion, key, value);
            return;
        }
        this.add(c, writeVersion, key, value);
        Object bounds = p.getKey(index);
        this.keyType.increaseBounds(bounds, key);
        p.setKey(index, bounds);
        p.setChild(index, c);
    }

    private Page split(Page p, long writeVersion) {
        return this.quadraticSplit ? this.splitQuadratic(p, writeVersion) : this.splitLinear(p, writeVersion);
    }

    private Page splitLinear(Page p, long writeVersion) {
        ArrayList<Object> keys = New.arrayList();
        for (int i = 0; i < p.getKeyCount(); ++i) {
            keys.add(p.getKey(i));
        }
        int[] extremes = this.keyType.getExtremes(keys);
        if (extremes == null) {
            return this.splitQuadratic(p, writeVersion);
        }
        Page splitA = this.newPage(p.isLeaf(), writeVersion);
        Page splitB = this.newPage(p.isLeaf(), writeVersion);
        MVRTreeMap.move(p, splitA, extremes[0]);
        if (extremes[1] > extremes[0]) {
            extremes[1] = extremes[1] - 1;
        }
        MVRTreeMap.move(p, splitB, extremes[1]);
        Object boundsA = this.keyType.createBoundingBox(splitA.getKey(0));
        Object boundsB = this.keyType.createBoundingBox(splitB.getKey(0));
        while (p.getKeyCount() > 0) {
            float b;
            Object o = p.getKey(0);
            float a = this.keyType.getAreaIncrease(boundsA, o);
            if (a < (b = this.keyType.getAreaIncrease(boundsB, o))) {
                this.keyType.increaseBounds(boundsA, o);
                MVRTreeMap.move(p, splitA, 0);
                continue;
            }
            this.keyType.increaseBounds(boundsB, o);
            MVRTreeMap.move(p, splitB, 0);
        }
        while (splitB.getKeyCount() > 0) {
            MVRTreeMap.move(splitB, p, 0);
        }
        return splitA;
    }

    private Page splitQuadratic(Page p, long writeVersion) {
        Page splitA = this.newPage(p.isLeaf(), writeVersion);
        Page splitB = this.newPage(p.isLeaf(), writeVersion);
        float largest = Float.MIN_VALUE;
        int ia = 0;
        int ib = 0;
        for (int a = 0; a < p.getKeyCount(); ++a) {
            Object objA = p.getKey(a);
            for (int b = 0; b < p.getKeyCount(); ++b) {
                Object objB;
                float area;
                if (a == b || !((area = this.keyType.getCombinedArea(objA, objB = p.getKey(b))) > largest)) continue;
                largest = area;
                ia = a;
                ib = b;
            }
        }
        MVRTreeMap.move(p, splitA, ia);
        if (ia < ib) {
            --ib;
        }
        MVRTreeMap.move(p, splitB, ib);
        Object boundsA = this.keyType.createBoundingBox(splitA.getKey(0));
        Object boundsB = this.keyType.createBoundingBox(splitB.getKey(0));
        while (p.getKeyCount() > 0) {
            float diff = 0.0f;
            float bestA = 0.0f;
            float bestB = 0.0f;
            int best = 0;
            for (int i = 0; i < p.getKeyCount(); ++i) {
                float incB;
                Object o = p.getKey(i);
                float incA = this.keyType.getAreaIncrease(boundsA, o);
                float d = Math.abs(incA - (incB = this.keyType.getAreaIncrease(boundsB, o)));
                if (!(d > diff)) continue;
                diff = d;
                bestA = incA;
                bestB = incB;
                best = i;
            }
            if (bestA < bestB) {
                this.keyType.increaseBounds(boundsA, p.getKey(best));
                MVRTreeMap.move(p, splitA, best);
                continue;
            }
            this.keyType.increaseBounds(boundsB, p.getKey(best));
            MVRTreeMap.move(p, splitB, best);
        }
        while (splitB.getKeyCount() > 0) {
            MVRTreeMap.move(splitB, p, 0);
        }
        return splitA;
    }

    private Page newPage(boolean leaf, long writeVersion) {
        Page.PageReference[] refs;
        Object[] values;
        if (leaf) {
            values = Page.EMPTY_OBJECT_ARRAY;
            refs = null;
        } else {
            values = null;
            refs = new Page.PageReference[]{new Page.PageReference(null, 0L, 0L)};
        }
        return Page.create(this, writeVersion, Page.EMPTY_OBJECT_ARRAY, values, refs, 0L, 0);
    }

    private static void move(Page source, Page target, int sourceIndex) {
        Object k = source.getKey(sourceIndex);
        if (source.isLeaf()) {
            Object v = source.getValue(sourceIndex);
            target.insertLeaf(0, k, v);
        } else {
            Page c = source.getChildPage(sourceIndex);
            target.insertNode(0, k, c);
        }
        source.remove(sourceIndex);
    }

    public void addNodeKeys(ArrayList<SpatialKey> list, Page p) {
        if (p != null && !p.isLeaf()) {
            for (int i = 0; i < p.getKeyCount(); ++i) {
                list.add((SpatialKey)p.getKey(i));
                this.addNodeKeys(list, p.getChildPage(i));
            }
        }
    }

    public boolean isQuadraticSplit() {
        return this.quadraticSplit;
    }

    public void setQuadraticSplit(boolean quadraticSplit) {
        this.quadraticSplit = quadraticSplit;
    }

    @Override
    protected int getChildPageCount(Page p) {
        return p.getRawChildPageCount() - 1;
    }

    @Override
    public String getType() {
        return "rtree";
    }

    public static class Builder<V>
    implements MVMap.MapBuilder<MVRTreeMap<V>, SpatialKey, V> {
        private int dimensions = 2;
        private DataType valueType;

        public Builder<V> dimensions(int dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public Builder<V> valueType(DataType valueType) {
            this.valueType = valueType;
            return this;
        }

        @Override
        public MVRTreeMap<V> create() {
            if (this.valueType == null) {
                this.valueType = new ObjectDataType();
            }
            return new MVRTreeMap(this.dimensions, this.valueType);
        }
    }

    public static class RTreeCursor
    implements Iterator<SpatialKey> {
        private final SpatialKey filter;
        private CursorPos pos;
        private SpatialKey current;
        private final Page root;
        private boolean initialized;

        protected RTreeCursor(Page root, SpatialKey filter) {
            this.root = root;
            this.filter = filter;
        }

        @Override
        public boolean hasNext() {
            if (!this.initialized) {
                this.pos = new CursorPos(this.root, 0, null);
                this.fetchNext();
                this.initialized = true;
            }
            return this.current != null;
        }

        public void skip(long n) {
            while (this.hasNext() && n-- > 0L) {
                this.fetchNext();
            }
        }

        @Override
        public SpatialKey next() {
            if (!this.hasNext()) {
                return null;
            }
            SpatialKey c = this.current;
            this.fetchNext();
            return c;
        }

        @Override
        public void remove() {
            throw DataUtils.newUnsupportedOperationException("Removing is not supported");
        }

        protected void fetchNext() {
            while (this.pos != null) {
                Page p = this.pos.page;
                if (p.isLeaf()) {
                    while (this.pos.index < p.getKeyCount()) {
                        SpatialKey c = (SpatialKey)p.getKey(this.pos.index++);
                        if (this.filter != null && !this.check(true, c, this.filter)) continue;
                        this.current = c;
                        return;
                    }
                } else {
                    boolean found = false;
                    while (this.pos.index < p.getKeyCount()) {
                        int index;
                        ++this.pos.index;
                        SpatialKey c = (SpatialKey)p.getKey(index);
                        if (this.filter != null && !this.check(false, c, this.filter)) continue;
                        Page child = this.pos.page.getChildPage(index);
                        this.pos = new CursorPos(child, 0, this.pos);
                        found = true;
                        break;
                    }
                    if (found) continue;
                }
                this.pos = this.pos.parent;
            }
            this.current = null;
        }

        protected boolean check(boolean leaf, SpatialKey key, SpatialKey test) {
            return true;
        }
    }
}

