/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.store.fs;

import com.alibaba.dts.shade.org.h2.compress.CompressLZF;
import com.alibaba.dts.shade.org.h2.util.MathUtils;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

class FileMemData {
    private static final int CACHE_SIZE = 8;
    private static final int BLOCK_SIZE_SHIFT = 10;
    private static final int BLOCK_SIZE = 1024;
    private static final int BLOCK_SIZE_MASK = 1023;
    private static final CompressLZF LZF = new CompressLZF();
    private static final byte[] BUFFER = new byte[2048];
    private static final byte[] COMPRESSED_EMPTY_BLOCK;
    private static final Cache<CompressItem, CompressItem> COMPRESS_LATER;
    private String name;
    private final boolean compress;
    private long length;
    private byte[][] data;
    private long lastModified;
    private boolean isReadOnly;
    private boolean isLockedExclusive;
    private int sharedLockCount;

    FileMemData(String name, boolean compress) {
        this.name = name;
        this.compress = compress;
        this.data = new byte[0][];
        this.lastModified = System.currentTimeMillis();
    }

    synchronized boolean lockExclusive() {
        if (this.sharedLockCount > 0 || this.isLockedExclusive) {
            return false;
        }
        this.isLockedExclusive = true;
        return true;
    }

    synchronized boolean lockShared() {
        if (this.isLockedExclusive) {
            return false;
        }
        ++this.sharedLockCount;
        return true;
    }

    synchronized void unlock() {
        if (this.isLockedExclusive) {
            this.isLockedExclusive = false;
        } else {
            this.sharedLockCount = Math.max(0, this.sharedLockCount - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compressLater(byte[][] data, int page) {
        CompressItem c = new CompressItem();
        c.data = data;
        c.page = page;
        CompressLZF compressLZF = LZF;
        synchronized (compressLZF) {
            COMPRESS_LATER.put(c, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void expand(byte[][] data, int page) {
        byte[] d = data[page];
        if (d.length == 1024) {
            return;
        }
        byte[] out = new byte[1024];
        if (d != COMPRESSED_EMPTY_BLOCK) {
            CompressLZF compressLZF = LZF;
            synchronized (compressLZF) {
                LZF.expand(d, 0, d.length, out, 0, 1024);
            }
        }
        data[page] = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void compress(byte[][] data, int page) {
        byte[] d = data[page];
        CompressLZF compressLZF = LZF;
        synchronized (compressLZF) {
            int len = LZF.compress(d, 1024, BUFFER, 0);
            if (len <= 1024) {
                d = new byte[len];
                System.arraycopy(BUFFER, 0, d, 0, len);
                data[page] = d;
            }
        }
    }

    void touch(boolean openReadOnly) throws IOException {
        if (this.isReadOnly || openReadOnly) {
            throw new IOException("Read only");
        }
        this.lastModified = System.currentTimeMillis();
    }

    long length() {
        return this.length;
    }

    void truncate(long newLength) {
        this.changeLength(newLength);
        long end = MathUtils.roundUpLong(newLength, 1024L);
        if (end != newLength) {
            int lastPage = (int)(newLength >>> 10);
            FileMemData.expand(this.data, lastPage);
            byte[] d = this.data[lastPage];
            for (int i = (int)(newLength & 0x3FFL); i < 1024; ++i) {
                d[i] = 0;
            }
            if (this.compress) {
                FileMemData.compressLater(this.data, lastPage);
            }
        }
    }

    private void changeLength(long len) {
        this.length = len;
        int blocks = (int)((len = MathUtils.roundUpLong(len, 1024L)) >>> 10);
        if (blocks != this.data.length) {
            byte[][] n = new byte[blocks][];
            System.arraycopy(this.data, 0, n, 0, Math.min(this.data.length, n.length));
            for (int i = this.data.length; i < blocks; ++i) {
                n[i] = COMPRESSED_EMPTY_BLOCK;
            }
            this.data = n;
        }
    }

    long readWrite(long pos, byte[] b, int off, int len, boolean write) {
        long end = pos + (long)len;
        if (end > this.length) {
            if (write) {
                this.changeLength(end);
            } else {
                len = (int)(this.length - pos);
            }
        }
        while (len > 0) {
            int l = (int)Math.min((long)len, 1024L - (pos & 0x3FFL));
            int page = (int)(pos >>> 10);
            FileMemData.expand(this.data, page);
            byte[] block = this.data[page];
            int blockOffset = (int)(pos & 0x3FFL);
            if (write) {
                System.arraycopy(b, off, block, blockOffset, l);
            } else {
                System.arraycopy(block, blockOffset, b, off, l);
            }
            if (this.compress) {
                FileMemData.compressLater(this.data, page);
            }
            off += l;
            pos += (long)l;
            len -= l;
        }
        return pos;
    }

    void setName(String name) {
        this.name = name;
    }

    String getName() {
        return this.name;
    }

    long getLastModified() {
        return this.lastModified;
    }

    boolean canWrite() {
        return !this.isReadOnly;
    }

    boolean setReadOnly() {
        this.isReadOnly = true;
        return true;
    }

    static {
        COMPRESS_LATER = new Cache(8);
        byte[] n = new byte[1024];
        int len = LZF.compress(n, 1024, BUFFER, 0);
        COMPRESSED_EMPTY_BLOCK = new byte[len];
        System.arraycopy(BUFFER, 0, COMPRESSED_EMPTY_BLOCK, 0, len);
    }

    static class CompressItem {
        byte[][] data;
        int page;

        CompressItem() {
        }

        public int hashCode() {
            return this.page;
        }

        public boolean equals(Object o) {
            if (o instanceof CompressItem) {
                CompressItem c = (CompressItem)o;
                return c.data == this.data && c.page == this.page;
            }
            return false;
        }
    }

    static class Cache<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;
        private final int size;

        Cache(int size) {
            super(size, 0.75f, true);
            this.size = size;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            if (this.size() < this.size) {
                return false;
            }
            CompressItem c = (CompressItem)eldest.getKey();
            FileMemData.compress(c.data, c.page);
            return true;
        }
    }
}

