/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.store.fs;

import com.alibaba.dts.shade.org.h2.util.MathUtils;
import com.alibaba.dts.shade.org.h2.util.New;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class FilePath {
    private static FilePath defaultProvider;
    private static Map<String, FilePath> providers;
    private static String tempRandom;
    private static long tempSequence;
    protected String name;

    public static FilePath get(String path) {
        path = path.replace('\\', '/');
        int index = path.indexOf(58);
        FilePath.registerDefaultProviders();
        if (index < 2) {
            return defaultProvider.getPath(path);
        }
        String scheme = path.substring(0, index);
        FilePath p = providers.get(scheme);
        if (p == null) {
            p = defaultProvider;
        }
        return p.getPath(path);
    }

    private static void registerDefaultProviders() {
        if (providers == null || defaultProvider == null) {
            Map<String, FilePath> map = Collections.synchronizedMap(New.hashMap());
            for (String c : new String[]{"com.alibaba.dts.shade.org.h2.store.fs.FilePathDisk", "com.alibaba.dts.shade.org.h2.store.fs.FilePathMem", "com.alibaba.dts.shade.org.h2.store.fs.FilePathMemLZF", "com.alibaba.dts.shade.org.h2.store.fs.FilePathNioMem", "com.alibaba.dts.shade.org.h2.store.fs.FilePathNioMemLZF", "com.alibaba.dts.shade.org.h2.store.fs.FilePathSplit", "com.alibaba.dts.shade.org.h2.store.fs.FilePathNio", "com.alibaba.dts.shade.org.h2.store.fs.FilePathNioMapped", "com.alibaba.dts.shade.org.h2.store.fs.FilePathZip", "com.alibaba.dts.shade.org.h2.store.fs.FilePathRetryOnInterrupt"}) {
                try {
                    FilePath p = (FilePath)Class.forName(c).newInstance();
                    map.put(p.getScheme(), p);
                    if (defaultProvider != null) continue;
                    defaultProvider = p;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            providers = map;
        }
    }

    public static void register(FilePath provider) {
        FilePath.registerDefaultProviders();
        providers.put(provider.getScheme(), provider);
    }

    public static void unregister(FilePath provider) {
        FilePath.registerDefaultProviders();
        providers.remove(provider.getScheme());
    }

    public abstract long size();

    public abstract void moveTo(FilePath var1, boolean var2);

    public abstract boolean createFile();

    public abstract boolean exists();

    public abstract void delete();

    public abstract List<FilePath> newDirectoryStream();

    public abstract FilePath toRealPath();

    public abstract FilePath getParent();

    public abstract boolean isDirectory();

    public abstract boolean isAbsolute();

    public abstract long lastModified();

    public abstract boolean canWrite();

    public abstract void createDirectory();

    public String getName() {
        int idx = Math.max(this.name.indexOf(58), this.name.lastIndexOf(47));
        return idx < 0 ? this.name : this.name.substring(idx + 1);
    }

    public abstract OutputStream newOutputStream(boolean var1) throws IOException;

    public abstract FileChannel open(String var1) throws IOException;

    public abstract InputStream newInputStream() throws IOException;

    public abstract boolean setReadOnly();

    public FilePath createTempFile(String suffix, boolean deleteOnExit, boolean inTempDir) throws IOException {
        FilePath p;
        while ((p = this.getPath(this.name + FilePath.getNextTempFileNamePart(false) + suffix)).exists() || !p.createFile()) {
            FilePath.getNextTempFileNamePart(true);
        }
        p.open("rw").close();
        return p;
    }

    protected static synchronized String getNextTempFileNamePart(boolean newRandom) {
        if (newRandom || tempRandom == null) {
            tempRandom = MathUtils.randomInt(Integer.MAX_VALUE) + ".";
        }
        return tempRandom + tempSequence++;
    }

    public String toString() {
        return this.name;
    }

    public abstract String getScheme();

    public abstract FilePath getPath(String var1);

    public FilePath unwrap() {
        return this;
    }
}

