/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.store.fs;

import com.alibaba.dts.shade.org.h2.store.fs.FilePath;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.List;

public abstract class FilePathWrapper
extends FilePath {
    private FilePath base;

    @Override
    public FilePathWrapper getPath(String path) {
        return this.create(path, this.unwrap(path));
    }

    public FilePathWrapper wrap(FilePath base) {
        return base == null ? null : this.create(this.getPrefix() + base.name, base);
    }

    @Override
    public FilePath unwrap() {
        return this.unwrap(this.name);
    }

    private FilePathWrapper create(String path, FilePath base) {
        try {
            FilePathWrapper p = (FilePathWrapper)this.getClass().newInstance();
            p.name = path;
            p.base = base;
            return p;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Path: " + path, e);
        }
    }

    protected String getPrefix() {
        return this.getScheme() + ":";
    }

    protected FilePath unwrap(String path) {
        return FilePath.get(path.substring(this.getScheme().length() + 1));
    }

    protected FilePath getBase() {
        return this.base;
    }

    @Override
    public boolean canWrite() {
        return this.base.canWrite();
    }

    @Override
    public void createDirectory() {
        this.base.createDirectory();
    }

    @Override
    public boolean createFile() {
        return this.base.createFile();
    }

    @Override
    public void delete() {
        this.base.delete();
    }

    @Override
    public boolean exists() {
        return this.base.exists();
    }

    @Override
    public FilePath getParent() {
        return this.wrap(this.base.getParent());
    }

    @Override
    public boolean isAbsolute() {
        return this.base.isAbsolute();
    }

    @Override
    public boolean isDirectory() {
        return this.base.isDirectory();
    }

    @Override
    public long lastModified() {
        return this.base.lastModified();
    }

    @Override
    public FilePath toRealPath() {
        return this.wrap(this.base.toRealPath());
    }

    @Override
    public List<FilePath> newDirectoryStream() {
        List<FilePath> list = this.base.newDirectoryStream();
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            list.set(i, this.wrap(list.get(i)));
        }
        return list;
    }

    @Override
    public void moveTo(FilePath newName, boolean atomicReplace) {
        this.base.moveTo(((FilePathWrapper)newName).base, atomicReplace);
    }

    @Override
    public InputStream newInputStream() throws IOException {
        return this.base.newInputStream();
    }

    @Override
    public OutputStream newOutputStream(boolean append) throws IOException {
        return this.base.newOutputStream(append);
    }

    @Override
    public FileChannel open(String mode) throws IOException {
        return this.base.open(mode);
    }

    @Override
    public boolean setReadOnly() {
        return this.base.setReadOnly();
    }

    @Override
    public long size() {
        return this.base.size();
    }

    @Override
    public FilePath createTempFile(String suffix, boolean deleteOnExit, boolean inTempDir) throws IOException {
        return this.wrap(this.base.createTempFile(suffix, deleteOnExit, inTempDir));
    }
}

