/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.store.fs;

import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.store.fs.FileChannelInputStream;
import com.alibaba.dts.shade.org.h2.store.fs.FilePath;
import com.alibaba.dts.shade.org.h2.store.fs.FilePathDisk;
import com.alibaba.dts.shade.org.h2.store.fs.FileZip;
import com.alibaba.dts.shade.org.h2.util.New;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FilePathZip
extends FilePath {
    @Override
    public FilePathZip getPath(String path) {
        FilePathZip p = new FilePathZip();
        p.name = path;
        return p;
    }

    @Override
    public void createDirectory() {
    }

    @Override
    public boolean createFile() {
        throw DbException.getUnsupportedException("write");
    }

    @Override
    public void delete() {
        throw DbException.getUnsupportedException("write");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists() {
        boolean bl;
        String entryName = this.getEntryName();
        if (entryName.length() == 0) {
            return true;
        }
        ZipFile file = this.openZipFile();
        try {
            bl = file.getEntry(entryName) != null;
        }
        catch (Throwable throwable) {
            try {
                file.close();
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        file.close();
        return bl;
    }

    @Override
    public long lastModified() {
        return 0L;
    }

    @Override
    public FilePath getParent() {
        int idx = this.name.lastIndexOf(47);
        return idx < 0 ? null : this.getPath(this.name.substring(0, idx));
    }

    @Override
    public boolean isAbsolute() {
        String fileName = FilePathZip.translateFileName(this.name);
        return FilePath.get(fileName).isAbsolute();
    }

    @Override
    public FilePath unwrap() {
        return FilePath.get(this.name.substring(this.getScheme().length() + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isDirectory() {
        try {
            String entryName = this.getEntryName();
            if (entryName.length() == 0) {
                return true;
            }
            ZipFile file = this.openZipFile();
            try {
                String n;
                Enumeration<? extends ZipEntry> en = file.entries();
                do {
                    if (!en.hasMoreElements()) return false;
                    ZipEntry entry = en.nextElement();
                    n = entry.getName();
                    if (!n.equals(entryName)) continue;
                    boolean bl = entry.isDirectory();
                    return bl;
                } while (!n.startsWith(entryName) || n.length() != entryName.length() + 1 || !n.equals(entryName + "/"));
                boolean bl = true;
                return bl;
            }
            finally {
                file.close();
            }
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public boolean setReadOnly() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size() {
        long l;
        ZipFile file = this.openZipFile();
        try {
            ZipEntry entry = file.getEntry(this.getEntryName());
            l = entry == null ? 0L : entry.getSize();
        }
        catch (Throwable throwable) {
            try {
                file.close();
                throw throwable;
            }
            catch (IOException e) {
                return 0L;
            }
        }
        file.close();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<FilePath> newDirectoryStream() {
        String path = this.name;
        ArrayList<FilePath> list = New.arrayList();
        try {
            if (path.indexOf(33) < 0) {
                path = path + "!";
            }
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            ZipFile file = this.openZipFile();
            try {
                String dirName = this.getEntryName();
                String prefix = path.substring(0, path.length() - dirName.length());
                Enumeration<? extends ZipEntry> en = file.entries();
                while (en.hasMoreElements()) {
                    int idx;
                    ZipEntry entry = en.nextElement();
                    String name = entry.getName();
                    if (!name.startsWith(dirName) || name.length() <= dirName.length() || (idx = name.indexOf(47, dirName.length())) >= 0 && idx < name.length() - 1) continue;
                    list.add(this.getPath(prefix + name));
                }
            }
            finally {
                file.close();
            }
            return list;
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, "listFiles " + path);
        }
    }

    @Override
    public InputStream newInputStream() throws IOException {
        return new FileChannelInputStream(this.open("r"), true);
    }

    @Override
    public FileChannel open(String mode) throws IOException {
        ZipFile file = this.openZipFile();
        ZipEntry entry = file.getEntry(this.getEntryName());
        if (entry == null) {
            file.close();
            throw new FileNotFoundException(this.name);
        }
        return new FileZip(file, entry);
    }

    @Override
    public OutputStream newOutputStream(boolean append) throws IOException {
        throw new IOException("write");
    }

    @Override
    public void moveTo(FilePath newName, boolean atomicReplace) {
        throw DbException.getUnsupportedException("write");
    }

    private static String translateFileName(String fileName) {
        int idx;
        if (fileName.startsWith("zip:")) {
            fileName = fileName.substring("zip:".length());
        }
        if ((idx = fileName.indexOf(33)) >= 0) {
            fileName = fileName.substring(0, idx);
        }
        return FilePathDisk.expandUserHomeDirectory(fileName);
    }

    @Override
    public FilePath toRealPath() {
        return this;
    }

    private String getEntryName() {
        int idx = this.name.indexOf(33);
        String fileName = idx <= 0 ? "" : this.name.substring(idx + 1);
        if ((fileName = fileName.replace('\\', '/')).startsWith("/")) {
            fileName = fileName.substring(1);
        }
        return fileName;
    }

    private ZipFile openZipFile() throws IOException {
        String fileName = FilePathZip.translateFileName(this.name);
        return new ZipFile(fileName);
    }

    @Override
    public FilePath createTempFile(String suffix, boolean deleteOnExit, boolean inTempDir) throws IOException {
        if (!inTempDir) {
            throw new IOException("File system is read-only");
        }
        return new FilePathDisk().getPath(this.name).createTempFile(suffix, deleteOnExit, true);
    }

    @Override
    public String getScheme() {
        return "zip";
    }
}

