/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.table;

import com.alibaba.dts.shade.org.h2.command.ddl.CreateTableData;
import com.alibaba.dts.shade.org.h2.engine.Database;
import com.alibaba.dts.shade.org.h2.engine.DbSettings;
import com.alibaba.dts.shade.org.h2.mvstore.db.MVTableEngine;
import com.alibaba.dts.shade.org.h2.table.Column;
import com.alibaba.dts.shade.org.h2.table.Table;
import com.alibaba.dts.shade.org.h2.util.StatementBuilder;
import com.alibaba.dts.shade.org.h2.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class TableBase
extends Table {
    private final String tableEngine;
    private List<String> tableEngineParams = new ArrayList<String>();
    private final boolean globalTemporary;

    public TableBase(CreateTableData data) {
        super(data.schema, data.id, data.tableName, data.persistIndexes, data.persistData);
        this.tableEngine = data.tableEngine;
        this.globalTemporary = data.globalTemporary;
        if (data.tableEngineParams != null) {
            this.tableEngineParams = data.tableEngineParams;
        }
        this.setTemporary(data.temporary);
        Column[] cols = new Column[data.columns.size()];
        data.columns.toArray(cols);
        this.setColumns(cols);
        if (data.compareMode != null) {
            this.compareMode = data.compareMode;
        }
    }

    @Override
    public String getDropSQL() {
        return "DROP TABLE IF EXISTS " + this.getSQL() + " CASCADE";
    }

    @Override
    public String getCreateSQL() {
        Database db = this.getDatabase();
        if (db == null) {
            return null;
        }
        StatementBuilder buff = new StatementBuilder("CREATE ");
        if (this.isTemporary()) {
            if (this.isGlobalTemporary()) {
                buff.append("GLOBAL ");
            } else {
                buff.append("LOCAL ");
            }
            buff.append("TEMPORARY ");
        } else if (this.isPersistIndexes()) {
            buff.append("CACHED ");
        } else {
            buff.append("MEMORY ");
        }
        buff.append("TABLE ");
        if (this.isHidden) {
            buff.append("IF NOT EXISTS ");
        }
        buff.append(this.getSQL());
        if (this.comment != null) {
            buff.append(" COMMENT ").append(StringUtils.quoteStringSQL(this.comment));
        }
        buff.append("(\n    ");
        for (Column column : this.columns) {
            buff.appendExceptFirst(",\n    ");
            buff.append(column.getCreateSQL());
        }
        buff.append("\n)");
        if (this.tableEngine != null) {
            DbSettings s = db.getSettings();
            String d = s.defaultTableEngine;
            if (d == null && s.mvStore) {
                d = MVTableEngine.class.getName();
            }
            if (d == null || !this.tableEngine.endsWith(d)) {
                buff.append("\nENGINE ");
                buff.append(StringUtils.quoteIdentifier(this.tableEngine));
            }
        }
        if (!this.tableEngineParams.isEmpty()) {
            buff.append("\nWITH ");
            buff.resetCount();
            for (String parameter : this.tableEngineParams) {
                buff.appendExceptFirst(", ");
                buff.append(StringUtils.quoteIdentifier(parameter));
            }
        }
        if (!this.isPersistIndexes() && !this.isPersistData()) {
            buff.append("\nNOT PERSISTENT");
        }
        if (this.isHidden) {
            buff.append("\nHIDDEN");
        }
        if (this.compareMode != null) {
            buff.append("\nCOLLATE ");
            String name = this.compareMode.getName();
            if (name == null || name.equals("OFF")) {
                buff.append("OFF");
            } else {
                buff.append(name);
                switch (this.compareMode.getStrength()) {
                    case 0: {
                        buff.append(" STRENGTH PRIMARY");
                        break;
                    }
                    case 1: {
                        buff.append(" STRENGTH SECONDARY");
                        break;
                    }
                    case 2: {
                        buff.append(" STRENGTH TERTIARY");
                        break;
                    }
                    case 3: {
                        buff.append(" STRENGTH IDENTICAL");
                        break;
                    }
                }
            }
        }
        return buff.toString();
    }

    @Override
    public boolean isGlobalTemporary() {
        return this.globalTemporary;
    }
}

