/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.value;

import com.alibaba.dts.shade.org.h2.engine.SysProperties;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.util.SmallLRUCache;
import com.alibaba.dts.shade.org.h2.value.CompareMode;
import java.text.CollationKey;
import java.text.Collator;

public class CompareModeDefault
extends CompareMode {
    private final Collator collator;
    private final SmallLRUCache<String, CollationKey> collationKeys;

    protected CompareModeDefault(String name, int strength, boolean binaryUnsigned) {
        super(name, strength, binaryUnsigned);
        this.collator = CompareMode.getCollator(name);
        if (this.collator == null) {
            throw DbException.throwInternalError(name);
        }
        this.collator.setStrength(strength);
        int cacheSize = SysProperties.COLLATOR_CACHE_SIZE;
        this.collationKeys = cacheSize != 0 ? SmallLRUCache.newInstance(cacheSize) : null;
    }

    @Override
    public int compareString(String a, String b, boolean ignoreCase) {
        int comp;
        if (ignoreCase) {
            a = a.toUpperCase();
            b = b.toUpperCase();
        }
        if (this.collationKeys != null) {
            CollationKey aKey = this.getKey(a);
            CollationKey bKey = this.getKey(b);
            comp = aKey.compareTo(bKey);
        } else {
            comp = this.collator.compare(a, b);
        }
        return comp;
    }

    @Override
    public boolean equalsChars(String a, int ai, String b, int bi, boolean ignoreCase) {
        return this.compareString(a.substring(ai, ai + 1), b.substring(bi, bi + 1), ignoreCase) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CollationKey getKey(String a) {
        SmallLRUCache<String, CollationKey> smallLRUCache = this.collationKeys;
        synchronized (smallLRUCache) {
            CollationKey key = (CollationKey)this.collationKeys.get(a);
            if (key == null) {
                key = this.collator.getCollationKey(a);
                this.collationKeys.put(a, key);
            }
            return key;
        }
    }
}

