/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.value;

import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.util.MathUtils;
import com.alibaba.dts.shade.org.h2.value.CompareMode;
import com.alibaba.dts.shade.org.h2.value.Value;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class ValueLongUnsigned
extends Value {
    public static final BigInteger MAX = new BigInteger("18446744073709551615");
    public static final int PRECISION = 20;
    public static final int DISPLAY_SIZE = 20;
    private static final BigInteger MIN = BigInteger.valueOf(0L);
    private static final int STATIC_SIZE = 100;
    private static final ValueLongUnsigned[] STATIC_CACHE = new ValueLongUnsigned[100];
    private final long value;

    private ValueLongUnsigned(long value) {
        this.value = value;
    }

    @Override
    public Value add(Value v) {
        ValueLongUnsigned other = (ValueLongUnsigned)v;
        BigInteger result = ValueLongUnsigned.long2Big(this.value).add(ValueLongUnsigned.long2Big(other.value));
        if (result.compareTo(MAX) <= 0) {
            return ValueLongUnsigned.get(ValueLongUnsigned.big2Long(result));
        }
        throw this.getOverflow();
    }

    @Override
    public int getSignum() {
        return ValueLongUnsigned.long2Big(this.value).signum();
    }

    @Override
    public Value negate() {
        if (this.value != 0L) {
            throw this.getOverflow();
        }
        return ValueLongUnsigned.get(-this.value);
    }

    private DbException getOverflow() {
        return DbException.get(22003, ValueLongUnsigned.long2Big(this.value).toString());
    }

    @Override
    public Value subtract(Value v) {
        ValueLongUnsigned other = (ValueLongUnsigned)v;
        BigInteger result = ValueLongUnsigned.long2Big(this.value).subtract(ValueLongUnsigned.long2Big(other.value));
        if (result.signum() >= 0) {
            return ValueLongUnsigned.get(ValueLongUnsigned.big2Long(result));
        }
        throw this.getOverflow();
    }

    private static boolean isInteger(long a) {
        return a >= Integer.MIN_VALUE && a <= Integer.MAX_VALUE;
    }

    @Override
    public Value multiply(Value v) {
        ValueLongUnsigned other = (ValueLongUnsigned)v;
        BigInteger br = ValueLongUnsigned.long2Big(this.value).multiply(ValueLongUnsigned.long2Big(other.value));
        if (br.compareTo(MIN) < 0 || br.compareTo(MAX) > 0) {
            throw this.getOverflow();
        }
        return ValueLongUnsigned.get(ValueLongUnsigned.big2Long(br));
    }

    @Override
    public Value divide(Value v) {
        ValueLongUnsigned other = (ValueLongUnsigned)v;
        if (other.value == 0L) {
            throw DbException.get(22012, this.getSQL());
        }
        BigInteger result = ValueLongUnsigned.long2Big(this.value).divide(ValueLongUnsigned.long2Big(other.value));
        return ValueLongUnsigned.get(ValueLongUnsigned.big2Long(result));
    }

    @Override
    public Value modulus(Value v) {
        ValueLongUnsigned other = (ValueLongUnsigned)v;
        if (other.value == 0L) {
            throw DbException.get(22012, this.getSQL());
        }
        BigInteger result = ValueLongUnsigned.long2Big(this.value).mod(ValueLongUnsigned.long2Big(other.value));
        return ValueLongUnsigned.get(ValueLongUnsigned.big2Long(result));
    }

    @Override
    public String getSQL() {
        return this.getString();
    }

    @Override
    public int getType() {
        return 23;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    protected int compareSecure(Value o, CompareMode mode) {
        ValueLongUnsigned v = (ValueLongUnsigned)o;
        return MathUtils.compareLongUnsigned(ValueLongUnsigned.long2Big(this.value), ValueLongUnsigned.long2Big(v.value));
    }

    @Override
    public String getString() {
        return ValueLongUnsigned.long2Big(this.value).toString();
    }

    @Override
    public long getPrecision() {
        return 20L;
    }

    @Override
    public int hashCode() {
        return (int)(this.value ^ this.value >> 32);
    }

    @Override
    public Object getObject() {
        return ValueLongUnsigned.long2Big(this.value);
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setLong(parameterIndex, this.value);
    }

    public static ValueLongUnsigned get(long i) {
        if (i >= 0L && i < 100L) {
            return STATIC_CACHE[(int)i];
        }
        return (ValueLongUnsigned)Value.cache(new ValueLongUnsigned(i));
    }

    @Override
    public int getDisplaySize() {
        return 20;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ValueLongUnsigned && this.value == ((ValueLongUnsigned)other).value;
    }

    private static BigInteger long2Big(long value) {
        long temp = value;
        byte[] bytes = new byte[8];
        for (int i = bytes.length - 1; i >= 0; --i) {
            bytes[i] = (byte)(temp & 0xFFL);
            temp >>= 8;
        }
        return new BigInteger(1, bytes);
    }

    private static long big2Long(BigInteger value) {
        return value.longValue();
    }

    static {
        for (int i = 0; i < 100; ++i) {
            ValueLongUnsigned.STATIC_CACHE[i] = new ValueLongUnsigned(i);
        }
    }
}

