/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tmq.client.context;

import com.alibaba.tmq.client.config.ClientConfig;
import com.alibaba.tmq.client.monitor.ClientMonitor;
import com.alibaba.tmq.client.remoting.ClientRemoting;
import com.alibaba.tmq.client.service.DefaultClientService;
import com.alibaba.tmq.client.zookeeper.Zookeeper;
import com.alibaba.tmq.common.exception.InitException;
import com.alibaba.tmq.common.proxy.ProxyService;
import com.alibaba.tmq.common.service.HttpService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientContext {
    private static final Log logger = LogFactory.getLog(ClientContext.class);
    public static final ClientConfig clientConfig = new ClientConfig();
    public static final ProxyService proxyService = new ProxyService();
    public static final ClientRemoting clientRemoting = new ClientRemoting();
    public static final Zookeeper zookeeper = new Zookeeper();
    public static final DefaultClientService clientService = new DefaultClientService();
    public static final ClientMonitor clientMonitor = new ClientMonitor();
    private static final AtomicBoolean clientStart = new AtomicBoolean(false);
    public static final HttpService httpService = new HttpService();

    public static synchronized void initClient() throws InitException {
        if (clientStart.get()) {
            logger.warn((Object)("[ClientContext]: initClient client already start, clientConfig:" + clientConfig + ", currentThread:" + Thread.currentThread().getName()));
            return;
        }
        clientConfig.init();
        zookeeper.init();
        clientRemoting.init();
        clientMonitor.init();
        clientStart.set(true);
        logger.warn((Object)("[ClientContext]: initClient over, clientConfig:" + clientConfig.toString()));
    }
}

