/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tmq.client.system.producer.executer;

import com.alibaba.tmq.client.system.producer.config.ProducerConfig;
import com.alibaba.tmq.common.util.MapUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProducerExecuter {
    private static final Log logger = LogFactory.getLog(ProducerExecuter.class);
    private final ConcurrentHashMap<String, AtomicLong> increaseCounterTable = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, AtomicLong> compareCounterTable = new ConcurrentHashMap();
    private final ProducerConfig producerConfig;
    private volatile boolean start = false;

    public ProducerExecuter(ProducerConfig producerConfig) {
        this.producerConfig = producerConfig;
    }

    public AtomicLong getIncreaseCounter(String server) {
        return MapUtil.getCounter(this.increaseCounterTable, server);
    }

    public AtomicLong getCompareCounter(String server) {
        return MapUtil.getCounter(this.compareCounterTable, server);
    }

    public ProducerConfig getProducerConfig() {
        return this.producerConfig;
    }

    public boolean isStart() {
        return this.start;
    }

    public void setStart(boolean start) {
        this.start = start;
    }
}

