/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tmq.client.system.producer.executer;

import com.alibaba.tmq.client.system.producer.TransactionProducer;
import com.alibaba.tmq.client.system.producer.checker.LocalTransactionChecker;
import com.alibaba.tmq.client.system.producer.config.ProducerConfig;
import com.alibaba.tmq.client.system.producer.executer.ProducerExecuter;
import com.alibaba.tmq.client.system.producer.implement.DefaultTransactionProducer;
import com.alibaba.tmq.common.domain.Message;
import com.alibaba.tmq.common.domain.TransactionStatus;
import com.alibaba.tmq.common.domain.result.Result;
import com.alibaba.tmq.common.domain.result.ResultCode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransactionProducerExecuter
extends ProducerExecuter {
    private static final Log logger = LogFactory.getLog(TransactionProducerExecuter.class);
    private final TransactionProducer producer;
    private final LocalTransactionChecker localTransactionChecker;

    public TransactionProducerExecuter(ProducerConfig producerConfig, LocalTransactionChecker localTransactionChecker) {
        super(producerConfig);
        this.producer = new DefaultTransactionProducer(producerConfig, this);
        this.localTransactionChecker = localTransactionChecker;
    }

    public Result<TransactionStatus> check(Message message) {
        Result<TransactionStatus> result = new Result<TransactionStatus>();
        if (null == this.localTransactionChecker) {
            logger.error((Object)("[ProducerExecuter]: check message fatal error, localTransactionChecker is null, message:" + message));
            result.setData(TransactionStatus.UnKnow);
            result.setResultCode(ResultCode.CHECKER_NULL_ERROR);
            return result;
        }
        TransactionStatus transactionStatus = TransactionStatus.UnKnow;
        try {
            transactionStatus = this.localTransactionChecker.check(message);
        }
        catch (Throwable e) {
            logger.error((Object)("[ProducerExecuter]: check message error, message:" + message), e);
            result.setData(TransactionStatus.UnKnow);
            result.setResultCode(ResultCode.CHECK_EXCEPTION);
            return result;
        }
        if (null == transactionStatus) {
            logger.error((Object)("[ProducerExecuter]: check result transactionStatus is null error, waiting recheck, message:" + message));
            result.setData(TransactionStatus.UnKnow);
            result.setResultCode(ResultCode.CHECK_RETURN_NULL_ERROR);
            return result;
        }
        result.setData(transactionStatus);
        result.setResultCode(ResultCode.SUCCESS);
        return result;
    }

    public TransactionProducer getProducer() {
        return this.producer;
    }
}

