/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tmq.client.system.producer.implement;

import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEye;
import com.alibaba.tmq.client.TMQFactory;
import com.alibaba.tmq.client.remoting.ClientRemoting;
import com.alibaba.tmq.client.system.producer.NormalProducer;
import com.alibaba.tmq.client.system.producer.config.ProducerConfig;
import com.alibaba.tmq.client.system.producer.executer.ProducerExecuter;
import com.alibaba.tmq.client.system.producer.implement.DefaultProducer;
import com.alibaba.tmq.client.util.StringUtil;
import com.alibaba.tmq.common.constants.Constants;
import com.alibaba.tmq.common.context.InvocationContext;
import com.alibaba.tmq.common.domain.KeyValuePair;
import com.alibaba.tmq.common.domain.Message;
import com.alibaba.tmq.common.domain.MessageStatus;
import com.alibaba.tmq.common.domain.MessageType;
import com.alibaba.tmq.common.domain.remoting.ConnectionChannel;
import com.alibaba.tmq.common.domain.result.Result;
import com.alibaba.tmq.common.domain.result.ResultCode;
import com.alibaba.tmq.common.domain.result.SendResult;
import com.alibaba.tmq.common.domain.result.SubmitResult;
import com.alibaba.tmq.common.domain.result.UpdateResult;
import com.alibaba.tmq.common.exception.TMQClientException;
import com.alibaba.tmq.common.exception.TMQException;
import com.alibaba.tmq.common.exception.TMQServerException;
import com.alibaba.tmq.common.service.ServerService;
import com.alibaba.tmq.common.util.ListUtil;
import com.alibaba.tmq.common.util.LoggerUtil;
import com.alibaba.tmq.common.util.MessageUtil;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultNormalProducer
extends DefaultProducer
implements NormalProducer,
Constants {
    private static final Log logger = LogFactory.getLog(DefaultNormalProducer.class);
    private final ServerService serverService = ClientRemoting.proxyInterface(ServerService.class);
    private final ProducerConfig producerConfig;
    private final ProducerExecuter producerExecuter;

    public DefaultNormalProducer(ProducerConfig producerConfig, ProducerExecuter producerExecuter) {
        super(producerConfig, producerExecuter);
        this.producerConfig = producerConfig;
        this.producerExecuter = producerExecuter;
    }

    @Override
    public SubmitResult submit(Message message) throws TMQException {
        if (!this.producerExecuter.isStart()) {
            throw new TMQClientException("producer has just create, not start");
        }
        long startTime = System.currentTimeMillis();
        try {
            if (StringUtil.isNotBlank(clientConfig.getBackupDomainName())) {
                MessageUtil.reset(message, clientConfig.getBackupClusterId());
            } else {
                MessageUtil.reset(message, clientConfig.getClusterId());
            }
        }
        catch (Throwable e) {
            throw new TMQClientException(e);
        }
        Result<Boolean> checkResult = null;
        try {
            checkResult = MessageUtil.checkMessage(new MessageUtil(), message);
        }
        catch (Throwable e) {
            throw new TMQClientException(e);
        }
        if (!checkResult.getData().booleanValue()) {
            LoggerUtil.info(message, "[TMQ-CLIENT-PRODUCER]-submit-single-check-failed", startTime, clientConfig.getLocalAddress());
            return new SubmitResult(checkResult);
        }
        KeyValuePair<String, Message> messageKeyValue = MessageUtil.renderingMessage(this.producerConfig.getProducerId(), message, MessageStatus.READY_TO_FIRE, MessageType.NORMAL_ONCE);
        String server = clientRemoting.acquireFireServer(message.getMessageKey());
        if (StringUtil.isBlank(server)) {
            LoggerUtil.info(message, "[TMQ-CLIENT-PRODUCER]-submit-single-server-failed", startTime, clientConfig.getLocalAddress());
            throw new TMQServerException(ResultCode.SERVER_ERROR.getInformation());
        }
        Result<Boolean> result = this.submit(message, server);
        if (null == result) {
            String otherServer;
            List<String> serverList = clientRemoting.getServerList();
            if (StringUtil.isNotBlank(clientConfig.getBackupDomainName())) {
                serverList = clientRemoting.getbackupServerList();
            }
            if (ListUtil.isEmpty(serverList)) {
                LoggerUtil.info(message, "[TMQ-CLIENT-PRODUCER]-submit-single-server-empty", startTime, clientConfig.getLocalAddress());
                throw new TMQServerException(ResultCode.SERVER_ERROR.getInformation());
            }
            Iterator<String> iterator = serverList.iterator();
            while (iterator.hasNext() && (result = this.submit(message, otherServer = iterator.next())) == null) {
            }
        }
        if (null == result) {
            LoggerUtil.info(message, "[TMQ-CLIENT-PRODUCER]-submit-single-result-failed", startTime, clientConfig.getLocalAddress());
            throw new TMQClientException(ResultCode.TIMEOUT.getInformation());
        }
        LoggerUtil.info(message, "[TMQ-CLIENT-PRODUCER]-submit-single-" + result, startTime, clientConfig.getLocalAddress());
        if (ResultCode.CONNECTION_PRODUCER_IS_NULL_ERROR.equals(result.getResultCode())) {
            throw new TMQServerException(ResultCode.CONNECTION_PRODUCER_IS_NULL_ERROR.getInformation());
        }
        return new SubmitResult(result.getData(), result.getResultCode(), messageKeyValue);
    }

    private Result<Boolean> submit(Message message, String server) {
        Result<Boolean> result = null;
        try {
            ConnectionChannel connectionChannel = new ConnectionChannel(server, 0, this.producerConfig.getProducerId());
            connectionChannel.setTimeout(60000L);
            InvocationContext.setConnectionChannel(connectionChannel);
            result = this.serverService.submit(message);
        }
        catch (Throwable e) {
            logger.error((Object)("[DefaultNormalProducer]: submit message error, message:" + message + ", server:" + server), e);
        }
        return result;
    }

    @Override
    public SendResult send(Message message) throws TMQException {
        Result<Boolean> result;
        if (!this.producerExecuter.isStart()) {
            throw new TMQClientException("producer has just create, not start");
        }
        long startTime = System.currentTimeMillis();
        try {
            if (StringUtil.isNotBlank(clientConfig.getBackupDomainName())) {
                MessageUtil.reset(message, clientConfig.getBackupClusterId());
            } else {
                MessageUtil.reset(message, clientConfig.getClusterId());
            }
        }
        catch (Throwable e) {
            throw new TMQClientException(e);
        }
        Result<Boolean> checkResult = null;
        try {
            checkResult = MessageUtil.check4Send(message);
        }
        catch (Throwable e) {
            throw new TMQClientException(e);
        }
        if (!checkResult.getData().booleanValue()) {
            LoggerUtil.info(message, "[TMQ-CLIENT-PRODUCER]-send-single-check-failed", startTime, clientConfig.getLocalAddress());
            return new SendResult(checkResult);
        }
        KeyValuePair<String, Message> messageKeyValue = MessageUtil.renderingMessage(this.producerConfig.getProducerId(), message, MessageStatus.READY_TO_FIRE, MessageType.NORMAL_ONCE);
        String server = clientRemoting.acquireFireServer(message.getMessageKey());
        if (StringUtil.isBlank(server)) {
            LoggerUtil.info(message, "[TMQ-CLIENT-PRODUCER]-send-single-server-failed", startTime, clientConfig.getLocalAddress());
            throw new TMQServerException(ResultCode.SERVER_ERROR.getInformation());
        }
        if (EagleEye.getUserData("t") != null && EagleEye.getUserData("t").equals("1")) {
            message.setTb_eagleeyex_t("1");
            logger.warn((Object)("[DefaultNormalProducer]: set tb_eagleeyex_t, message:" + message));
        }
        if (null == (result = this.send(message, server))) {
            String otherServer;
            List<String> serverList = clientRemoting.getServerList();
            if (StringUtil.isNotBlank(clientConfig.getBackupDomainName())) {
                serverList = clientRemoting.getbackupServerList();
            }
            if (ListUtil.isEmpty(serverList)) {
                LoggerUtil.info(message, "[TMQ-CLIENT-PRODUCER]-send-single-server-empty", startTime, clientConfig.getLocalAddress());
                throw new TMQServerException(ResultCode.SERVER_ERROR.getInformation());
            }
            Iterator<String> iterator = serverList.iterator();
            while (iterator.hasNext() && (result = this.send(message, otherServer = iterator.next())) == null) {
            }
        }
        if (null == result) {
            LoggerUtil.info(message, "[TMQ-CLIENT-PRODUCER]-send-single-result-failed", startTime, clientConfig.getLocalAddress());
            throw new TMQClientException(ResultCode.TIMEOUT.getInformation());
        }
        LoggerUtil.info(message, "[TMQ-CLIENT-PRODUCER]-send-single-" + result, startTime, clientConfig.getLocalAddress());
        if (ResultCode.CONNECTION_PRODUCER_IS_NULL_ERROR.equals(result.getResultCode())) {
            throw new TMQServerException(ResultCode.CONNECTION_PRODUCER_IS_NULL_ERROR.getInformation());
        }
        return new SendResult(result.getData(), result.getResultCode(), messageKeyValue);
    }

    private Result<Boolean> send(Message message, String server) {
        Result<Boolean> result = null;
        try {
            ConnectionChannel connectionChannel = new ConnectionChannel(server, 0, this.producerConfig.getProducerId());
            connectionChannel.setTimeout(60000L);
            InvocationContext.setConnectionChannel(connectionChannel);
            result = this.serverService.send(message);
        }
        catch (Throwable e) {
            logger.error((Object)("[DefaultNormalProducer]: send message error, message:" + message), e);
        }
        return result;
    }

    @Override
    public SubmitResult submit(List<? extends Message> messageList) throws TMQException {
        if (!this.producerExecuter.isStart()) {
            throw new TMQClientException("producer has just create, not start");
        }
        long startTime = System.currentTimeMillis();
        try {
            if (StringUtil.isNotBlank(clientConfig.getBackupDomainName())) {
                MessageUtil.reset(messageList, clientConfig.getBackupClusterId());
            } else {
                MessageUtil.reset(messageList, clientConfig.getClusterId());
            }
        }
        catch (Throwable e) {
            throw new TMQClientException(e);
        }
        Result<Boolean> checkResult = null;
        try {
            checkResult = MessageUtil.checkMessage(new MessageUtil(), messageList);
        }
        catch (Throwable e) {
            throw new TMQClientException(e);
        }
        if (!checkResult.getData().booleanValue()) {
            LoggerUtil.info(messageList, "[TMQ-CLIENT-PRODUCER]-submit-mulit-check-failed", startTime, clientConfig.getLocalAddress());
            return new SubmitResult(checkResult);
        }
        List<KeyValuePair<String, Message>> messageKeyValueList = MessageUtil.rendering(this.producerConfig.getProducerId(), messageList, MessageStatus.READY_TO_FIRE, MessageType.NORMAL_ONCE);
        String server = clientRemoting.acquireFireServer(messageList.get(0).getMessageKey());
        if (StringUtil.isBlank(server)) {
            LoggerUtil.info(messageList, "[TMQ-CLIENT-PRODUCER]-submit-mulit-server-failed", startTime, clientConfig.getLocalAddress());
            throw new TMQServerException(ResultCode.SERVER_ERROR.getInformation());
        }
        Result<Boolean> result = this.submit(messageList, server);
        if (null == result) {
            String otherServer;
            List<String> serverList = clientRemoting.getServerList();
            if (StringUtil.isNotBlank(clientConfig.getBackupDomainName())) {
                serverList = clientRemoting.getbackupServerList();
            }
            if (ListUtil.isEmpty(serverList)) {
                LoggerUtil.info(messageList, "[TMQ-CLIENT-PRODUCER]-submit-mulit-server-empty", startTime, clientConfig.getLocalAddress());
                throw new TMQServerException(ResultCode.SERVER_ERROR.getInformation());
            }
            Iterator<String> iterator = serverList.iterator();
            while (iterator.hasNext() && (result = this.submit(messageList, otherServer = iterator.next())) == null) {
            }
        }
        if (null == result) {
            LoggerUtil.info(messageList, "[TMQ-CLIENT-PRODUCER]-submit-mulit-result-failed", startTime, clientConfig.getLocalAddress());
            throw new TMQClientException(ResultCode.TIMEOUT.getInformation());
        }
        LoggerUtil.info(messageList, "[TMQ-CLIENT-PRODUCER]-submit-mulit-" + result, startTime, clientConfig.getLocalAddress());
        if (ResultCode.CONNECTION_PRODUCER_IS_NULL_ERROR.equals(result.getResultCode())) {
            throw new TMQServerException(ResultCode.CONNECTION_PRODUCER_IS_NULL_ERROR.getInformation());
        }
        return new SubmitResult(result.getData(), result.getResultCode(), messageKeyValueList);
    }

    public Result<Boolean> submit(List<? extends Message> messageList, String server) {
        Result<Boolean> result = null;
        try {
            ConnectionChannel connectionChannel = new ConnectionChannel(server, 0, this.producerConfig.getProducerId());
            connectionChannel.setTimeout(60000L);
            InvocationContext.setConnectionChannel(connectionChannel);
            result = this.serverService.submit(messageList);
        }
        catch (Throwable e) {
            logger.error((Object)("[DefaultNormalProducer]: submit messageList error, messageList:" + messageList + ", server:" + server), e);
        }
        return result;
    }

    @Override
    public SendResult send(List<Message> messageList) throws TMQException {
        if (!this.producerExecuter.isStart()) {
            throw new TMQClientException("producer has just create, not start");
        }
        long startTime = System.currentTimeMillis();
        try {
            if (StringUtil.isNotBlank(clientConfig.getBackupDomainName())) {
                MessageUtil.reset(messageList, clientConfig.getBackupClusterId());
            } else {
                MessageUtil.reset(messageList, clientConfig.getClusterId());
            }
        }
        catch (Throwable e) {
            throw new TMQClientException(e);
        }
        Result<Boolean> checkResult = null;
        try {
            checkResult = MessageUtil.check4Send(messageList);
        }
        catch (Throwable e) {
            throw new TMQClientException(e);
        }
        if (!checkResult.getData().booleanValue()) {
            LoggerUtil.info(messageList, "[TMQ-CLIENT-PRODUCER]-send-mulit-check-failed", startTime, clientConfig.getLocalAddress());
            return new SendResult(checkResult);
        }
        List<KeyValuePair<String, Message>> messageKeyValueList = MessageUtil.renderingMessage(this.producerConfig.getProducerId(), messageList, MessageStatus.READY_TO_FIRE, MessageType.NORMAL_ONCE);
        String server = clientRemoting.acquireFireServer(messageList.get(0).getMessageKey());
        if (StringUtil.isBlank(server)) {
            LoggerUtil.info(messageList, "[TMQ-CLIENT-PRODUCER]-send-mulit-server-failed", startTime, clientConfig.getLocalAddress());
            throw new TMQServerException(ResultCode.SERVER_ERROR.getInformation());
        }
        Result<Boolean> result = this.send(messageList, server);
        if (null == result) {
            String otherServer;
            List<String> serverList = clientRemoting.getServerList();
            if (StringUtil.isNotBlank(clientConfig.getBackupDomainName())) {
                serverList = clientRemoting.getbackupServerList();
            }
            if (ListUtil.isEmpty(serverList)) {
                LoggerUtil.info(messageList, "[TMQ-CLIENT-PRODUCER]-send-mulit-server-empty", startTime, clientConfig.getLocalAddress());
                throw new TMQServerException(ResultCode.SERVER_ERROR.getInformation());
            }
            Iterator<String> iterator = serverList.iterator();
            while (iterator.hasNext() && (result = this.send(messageList, otherServer = iterator.next())) == null) {
            }
        }
        if (null == result) {
            LoggerUtil.info(messageList, "[TMQ-CLIENT-PRODUCER]-send-mulit-result-failed", startTime, clientConfig.getLocalAddress());
            throw new TMQClientException(ResultCode.TIMEOUT.getInformation());
        }
        LoggerUtil.info(messageList, "[TMQ-CLIENT-PRODUCER]-send-mulit-" + result, startTime, clientConfig.getLocalAddress());
        if (ResultCode.CONNECTION_PRODUCER_IS_NULL_ERROR.equals(result.getResultCode())) {
            throw new TMQServerException(ResultCode.CONNECTION_PRODUCER_IS_NULL_ERROR.getInformation());
        }
        return new SendResult(result.getData(), result.getResultCode(), messageKeyValueList);
    }

    private Result<Boolean> send(List<Message> messageList, String server) {
        Result<Boolean> result = null;
        try {
            ConnectionChannel connectionChannel = new ConnectionChannel(server, 0, this.producerConfig.getProducerId());
            connectionChannel.setTimeout(60000L);
            InvocationContext.setConnectionChannel(connectionChannel);
            result = this.serverService.send(messageList);
        }
        catch (Throwable e) {
            logger.error((Object)("[DefaultNormalProducer]: send messageList error, messageList:" + messageList), e);
        }
        return result;
    }

    @Override
    public UpdateResult update(List<Message> messageList) throws TMQException {
        if (!this.producerExecuter.isStart()) {
            throw new TMQClientException("producer has just create, not start");
        }
        long startTime = System.currentTimeMillis();
        try {
            if (StringUtil.isNotBlank(clientConfig.getBackupDomainName())) {
                MessageUtil.reset(messageList, clientConfig.getBackupClusterId());
            } else {
                MessageUtil.reset(messageList, clientConfig.getClusterId());
            }
        }
        catch (Throwable e) {
            throw new TMQClientException(e);
        }
        Result<Boolean> checkResult = null;
        try {
            checkResult = MessageUtil.check4Send(messageList);
        }
        catch (Throwable e) {
            throw new TMQClientException(e);
        }
        if (!checkResult.getData().booleanValue()) {
            LoggerUtil.info(messageList, "[TMQ-CLIENT-PRODUCER]-update-mulit-check-failed", startTime, clientConfig.getLocalAddress());
            return new UpdateResult(checkResult);
        }
        List<KeyValuePair<String, Message>> messageKeyValueList = MessageUtil.renderingMessage(this.producerConfig.getProducerId(), messageList, MessageStatus.READY_TO_FIRE, MessageType.NORMAL_ONCE);
        UpdateResult updateResult = super.updateMessageList(messageList);
        updateResult.setMessageKeyValueList(messageKeyValueList);
        LoggerUtil.info(messageList, "[TMQ-CLIENT-PRODUCER]-update-mulit-" + updateResult, startTime, clientConfig.getLocalAddress());
        if (ResultCode.CONNECTION_PRODUCER_IS_NULL_ERROR.equals(updateResult.getResultCode())) {
            throw new TMQServerException(ResultCode.CONNECTION_PRODUCER_IS_NULL_ERROR.getInformation());
        }
        return updateResult;
    }

    @Override
    public void shutdown() {
        this.producerExecuter.setStart(false);
        TMQFactory.removeNormalProducer(this.producerConfig.getProducerId(), this.producerConfig.getInstanceName());
        try {
            clientRemoting.removeConnection(this.producerConfig.getInstanceName(), 0, this.producerConfig.getProducerId(), "NULL", "NULL");
        }
        catch (Throwable e) {
            logger.error((Object)("[DefaultNormalProducer]: shutdown removeConnection error, clientConfig:" + clientConfig + ", producerConfig:" + this.producerConfig), e);
        }
    }
}

