/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tmq.common.domain;

import com.alibaba.tmq.common.constants.Constants;
import com.alibaba.tmq.common.domain.Message;
import java.io.Serializable;
import java.util.Date;

public class MessageKey
implements Constants,
Serializable,
Comparable<MessageKey> {
    private static final long serialVersionUID = -1841473336704097028L;
    private String messageId;
    private String messageKey;
    private Date fireTime;

    public MessageKey() {
    }

    public MessageKey(Message message) {
        this.messageId = new String(message.getMessageId());
        this.messageKey = new String(message.getMessageKey());
        this.fireTime = (Date)message.getFireTime().clone();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fireTime == null ? 0 : this.fireTime.hashCode());
        result = 31 * result + (this.messageId == null ? 0 : this.messageId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MessageKey other = (MessageKey)obj;
        if (this.fireTime == null ? other.fireTime != null : !this.fireTime.equals(other.fireTime)) {
            return false;
        }
        return !(this.messageId == null ? other.messageId != null : !this.messageId.equals(other.messageId));
    }

    @Override
    public int compareTo(MessageKey o) {
        if (this.fireTime.after(o.getFireTime())) {
            return 1;
        }
        if (this.fireTime.before(o.getFireTime())) {
            return -1;
        }
        return this.messageId.compareTo(o.getMessageId());
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = new String(messageId);
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public void setMessageKey(String messageKey) {
        this.messageKey = messageKey;
    }

    public Date getFireTime() {
        return this.fireTime;
    }

    public void setFireTime(Date fireTime) {
        this.fireTime = (Date)fireTime.clone();
    }

    public String toString() {
        return "MessageKey [messageId=" + this.messageId + ", messageKey=" + this.messageKey + ", fireTime=" + this.fireTime + "], fireTime:" + this.fireTime.getTime();
    }
}

