/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tmq.common.service;

import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.shade.org.apache.commons.HttpClient;
import com.alibaba.dts.shade.org.apache.commons.methods.PostMethod;
import com.alibaba.tmq.common.constants.Constants;
import com.alibaba.tmq.common.domain.KeyValuePair;
import com.alibaba.tmq.common.domain.ServerList;
import java.util.List;

public class HttpService
implements Constants {
    public static final String DOMAIN_NAME_DATA_ID = "com.alibaba.tmq.common.domainName";
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(HttpService.class);
    private static final int timeout = 10000;
    private static final int httpConnectionFactoryTimeout = 10000;
    private static final int connectionTimeout = 10000;
    public static final String DEFAULT_CHARSET = "UTF-8";

    public List<String> acquireServers(String domainName, long clusterId) {
        String url = "http://" + domainName + "/tmq-console/apiManager.do?action=ApiAction&event_submit_do_acquire_servers=1&clusterId=" + clusterId;
        String result = null;
        try {
            result = this.go(url);
        }
        catch (Throwable e) {
            logger.warn("[HttpService]: acquireServers error, url:" + url, e);
        }
        ServerList serverList = null;
        try {
            serverList = ServerList.newInstance(result);
        }
        catch (Throwable e) {
            logger.warn("[HttpService]: ServerList.newInstance error, url:" + url + ", result:" + result, e);
        }
        if (null == serverList) {
            logger.warn("[HttpService]: ServerList.newInstance failed, url:" + url + ", result:" + result);
            return null;
        }
        return serverList.getServers();
    }

    private String go(String url) {
        KeyValuePair<Integer, PostMethod> pair = this.request(url);
        try {
            return pair.getValue().getResponseBodyAsString();
        }
        catch (Throwable e) {
            logger.warn("[HttpService]: go getResponseBodyAsString error, url:" + url, e);
            return null;
        }
    }

    public KeyValuePair<Integer, PostMethod> request(String url) {
        HttpClient client = new HttpClient();
        client.setTimeout(10000);
        client.setConnectionTimeout(10000);
        client.setHttpConnectionFactoryTimeout(10000L);
        PostMethod post = new PostMethod(url);
        post.addRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        int resultCode = 0;
        try {
            resultCode = client.executeMethod(post);
        }
        catch (Throwable e) {
            logger.warn("[HttpService]: executeMethod error, post:" + post, e);
        }
        return new KeyValuePair<Integer, PostMethod>(resultCode, post);
    }
}

